/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api;

import java.awt.Image;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static ResultIterator getResultIterator(ResultIterator resultIterator, String string) {
        for (Embedding embedding : resultIterator.getEmbeddings()) {
            ResultIterator resultIterator2 = resultIterator.getResultIterator(embedding);
            if (embedding.getMimeType().equals(string)) {
                return resultIterator2;
            }
            ResultIterator resultIterator3 = Utils.getResultIterator(resultIterator2, string);
            if (resultIterator3 == null) continue;
            return resultIterator3;
        }
        return null;
    }

    public static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = Utils.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public static Image getIcon(FileObject fileObject) {
        try {
            return DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, "Cannot find icon for " + fileObject.getNameExt(), dataObjectNotFoundException);
            return null;
        }
    }

    public static TokenSequence<HTMLTokenId> getJoinedHtmlSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        while (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            if (tokenSequence.language() == HTMLTokenId.language()) {
                return tokenSequence;
            }
            if ((tokenSequence = tokenSequence.embeddedJoined()) == null) break;
            tokenSequence.move(n);
        }
        return null;
    }
}

