/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.i18n.HelpStringCustomEditor;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class PropertyPanel
extends JPanel {
    public static final String PROP_STRING = "propString";
    public static final String PROP_RESOURCE = "property_resource";
    private static final String DUMMY_ACTION = "dont_proceed";
    protected I18nString i18nString;
    private FileObject file;
    private int internalTextChange = 0;
    private String innerResourceTextContent;
    protected JButton argumentsButton;
    private JButton browseButton;
    private JLabel commentLabel;
    private JScrollPane commentScroll;
    private JTextArea commentText;
    private JLabel bundleNameLabel;
    private JComboBox keyBundleCombo;
    private JLabel keyLabel;
    private JButton replaceFormatButton;
    private JLabel replaceFormatLabel;
    private JTextField replaceFormatTextField;
    private JTextField resourceText;
    private JLabel valueLabel;
    private JScrollPane valueScroll;
    private JTextArea valueText;
    private JLabel warningLabel;

    public PropertyPanel() {
        this.initComponents();
        this.myInitComponents();
        this.initAccessibility();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.commentText.setEnabled(bl);
        this.commentLabel.setEnabled(bl);
        this.commentScroll.setEnabled(bl);
        this.keyBundleCombo.setEnabled(bl);
        this.keyLabel.setEnabled(bl);
        this.replaceFormatButton.setEnabled(bl);
        this.replaceFormatLabel.setEnabled(bl);
        this.replaceFormatTextField.setEnabled(bl);
        this.valueLabel.setEnabled(bl);
        this.valueText.setEnabled(bl);
        this.valueScroll.setEnabled(bl);
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateAllValues();
        this.firePropertyChange(PROP_STRING, null, null);
    }

    public void setFile(FileObject fileObject) {
        this.file = fileObject;
    }

    public FileObject getFile() {
        return this.file;
    }

    void updateAllValues() {
        this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
        this.innerResourceTextContent = this.resourceText.getText();
        this.updateBundleKeys();
        this.updateKey();
        this.updateValue();
        this.updateComment();
        this.warningLabel.setText("");
    }

    private void updateKey() {
        String string = this.i18nString.getKey();
        if (string == null || !string.equals(this.keyBundleCombo.getSelectedItem())) {
            String string2 = this.keyBundleCombo.getActionCommand();
            this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
            ++this.internalTextChange;
            this.keyBundleCombo.setSelectedItem(string != null ? string : "");
            --this.internalTextChange;
            this.keyBundleCombo.setActionCommand(string2);
        }
        this.updateReplaceText();
    }

    private void updateValue() {
        String string = this.i18nString.getValue();
        if (!this.valueText.getText().equals(string)) {
            this.valueText.setText(string != null ? string : "");
        }
        this.updateReplaceText();
    }

    private void updateComment() {
        String string = this.i18nString.getComment();
        if (!this.commentText.getText().equals(string)) {
            this.commentText.setText(string != null ? string : "");
        }
    }

    protected void updateReplaceText() {
        this.replaceFormatTextField.setText(this.i18nString.getReplaceString());
    }

    void updateBundleKeys() {
        String string = this.keyBundleCombo.getActionCommand();
        this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
        ++this.internalTextChange;
        Object[] objectArray = this.i18nString.getSupport().getResourceHolder().getAllKeys();
        Arrays.sort(objectArray);
        this.keyBundleCombo.setModel(new DefaultComboBoxModel<Object>(objectArray));
        --this.internalTextChange;
        this.keyBundleCombo.setActionCommand(string);
        this.updateKey();
    }

    private void changeResource(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException();
        }
        DataObject dataObject2 = this.i18nString.getSupport().getResourceHolder().getResource();
        if (dataObject2 != null && dataObject2.equals(dataObject)) {
            return;
        }
        this.i18nString.getSupport().getResourceHolder().setResource(dataObject);
        String string = this.i18nString.getSupport().getResourceHolder().getValueForKey(this.i18nString.getKey());
        if (string != null) {
            this.i18nString.setValue(string);
        }
        this.updateAllValues();
        this.firePropertyChange(PROP_RESOURCE, dataObject2, dataObject);
        I18nUtil.getOptions().setLastResource2(dataObject);
    }

    public void setResource(DataObject dataObject) {
        if (this.isResourceClass(dataObject.getClass())) {
            this.changeResource(dataObject);
        }
    }

    private boolean isResourceClass(Class clazz) {
        return Arrays.asList(this.i18nString.getSupport().getResourceHolder().getResourceClasses()).contains(clazz);
    }

    private String getResourceName(DataObject dataObject) {
        if (dataObject == null) {
            return "";
        }
        String string = Util.getResourceName(this.file, dataObject.getPrimaryFile(), '.', false);
        return string != null ? string : "";
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_PropertyPanel"));
        this.valueText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_valueText"));
        this.commentText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_commentText"));
        this.replaceFormatButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_Format"));
        this.replaceFormatTextField.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_replaceFormatTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_BrowseButton"));
        this.resourceText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourceText"));
    }

    private void myInitComponents() {
        this.argumentsButton.setVisible(false);
        ((JTextField)this.keyBundleCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.keyBundleTextChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.keyBundleTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.keyBundleTextChanged();
            }
        });
        this.valueText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.valueTextChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.valueTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.valueTextChanged();
            }
        });
    }

    private void keyBundleTextChanged() {
        String string;
        if (this.internalTextChange == 0 && !(string = ((JTextField)this.keyBundleCombo.getEditor().getEditorComponent()).getText()).equals(this.i18nString.getKey())) {
            this.i18nString.setKey(string);
            this.firePropertyChange(PROP_STRING, null, null);
        }
    }

    private void valueTextChanged() {
        this.i18nString.setValue(this.valueText.getText());
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void initComponents() {
        this.commentLabel = new JLabel();
        this.commentScroll = new JScrollPane();
        this.commentText = new JTextArea();
        this.keyLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.valueScroll = new JScrollPane();
        this.valueText = new JTextArea();
        this.keyBundleCombo = new JComboBox();
        this.replaceFormatTextField = new JTextField();
        this.replaceFormatLabel = new JLabel();
        this.replaceFormatButton = new JButton();
        this.bundleNameLabel = new JLabel();
        this.resourceText = new JTextField();
        this.argumentsButton = new JButton();
        this.browseButton = new JButton();
        this.warningLabel = new JLabel();
        this.warningLabel.setForeground(Color.RED);
        this.commentLabel.setLabelFor(this.commentText);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)I18nUtil.getBundle().getString("LBL_Comment"));
        this.commentText.setRows(2);
        this.commentText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PropertyPanel.this.commentTextFocusLost(focusEvent);
            }
        });
        this.commentScroll.setViewportView(this.commentText);
        this.keyLabel.setLabelFor(this.keyBundleCombo);
        Mnemonics.setLocalizedText((JLabel)this.keyLabel, (String)I18nUtil.getBundle().getString("LBL_Key"));
        this.valueLabel.setLabelFor(this.valueText);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)I18nUtil.getBundle().getString("LBL_Value"));
        this.valueText.setRows(2);
        this.valueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PropertyPanel.this.valueTextFocusLost(focusEvent);
            }
        });
        this.valueScroll.setViewportView(this.valueText);
        this.keyBundleCombo.setEditable(true);
        this.keyBundleCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPanel.this.keyBundleComboActionPerformed(actionEvent);
            }
        });
        this.replaceFormatTextField.setColumns(35);
        this.replaceFormatTextField.setEditable(false);
        this.replaceFormatTextField.selectAll();
        this.replaceFormatTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                PropertyPanel.this.replaceFormatTextFieldFocusGained(focusEvent);
            }
        });
        this.replaceFormatLabel.setLabelFor(this.replaceFormatTextField);
        Mnemonics.setLocalizedText((JLabel)this.replaceFormatLabel, (String)I18nUtil.getBundle().getString("LBL_ReplaceFormat"));
        Mnemonics.setLocalizedText((AbstractButton)this.replaceFormatButton, (String)I18nUtil.getBundle().getString("CTL_Format"));
        this.replaceFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPanel.this.replaceFormatButtonActionPerformed(actionEvent);
            }
        });
        this.bundleNameLabel.setLabelFor(this.resourceText);
        Mnemonics.setLocalizedText((JLabel)this.bundleNameLabel, (String)I18nUtil.getBundle().getString("LBL_BundleName"));
        this.resourceText.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.argumentsButton, (String)I18nUtil.getBundle().getString("CTL_Arguments"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)I18nUtil.getBundle().getString("CTL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.resourceText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PropertyPanel.this.resourceTextKeyReleased(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup().add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.bundleNameLabel).add((Component)this.valueLabel).add((Component)this.commentLabel).add((Component)this.keyLabel).add((Component)this.replaceFormatLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.resourceText).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.warningLabel).add((Component)this.keyBundleCombo, 0, -2, Short.MAX_VALUE).add((Component)this.valueScroll).add((Component)this.commentScroll).add((Component)this.replaceFormatTextField))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.argumentsButton).addPreferredGap(0).add((Component)this.replaceFormatButton))).addContainerGap());
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.bundleNameLabel).add((Component)this.resourceText).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.warningLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyLabel).add((Component)this.keyBundleCombo)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.valueLabel).add((Component)this.valueScroll)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.commentLabel).add((Component)this.commentScroll)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.replaceFormatTextField).add((Component)this.replaceFormatLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.replaceFormatButton).add((Component)this.argumentsButton)).addContainerGap());
    }

    private void resourceTextKeyReleased(KeyEvent keyEvent) {
        if (!this.innerResourceTextContent.equals(this.resourceText.getText()) && this.resourceText.getText().trim().length() != 0) {
            String string = this.resourceText.getText().replaceAll("[.]", "/").concat(".properties");
            FileObject fileObject = Util.getResource(this.file, string);
            if (fileObject != null && fileObject.isValid() && !fileObject.isVirtual()) {
                try {
                    this.setResource(DataObject.find((FileObject)fileObject));
                    this.warningLabel.setText("");
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            } else {
                this.warningLabel.setText(I18nUtil.getBundle().getString("LBL_InvalidBundle") + string);
                this.setEmptyResource();
            }
        } else {
            this.warningLabel.setText("");
            if ("".equals(this.resourceText.getText())) {
                this.setEmptyResource();
            }
        }
    }

    private void setEmptyResource() {
        SaveCookie saveCookie;
        DataObject dataObject = this.i18nString.getSupport().getResourceHolder().getResource();
        if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        this.i18nString.getSupport().getResourceHolder().setResource(null);
        this.firePropertyChange(PROP_RESOURCE, dataObject, null);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        DataObject dataObject;
        Class clazz;
        ResourceHolder resourceHolder = this.i18nString.getSupport().getResourceHolder();
        try {
            clazz = resourceHolder.getResourceClasses()[0];
            dataObject = resourceHolder.getTemplate(clazz);
            if (dataObject == null) {
                throw new NullPointerException("A template is not created for the class " + clazz + "\nPlease, check an implementation of " + "the createTemplate(Class) method " + "for the following resource holder:\n" + resourceHolder.toString());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return;
        }
        catch (NullPointerException nullPointerException) {
            ErrorManager.getDefault().notify((Throwable)nullPointerException);
            return;
        }
        clazz = SelectorUtils.selectOrCreateBundle(this.file, dataObject, this.i18nString.getSupport().getResourceHolder().getResource());
        if (clazz != null) {
            this.changeResource((DataObject)clazz);
            this.warningLabel.setText("");
        }
    }

    private void replaceFormatTextFieldFocusGained(FocusEvent focusEvent) {
        this.replaceFormatTextField.selectAll();
    }

    private boolean isReplaceFormatValid(String string) {
        I18nString i18nString = (I18nString)this.i18nString.clone();
        i18nString.setReplaceFormat(string);
        return i18nString.getReplaceString() != null;
    }

    private void replaceFormatButtonActionPerformed(ActionEvent actionEvent) {
        final Dialog[] dialogArray = new Dialog[1];
        final HelpStringCustomEditor helpStringCustomEditor = new HelpStringCustomEditor(this.i18nString.getReplaceFormat(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), "i18n.pe.replacestring");
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)helpStringCustomEditor, I18nUtil.getBundle().getString("LBL_ReplaceStringFormatEditor"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == DialogDescriptor.OK_OPTION) {
                    String string = (String)helpStringCustomEditor.getPropertyValue();
                    if (!string.equals(PropertyPanel.this.replaceFormatTextField.getText())) {
                        PropertyPanel.this.i18nString.setReplaceFormat(string);
                        PropertyPanel.this.updateReplaceText();
                        PropertyPanel.this.firePropertyChange(PropertyPanel.PROP_STRING, null, null);
                        I18nUtil.getOptions().setReplaceJavaCode(string);
                    }
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                } else if (object == DialogDescriptor.CANCEL_OPTION) {
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                }
            }
        });
        dialogDescriptor.setValid(this.isReplaceFormatValid(this.i18nString.getReplaceFormat()));
        for (Component component : helpStringCustomEditor.getComponents()) {
            if (!(component instanceof JComboBox)) continue;
            try {
                ((JTextField)((JComboBox)component).getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        try {
                            dialogDescriptor.setValid(PropertyPanel.this.isReplaceFormatValid(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength())));
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        try {
                            dialogDescriptor.setValid(PropertyPanel.this.isReplaceFormatValid(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength())));
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        try {
                            dialogDescriptor.setValid(PropertyPanel.this.isReplaceFormatValid(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength())));
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            break;
        }
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].setVisible(true);
    }

    private void keyBundleComboActionPerformed(ActionEvent actionEvent) {
        String string;
        if (DUMMY_ACTION.equals(actionEvent.getActionCommand())) {
            return;
        }
        String string2 = (String)this.keyBundleCombo.getSelectedItem();
        this.i18nString.setKey(string2);
        this.updateKey();
        String string3 = this.i18nString.getSupport().getResourceHolder().getValueForKey(string2);
        if (string3 != null) {
            this.i18nString.setValue(string3);
            this.updateValue();
        }
        if ((string = this.i18nString.getSupport().getResourceHolder().getCommentForKey(string2)) != null) {
            this.i18nString.setComment(string);
            this.updateComment();
        }
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void commentTextFocusLost(FocusEvent focusEvent) {
        this.i18nString.setComment(this.commentText.getText());
        this.updateComment();
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void valueTextFocusLost(FocusEvent focusEvent) {
        this.valueTextChanged();
    }
}

