/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
extends NodeImpl
implements Node,
Attr {
    private String name = null;
    private String value = null;
    private static final Pattern AMPERSAND_PATTERN = Pattern.compile("&amp;");
    private static final Pattern LESS_THAN_PATTERN = Pattern.compile("&lt;");
    private static final Pattern APOSTROPHE_PATTERN = Pattern.compile("&apos;");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("&quot;");

    Attribute() {
    }

    Attribute(String string) {
        List<Token> list = this.getTokensForWrite();
        list.add(Token.create(" ", TokenType.TOKEN_WHITESPACE));
        list.add(Token.create(string, TokenType.TOKEN_ATTR_NAME));
        list.add(Token.create("=", TokenType.TOKEN_ATTR_EQUAL));
        list.add(Token.create("\"\"", TokenType.TOKEN_ATTR_VAL));
    }

    Attribute(String string, String string2) {
        List<Token> list = this.getTokensForWrite();
        list.add(Token.create(" ", TokenType.TOKEN_WHITESPACE));
        list.add(Token.create(string, TokenType.TOKEN_ATTR_NAME));
        list.add(Token.create("=", TokenType.TOKEN_ATTR_EQUAL));
        list.add(Token.create("\"".concat(this.insertEntityReference(string2)).concat("\""), TokenType.TOKEN_ATTR_VAL));
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public boolean getSpecified() {
        return false;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public Element getOwnerElement() {
        return (Element)((Object)super.getParentNode());
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    private void validateTokens(List<Token> list) {
        assert (list != null);
        assert (list.size() >= 3 && list.size() <= 6);
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (Token token : list) {
            if (token.getType() == TokenType.TOKEN_ATTR_NAME) {
                if (n2 != -1) {
                    throw new IllegalArgumentException();
                }
                n2 = n;
            } else if (token.getType() == TokenType.TOKEN_ATTR_EQUAL) {
                if (n3 != -1 || n2 == -1) {
                    throw new IllegalArgumentException();
                }
                n3 = n;
            } else if (token.getType() == TokenType.TOKEN_ATTR_VAL) {
                if (n4 != -1 || n3 == -1) {
                    throw new IllegalArgumentException();
                }
                n4 = n;
            } else if (token.getType() != TokenType.TOKEN_WHITESPACE) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
        if (n2 == -1 || n3 == -1 || n4 == -1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    void setTokens(List<Token> list) {
        this.name = null;
        this.value = null;
        super.setTokens(list);
    }

    @Override
    public void accept(XMLNodeVisitor xMLNodeVisitor) {
        xMLNodeVisitor.visit(this);
    }

    @Override
    public String getLocalName() {
        int n;
        String string = this.getName();
        if (string != null && (n = string.indexOf(58) + 1) > 0) {
            return string.substring(n);
        }
        return string;
    }

    public void setLocalName(String string) {
        String string2 = this.getPrefix();
        if (string2 == null) {
            this.setName(string);
        } else if (string == null || string.equals("")) {
            this.setName(string2);
        } else {
            this.setName(string2.concat(":").concat(string));
        }
    }

    @Override
    public String getPrefix() {
        int n;
        String string = this.getName();
        if (string != null && (n = string.indexOf(58)) > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    @Override
    public void setPrefix(String string) {
        String string2 = this.getLocalName();
        if (string == null || string.equals("")) {
            this.setName(string2);
        } else {
            this.setName(string.concat(":").concat(string2));
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            for (Token token : this.getTokens()) {
                if (token.getType() != TokenType.TOKEN_ATTR_NAME) continue;
                this.name = token.getValue();
                break;
            }
        }
        return this.name;
    }

    public void setName(String string) {
        assert (string != null && !"".equals(string));
        this.checkNotInTree();
        this.name = string;
        int n = -1;
        for (Token token : this.getTokens()) {
            ++n;
            if (token.getType() != TokenType.TOKEN_ATTR_NAME) continue;
            Token token2 = Token.create(string, TokenType.TOKEN_ATTR_NAME);
            this.getTokensForWrite().set(n, token2);
            return;
        }
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            for (Token token : this.getTokens()) {
                if (token.getType() != TokenType.TOKEN_ATTR_VAL) continue;
                String string = token.getValue();
                int n = string.length();
                if (n <= 2) {
                    this.value = "";
                    continue;
                }
                this.value = this.removeEntityReference(string.substring(1, n - 1));
            }
        }
        return this.value;
    }

    @Override
    public void setValue(String string) {
        this.checkNotInTree();
        this.value = string;
        int n = -1;
        for (Token token : this.getTokens()) {
            ++n;
            if (token.getType() != TokenType.TOKEN_ATTR_VAL) continue;
            String string2 = token.getValue();
            String string3 = string2.charAt(0) + this.insertEntityReference(string) + string2.charAt(string2.length() - 1);
            Token token2 = Token.create(string3, TokenType.TOKEN_ATTR_VAL);
            this.getTokensForWrite().set(n, token2);
            return;
        }
    }

    public boolean isXmlnsAttribute() {
        return "xmlns".equals(this.getPrefix()) || "xmlns".equals(this.getName());
    }

    @Override
    protected void cloneNamespacePrefixes(Map<Integer, String> map, Map<String, String> map2) {
        String string;
        String string2;
        if (map == null) {
            return;
        }
        String[] stringArray = this.getValue().split(":");
        String string3 = string2 = stringArray.length > 1 ? stringArray[0] : null;
        if (string2 != null && (string = this.lookupNamespaceURI(string2)) != null) {
            map2.put(string2, string);
        }
        super.cloneNamespacePrefixes(map, map2);
    }

    private String insertEntityReference(String string) {
        String string2 = this.removeEntityReference(string);
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll("'", "&apos;");
        string2 = string2.replaceAll("\"", "&quot;");
        return string2;
    }

    private String removeEntityReference(String string) {
        String string2 = string;
        string2 = AMPERSAND_PATTERN.matcher(string2).replaceAll("&");
        string2 = LESS_THAN_PATTERN.matcher(string2).replaceAll("<");
        string2 = APOSTROPHE_PATTERN.matcher(string2).replaceAll("'");
        string2 = QUOTE_PATTERN.matcher(string2).replaceAll("\"");
        return string2;
    }
}

