/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

class TcpConnector
implements MsgConnector {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    OutputStream out;
    InputStream in;
    MsgBuffer msg = new MsgBuffer(8192);

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
    }

    public MsgBuffer getMsgBuffer() {
        this.msg.reset();
        return this.msg;
    }

    public int receive(MsgBuffer msg) throws IOException {
        byte[] b = msg.getBuff();
        if (this.receiveFully(b, 0, 4) < 4) {
            return -1;
        }
        int len = msg.checkIn();
        int read = this.receiveFully(b, 4, len);
        return read;
    }

    private int receiveFully(byte[] buff, int off, int len) throws IOException {
        int count = 0;
        while (len > 0) {
            int read = this.in.read(buff, off, len);
            if (read < 0) break;
            count += read;
            off += read;
            len -= read;
        }
        return count;
    }

    public void recycle() {
    }

    public void send(MsgBuffer msg) throws IOException {
        msg.end();
        byte[] b = msg.getBuff();
        int len = msg.getLen();
        this.out.write(b, 0, len);
    }

    public void setSocket(Socket socket) throws IOException {
        socket.setSoLinger(true, 100);
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
    }
}

