/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.apisupport.AdaptNbVersion;
import org.netbeans.modules.maven.apisupport.ExamineManifest;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;

public class MavenNbModuleImpl
implements NbModuleProvider {
    private Project project;
    private DependencyAdder dependencyAdder = new DependencyAdder();
    private RequestProcessor.Task tsk = RequestProcessor.getDefault().create((Runnable)this.dependencyAdder);
    public static final String PROP_NETBEANS_INSTALL = "netbeans.installation";

    public MavenNbModuleImpl(Project project) {
        this.project = project;
    }

    private File getModuleXmlLocation() {
        File file;
        String string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"descriptor", null);
        if (string == null) {
            string = "src/main/nbm/module.xml";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), string);
        }
        return FileUtil.normalizeFile((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xpp3Dom getModuleDom() throws UnsupportedEncodingException, IOException, XmlPullParserException {
        if (!this.getModuleXmlLocation().exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(this.getModuleXmlLocation());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)inputStreamReader);
            return xpp3Dom;
        }
        finally {
            IOUtil.close((Reader)inputStreamReader);
        }
    }

    public String getSpecVersion() {
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        String string = AdaptNbVersion.adaptVersion(nbMavenProject.getMavenProject().getVersion(), "spec");
        return string;
    }

    public String getCodeNameBase() {
        Xpp3Dom xpp3Dom;
        try {
            Xpp3Dom xpp3Dom2;
            xpp3Dom = this.getModuleDom();
            if (xpp3Dom != null && (xpp3Dom2 = xpp3Dom.getChild("codeNameBase")) != null) {
                String string = xpp3Dom2.getValue();
                if (string.indexOf("/") > -1) {
                    string = string.substring(0, string.indexOf("/"));
                }
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        xpp3Dom = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        return xpp3Dom.getGroupId() + "." + xpp3Dom.getArtifactId();
    }

    public String getSourceDirectoryPath() {
        return "src/main/java";
    }

    public FileObject getSourceDirectory() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(this.getSourceDirectoryPath());
        if (fileObject == null) {
            try {
                fileObject = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)this.getSourceDirectoryPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fileObject;
    }

    public FileObject getManifestFile() {
        String string = "src/main/nbm/manifest.mf";
        try {
            Xpp3Dom xpp3Dom;
            Xpp3Dom xpp3Dom2 = this.getModuleDom();
            if (xpp3Dom2 != null && (xpp3Dom = xpp3Dom2.getChild("manifest")) != null) {
                string = xpp3Dom.getValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.project.getProjectDirectory().getFileObject(string);
    }

    public String getResourceDirectoryPath(boolean bl) {
        if (bl) {
            return "src/test/resources";
        }
        return "src/main/resources";
    }

    public boolean addDependency(String string, String string2, SpecificationVersion specificationVersion, boolean bl) throws IOException {
        List list;
        File file2;
        String string3 = string.replaceAll("\\.", "-");
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Set set = nbMavenProject.getMavenProject().getDependencyArtifacts();
        if (set != null) {
            for (File file2 : set) {
                if (!file2.getGroupId().startsWith("org.netbeans") || !file2.getArtifactId().equals(string3)) continue;
                return false;
            }
        }
        Dependency dependency = null;
        file2 = this.lookForModuleInPlatform(string3);
        if (file2 != null) {
            try {
                list = RepositoryQueries.findBySHA1((File)file2, (RepositoryInfo[])new RepositoryInfo[0]);
                Iterator iterator = list.iterator();
                if (iterator.hasNext()) {
                    NBVersionInfo nBVersionInfo = (NBVersionInfo)iterator.next();
                    dependency = new Dependency();
                    dependency.setArtifactId(nBVersionInfo.getArtifactId());
                    dependency.setGroupId(nBVersionInfo.getGroupId());
                    dependency.setVersion(nBVersionInfo.getVersion());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (dependency == null) {
            dependency = new Dependency();
            dependency.setGroupId("org.netbeans.api");
            dependency.setArtifactId(string3);
            if (specificationVersion != null) {
                dependency.setVersion(specificationVersion.toString());
            } else {
                list = nbMavenProject.getMavenProject().getModel().getDependencies();
                if (list != null) {
                    for (NBVersionInfo nBVersionInfo : list) {
                        if (!"org.netbeans.api".equals(nBVersionInfo.getGroupId())) continue;
                        dependency.setVersion(nBVersionInfo.getVersion());
                    }
                }
            }
        }
        if (dependency.getVersion() == null) {
            dependency.setVersion("RELEASE67");
        }
        this.dependencyAdder.addDependency(dependency);
        this.tsk.schedule(200);
        return true;
    }

    public File getModuleJarLocation() {
        return null;
    }

    public NbModuleProvider.NbModuleType getModuleType() {
        return NbModuleProvider.STANDALONE;
    }

    public String getProjectFilePath() {
        return "pom.xml";
    }

    public SpecificationVersion getDependencyVersion(String string) throws IOException {
        Object object;
        Object object2;
        String string2 = string.replaceAll("\\.", "-");
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Set set = nbMavenProject.getMavenProject().getDependencyArtifacts();
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (Artifact)object2.next();
                if (!object.getGroupId().startsWith("org.netbeans") || !object.getArtifactId().equals(string2)) continue;
                ExamineManifest examineManifest = new ExamineManifest();
                examineManifest.setJarFile(object.getFile());
                if (examineManifest.getSpecVersion() == null) continue;
                return new SpecificationVersion(examineManifest.getSpecVersion());
            }
        }
        if ((object2 = this.lookForModuleInPlatform(string2)) != null) {
            object = new ExamineManifest();
            ((ExamineManifest)object).setJarFile((File)object2);
            if (((ExamineManifest)object).getSpecVersion() != null) {
                return new SpecificationVersion(((ExamineManifest)object).getSpecVersion());
            }
        }
        return new SpecificationVersion("1.0");
    }

    private File lookForModuleInPlatform(String string) {
        File file = this.getActivePlatformLocation();
        if (file != null) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(file);
            directoryScanner.setIncludes(new String[]{"**/" + string + ".jar"});
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            assert (stringArray != null && stringArray.length <= 1);
            if (stringArray.length > 0) {
                return new File(file, stringArray[0]);
            }
        }
        return null;
    }

    public File getActivePlatformLocation() {
        File file;
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        String string = nbMavenProject.getMavenProject().getProperties().getProperty(PROP_NETBEANS_INSTALL);
        if (string != null && (file = new File(string)).exists()) {
            return file;
        }
        return null;
    }

    private class DependencyAdder
    implements Runnable {
        List<Dependency> toAdd = new ArrayList<Dependency>();

        private DependencyAdder() {
        }

        private synchronized void addDependency(Dependency dependency) {
            this.toAdd.add(dependency);
        }

        public void run() {
            FileObject fileObject = MavenNbModuleImpl.this.project.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void performOperation(POMModel pOMModel) {
                    DependencyAdder dependencyAdder = DependencyAdder.this;
                    synchronized (dependencyAdder) {
                        for (Dependency dependency : DependencyAdder.this.toAdd) {
                            org.netbeans.modules.maven.model.pom.Dependency dependency2 = ModelUtils.checkModelDependency((POMModel)pOMModel, (String)dependency.getGroupId(), (String)dependency.getArtifactId(), (boolean)true);
                            dependency2.setVersion(dependency.getVersion());
                        }
                        DependencyAdder.this.toAdd.clear();
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            NbMavenProject.fireMavenProjectReload((Project)MavenNbModuleImpl.this.project);
            ((NbMavenProject)MavenNbModuleImpl.this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
    }
}

