/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.DataSourceReferencePanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategyPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDatabasePanel
extends JPanel {
    public static final String IS_VALID = "SelectDatabasePanel_isValid";
    protected static final String PROTOTYPE_VALUE = "jdbc:pointbase://localhost/sample [pbpublic on PBPUBLIC] ";
    private final ServiceLocatorStrategyPanel slPanel;
    private final J2eeModuleProvider provider;
    private final Map<String, Datasource> references;
    private final Set<Datasource> moduleDatasources;
    private final Set<Datasource> serverDatasources;
    private boolean copyDataSourceToProject = false;
    private JButton buttonAdd;
    private JComboBox dsRefCombo;
    private JLabel dsRefLabel;
    private JPanel serviceLocatorPanel;

    public SelectDatabasePanel(J2eeModuleProvider j2eeModuleProvider, String string, Map<String, Datasource> map, Set<Datasource> set, Set<Datasource> set2, ClasspathInfo classpathInfo) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_ChooseDatabase"));
        this.provider = j2eeModuleProvider;
        this.references = map;
        this.moduleDatasources = set;
        this.serverDatasources = set2;
        this.dsRefCombo.setRenderer(new ReferenceListCellRenderer());
        this.dsRefCombo.setPrototypeDisplayValue(PROTOTYPE_VALUE);
        this.populateReferences();
        this.dsRefCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectDatabasePanel.this.checkDatasourceReference();
            }
        });
        this.slPanel = new ServiceLocatorStrategyPanel(string, classpathInfo);
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
        this.slPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("ServiceLocatorStrategyPanel_isValid") && (object = propertyChangeEvent.getNewValue()) instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    if (bl) {
                        SelectDatabasePanel.this.checkDatasourceReference();
                    } else {
                        SelectDatabasePanel.this.firePropertyChange(SelectDatabasePanel.IS_VALID, true, false);
                    }
                }
            }
        });
    }

    public String getDatasourceReference() {
        return (String)this.dsRefCombo.getSelectedItem();
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    public boolean createServerResources() {
        return this.copyDataSourceToProject;
    }

    public Datasource getDatasource() {
        return this.references.get(this.getDatasourceReference());
    }

    private void initComponents() {
        this.dsRefLabel = new JLabel();
        this.serviceLocatorPanel = new JPanel();
        this.dsRefCombo = new JComboBox();
        this.buttonAdd = new JButton();
        this.dsRefLabel.setDisplayedMnemonic(NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_ConnectionMnemonic").charAt(0));
        this.dsRefLabel.setLabelFor(this.dsRefCombo);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.dsRefLabel, (String)resourceBundle.getString("LBL_DsReference"));
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAdd, (String)NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_Add"));
        this.buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectDatabasePanel.this.buttonAddActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.dsRefLabel).addPreferredGap(0).add((Component)this.dsRefCombo, 0, 351, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonAdd)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.serviceLocatorPanel, -1, 493, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dsRefLabel).add((Component)this.dsRefCombo, -2, -1, -2).add((Component)this.buttonAdd)).add(26, 26, 26).add((Component)this.serviceLocatorPanel, -2, 114, -2).add(41, 41, 41)));
        this.dsRefLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_DsReference"));
        this.dsRefLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_DsReference"));
        this.dsRefCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_DsReference"));
        this.dsRefCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_DsRefCombo"));
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_AddDataSourceRef"));
    }

    private void buttonAddActionPerformed(ActionEvent actionEvent) {
        DataSourceReferencePanel dataSourceReferencePanel = new DataSourceReferencePanel(this.provider, this.references.keySet(), this.moduleDatasources, this.serverDatasources);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)dataSourceReferencePanel, NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_AddDataSourceReference"), true, 2, DialogDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, null);
        NotificationLineSupport notificationLineSupport = dialogDescriptor.createNotificationLineSupport();
        dataSourceReferencePanel.setNotificationLine(notificationLineSupport);
        dataSourceReferencePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (DataSourceReferencePanel.IS_VALID.equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)object).booleanValue());
                }
            }
        });
        dialogDescriptor.setValid(false);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == NotifyDescriptor.OK_OPTION) {
            final String string = dataSourceReferencePanel.getReferenceName();
            this.references.put(string, dataSourceReferencePanel.getDataSource());
            if (dataSourceReferencePanel.copyDataSourceToProject()) {
                // empty if block
            }
            this.copyDataSourceToProject = dataSourceReferencePanel.copyDataSourceToProject();
            this.populateReferences();
            this.dsRefCombo.setSelectedItem(string);
            boolean bl = false;
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SelectDatabasePanel.this.dsRefCombo.setSelectedItem(string);
                    }
                });
            }
        }
    }

    protected void checkDatasourceReference() {
        if (this.dsRefCombo.getSelectedItem() instanceof String) {
            this.firePropertyChange(IS_VALID, false, true);
        } else {
            this.firePropertyChange(IS_VALID, true, false);
        }
    }

    private void populateReferences() {
        TreeSet<String> treeSet = new TreeSet<String>(this.references.keySet());
        this.dsRefCombo.removeAllItems();
        for (String string : treeSet) {
            this.dsRefCombo.addItem(string);
        }
    }

    private class ReferenceListCellRenderer
    extends DefaultListCellRenderer {
        private ReferenceListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof String) {
                String string = (String)object;
                Datasource datasource = (Datasource)SelectDatabasePanel.this.references.get(string);
                StringBuilder stringBuilder = new StringBuilder(string);
                if (datasource != null) {
                    stringBuilder.append(" [");
                    stringBuilder.append(datasource.getUrl());
                    stringBuilder.append("] ");
                }
                this.setText(stringBuilder.toString());
            } else {
                this.setText(object != null ? object.toString() : "");
            }
            this.setToolTipText("");
            return this;
        }
    }
}

