/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.Group;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Param;
import org.netbeans.modules.websvc.saas.model.wadl.ParamStyle;
import org.netbeans.modules.websvc.saas.model.wadl.RepresentationType;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.spi.MethodNodeActionsProvider;
import org.netbeans.modules.websvc.saas.spi.SaasNodeActionsProvider;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasUtil {
    public static final String APPLICATION_WADL = "resources/application.wadl";
    public static final String DEFAULT_SERVICE_NAME = "Service";
    public static final String CATALOG = "catalog";
    public static final QName QNAME_GROUP = new QName("http://xml.netbeans.org/websvc/saas/services/1.0", "group");
    public static final QName QNAME_SAAS_SERVICES = new QName("http://xml.netbeans.org/websvc/saas/services/1.0", "saas-services");
    private static Lookup.Result<SaasNodeActionsProvider> extensionsResult = null;
    private static Lookup.Result<MethodNodeActionsProvider> methodsResult = null;

    public static <T> T loadJaxbObject(FileObject fileObject, Class<T> clazz, boolean bl) throws IOException {
        if (fileObject == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            Object object;
            Throwable throwable;
            block10: {
                T t;
                throwable = null;
                try {
                    inputStream = fileObject.getInputStream();
                    object = SaasUtil.loadJaxbObject(inputStream, clazz, bl);
                    if (object == null) break block10;
                    t = object;
                }
                catch (JAXBException jAXBException) {
                    throwable = jAXBException;
                }
                catch (IOException iOException) {
                    throwable = iOException;
                }
                return t;
            }
            object = NbBundle.getMessage(SaasUtil.class, (String)"MSG_ErrorLoadingJaxb", (Object)clazz.getName(), (Object)fileObject.getPath());
            IOException iOException = new IOException((String)object);
            if (throwable != null) {
                iOException.initCause(throwable);
            }
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static <T> T loadJaxbObject(InputStream inputStream, Class<T> clazz) throws JAXBException {
        return SaasUtil.loadJaxbObject(inputStream, clazz, false);
    }

    public static <T> T loadJaxbObject(InputStream inputStream, Class<T> clazz, boolean bl) throws JAXBException {
        Object object;
        SAXSource sAXSource;
        JAXBContext jAXBContext = JAXBContext.newInstance((String)clazz.getPackage().getName());
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        bl = false;
        if (bl) {
            sAXSource = SaasUtil.getSAXSourceWithXIncludeEnabled(inputStream);
            object = unmarshaller.unmarshal((Source)sAXSource);
        } else {
            object = unmarshaller.unmarshal(inputStream);
        }
        if (clazz.equals(object.getClass())) {
            return clazz.cast(object);
        }
        if (object instanceof JAXBElement) {
            sAXSource = (JAXBElement)object;
            return clazz.cast(sAXSource.getValue());
        }
        throw new IllegalArgumentException("Expect: " + clazz.getName() + " get: " + object.getClass().getName());
    }

    public static SAXSource getSAXSourceWithXIncludeEnabled(InputStream inputStream) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setXIncludeAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            return new SAXSource(xMLReader, new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Exceptions.printStackTrace((Throwable)sAXException);
        }
        return null;
    }

    public static SaasGroup loadSaasGroup(FileObject fileObject) throws IOException {
        if (fileObject == null) {
            return null;
        }
        Group group = SaasUtil.loadJaxbObject(fileObject, Group.class, false);
        return new SaasGroup(null, group);
    }

    public static SaasGroup loadSaasGroup(InputStream inputStream) throws JAXBException {
        Group group = SaasUtil.loadJaxbObject(inputStream, Group.class);
        if (group != null) {
            return new SaasGroup(null, group);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSaasGroup(SaasGroup saasGroup, File file) throws IOException, JAXBException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            SaasUtil.saveSaasGroup(saasGroup, fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void saveSaasGroup(SaasGroup saasGroup, OutputStream outputStream) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((String)Group.class.getPackage().getName());
        Marshaller marshaller = jAXBContext.createMarshaller();
        JAXBElement jAXBElement = new JAXBElement(QNAME_GROUP, Group.class, (Object)saasGroup.getDelegate());
        marshaller.marshal((Object)jAXBElement, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSaas(Saas saas, FileObject fileObject) throws IOException, JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((String)SaasServices.class.getPackage().getName());
        Marshaller marshaller = jAXBContext.createMarshaller();
        JAXBElement jAXBElement = new JAXBElement(QNAME_SAAS_SERVICES, SaasServices.class, (Object)saas.getDelegate());
        OutputStream outputStream = null;
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            marshaller.marshal((Object)jAXBElement, outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static Application loadWadl(FileObject fileObject) throws IOException {
        return SaasUtil.loadJaxbObject(fileObject, Application.class, true);
    }

    public static Application loadWadl(InputStream inputStream) throws JAXBException {
        return SaasUtil.loadJaxbObject(inputStream, Application.class, true);
    }

    public static SaasServices loadSaasServices(FileObject fileObject) throws IOException {
        return SaasUtil.loadJaxbObject(fileObject, SaasServices.class, true);
    }

    public static SaasServices loadSaasServices(InputStream inputStream) throws JAXBException {
        return SaasUtil.loadJaxbObject(inputStream, SaasServices.class, true);
    }

    public static Collection<? extends SaasNodeActionsProvider> getSaasNodeActionsProviders() {
        if (extensionsResult == null) {
            extensionsResult = Lookup.getDefault().lookupResult(SaasNodeActionsProvider.class);
        }
        return extensionsResult.allInstances();
    }

    public static Collection<? extends MethodNodeActionsProvider> getMethodNodeActionsProviders() {
        if (methodsResult == null) {
            methodsResult = Lookup.getDefault().lookupResult(MethodNodeActionsProvider.class);
        }
        return methodsResult.allInstances();
    }

    public static Resource getParentResource(Application application, Method method) {
        Resource resource = null;
        for (Resource resource2 : application.getResources().getResource()) {
            resource = SaasUtil.findParentResource(resource2, method);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    static Resource findParentResource(Resource resource, Method method) {
        for (Object object : resource.getMethodOrResource()) {
            Object object2;
            if (object instanceof Method) {
                object2 = (Method)object;
                if (object2 != method) continue;
                return resource;
            }
            if (!(object instanceof Resource) || (object2 = SaasUtil.findParentResource((Resource)object, method)) == null) continue;
            return object2;
        }
        return null;
    }

    public static Method wadlMethodFromIdRef(Application application, String string) {
        String string2 = string;
        if (string2.charAt(0) == '#') {
            string2 = string2.substring(1);
        }
        Method method = null;
        for (Object object : application.getResourceTypeOrMethodOrRepresentation()) {
            Method method2;
            if (!(object instanceof Method) || !string2.equals((method2 = (Method)object).getId())) continue;
            return method2;
        }
        for (Resource resource : application.getResources().getResource()) {
            method = SaasUtil.findMethodById(resource, string2);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    static Method findMethodById(Resource resource, String string) {
        for (Object object : resource.getMethodOrResource()) {
            Method method;
            if (!(object instanceof Method ? string.equals((method = (Method)object).getId()) : (method = SaasUtil.findMethodById((Resource)object, string)) != null)) continue;
            return method;
        }
        return null;
    }

    public static Method wadlMethodFromXPath(Application application, String string) {
        String[] stringArray = string.split("/");
        Resource resource = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = stringArray[i];
            if ("application".equals(string2) || string2.length() == 0 || "resources".equals(string2)) continue;
            if (string2.startsWith("resource[")) {
                List<Resource> list;
                n = SaasUtil.getIndex(string2);
                if (n > -1 && n < (list = SaasUtil.getCurrentResources(application, resource)).size()) {
                    resource = list.get(n);
                    continue;
                }
                return null;
            }
            if (!string2.startsWith("method[")) continue;
            n = SaasUtil.getIndex(string2);
            if (n > -1) {
                int n2 = 0;
                for (Object object : resource.getMethodOrResource()) {
                    if (!(object instanceof Method)) continue;
                    if (n2 == n) {
                        if (i == stringArray.length - 1) {
                            return (Method)object;
                        }
                        return null;
                    }
                    if (n2 < n) {
                        ++n2;
                        continue;
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    static List<Resource> getCurrentResources(Application application, Resource resource) {
        if (resource == null) {
            return application.getResources().getResource();
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Object object : resource.getMethodOrResource()) {
            if (!(object instanceof Resource)) continue;
            arrayList.add((Resource)object);
        }
        return arrayList;
    }

    static int getIndex(String string) {
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n < 0 || n2 < 0 || n2 <= n) {
            return -1;
        }
        try {
            return Integer.valueOf(string.substring(n + 1, n2)) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static Set<String> getMediaTypesFromJAXBElement(List<JAXBElement<RepresentationType>> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (JAXBElement<RepresentationType> jAXBElement : list) {
            hashSet.add(((RepresentationType)jAXBElement.getValue()).getMediaType());
        }
        return hashSet;
    }

    public static Set<String> getMediaTypes(List<RepresentationType> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RepresentationType representationType : list) {
            hashSet.add(representationType.getMediaType());
        }
        return hashSet;
    }

    public static String getSignature(WadlSaasMethod wadlSaasMethod) {
        WadlSaas wadlSaas = wadlSaasMethod.getSaas();
        Resource[] resourceArray = wadlSaasMethod.getResourcePath();
        Method method = wadlSaasMethod.getWadlMethod();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append(" : ");
        try {
            stringBuffer.append(wadlSaas.getWadlModel().getResources().getBase());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        for (Resource resource : resourceArray) {
            stringBuffer.append(resource.getPath());
            stringBuffer.append('/');
        }
        Object[] objectArray = null;
        if (method.getRequest() != null && method.getRequest().getParam() != null) {
            objectArray = method.getRequest().getParam().toArray(new Param[method.getRequest().getParam().size()]);
            if (objectArray.length > 0) {
                stringBuffer.append(" (");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (i > 0) {
                    stringBuffer.append(",");
                }
                if (((Param)object).getStyle() == ParamStyle.TEMPLATE) {
                    stringBuffer.append('{');
                    stringBuffer.append(((Param)object).getName());
                    stringBuffer.append('}');
                    continue;
                }
                if (((Param)object).getStyle() == ParamStyle.QUERY) {
                    stringBuffer.append('?');
                    stringBuffer.append(((Param)object).getName());
                    continue;
                }
                if (((Param)object).getStyle() == ParamStyle.MATRIX) {
                    stringBuffer.append('[');
                    stringBuffer.append(((Param)object).getName());
                    stringBuffer.append(']');
                    continue;
                }
                if (((Param)object).getStyle() == ParamStyle.HEADER) {
                    stringBuffer.append('<');
                    stringBuffer.append(((Param)object).getName());
                    stringBuffer.append('>');
                    continue;
                }
                stringBuffer.append(((Param)object).getName());
            }
            if (objectArray.length > 0) {
                stringBuffer.append(" )");
            }
        }
        return stringBuffer.toString();
    }

    public static Image loadIcon(SaasGroup saasGroup, int n) {
        String string = saasGroup.getIcon16Path();
        if (n == 2 || n == 4) {
            string = saasGroup.getIcon32Path();
        }
        if (string != null) {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            if (uRL != null) {
                return new ImageIcon(uRL).getImage();
            }
            return ImageUtilities.loadImage((String)string);
        }
        return null;
    }

    public static String deriveFileName(String string) {
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = string;
        }
        string2 = string2.substring(string2.lastIndexOf(47) + 1);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject extractWadlFile(WadlSaas wadlSaas) throws IOException {
        FileObject fileObject;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(wadlSaas.getUrl());
        if (inputStream == null) {
            return null;
        }
        OutputStream outputStream = null;
        try {
            String string;
            FileObject fileObject2 = wadlSaas.getSaasFolder();
            FileObject fileObject3 = fileObject2.getFileObject(CATALOG);
            if (fileObject3 == null) {
                fileObject3 = fileObject2.createFolder(CATALOG);
            }
            if ((fileObject = fileObject3.getFileObject(string = SaasUtil.deriveFileName(wadlSaas.getUrl()))) == null) {
                fileObject = fileObject3.createData(string);
            }
            outputStream = fileObject.getOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return fileObject;
    }

    public static Saas getServiceByUrl(SaasGroup saasGroup, String string) {
        for (Saas saas : saasGroup.getServices()) {
            if (!saas.getUrl().equals(string)) continue;
            return saas;
        }
        return null;
    }

    public static String getWadlServiceDirName(String string) {
        int n;
        String string2;
        String string3 = string.replace('\\', '/');
        if (string3.endsWith(APPLICATION_WADL)) {
            string3 = string3.substring(0, string3.length() - APPLICATION_WADL.length() - 1);
        }
        if ((string2 = string3.substring(n = string3.lastIndexOf("/") + 1)).endsWith(".wadl") || string2.endsWith(".WADL")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        string2 = string2.replace('.', '-');
        return string2;
    }

    public static String ensureUniqueServiceDirName(String string) {
        String string2 = string;
        for (int i = 0; i < 1000; ++i) {
            FileObject fileObject = SaasServicesModel.getWebServiceHome();
            if (i > 0) {
                string2 = string + i;
            }
            if (fileObject.getFileObject(string2) != null) continue;
            try {
                fileObject.createFolder(string2);
            }
            catch (IOException iOException) {}
            break;
        }
        return string2;
    }

    public static FileObject retrieveWadlFile(WadlSaas wadlSaas) {
        try {
            FileObject fileObject = wadlSaas.getSaasFolder();
            File file = new File(FileUtil.toFile((FileObject)fileObject), CATALOG);
            URI uRI = file.toURI();
            URI uRI2 = new URI(wadlSaas.getUrl());
            return SaasUtil.getRetriever().retrieveResource(fileObject, uRI, uRI2);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private static Retriever getRetriever() {
        Retriever retriever = (Retriever)Lookup.getDefault().lookup(Retriever.class);
        if (retriever != null) {
            return retriever;
        }
        return Retriever.getDefault();
    }

    public static String getSaasType(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith("wsdl") || string2.endsWith("asmx")) {
            return "http://schemas.xmlsoap.org/wsdl/";
        }
        if (string2.endsWith("http://research.sun.com/wadl/2006/10")) {
            return "http://research.sun.com/wadl/2006/10";
        }
        try {
            InputStream inputStream = new URI(string).toURL().openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            String string3 = byteArrayOutputStream.toString("UTF-8");
            if (string3.contains("http://schemas.xmlsoap.org/wsdl/") || string3.contains("wsdl")) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }
            if (string3.contains("http://research.sun.com/wadl/2006/10")) {
                return "http://research.sun.com/wadl/2006/10";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String filenameFromPath(String string) {
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public static String dirOnlyPath(String string) {
        int n = string.lastIndexOf(47);
        if (n > -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static FileObject saveResourceAsFile(FileObject fileObject, String string, String string2) throws IOException {
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
        return SaasUtil.saveResourceAsFile(fileObject2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject saveResourceAsFile(FileObject fileObject, String string) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        String string2 = SaasUtil.filenameFromPath(string);
        FileObject fileObject2 = fileObject.getFileObject(string2);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(string2);
        }
        OutputStream outputStream = fileObject2.getOutputStream();
        if (inputStream != null && outputStream != null) {
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                FileObject fileObject3 = fileObject2;
                return fileObject3;
            }
            finally {
                inputStream.close();
                outputStream.close();
            }
        }
        return null;
    }

    public static String toValidJavaName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuilder.append(string.charAt(0));
        }
        for (int i = 1; i < string.length(); ++i) {
            if (!Character.isJavaIdentifierPart(string.charAt(i))) continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String deriveDefaultPackageName(Saas saas) {
        String string = SaasUtil.toValidJavaName(saas.getTopLevelGroup().getName());
        String string2 = SaasUtil.toValidJavaName(saas.getDisplayName());
        return (string + "." + string2).toLowerCase();
    }
}

