/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.HighlighterSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ASTBrowserTopComponent
extends TopComponent {
    private static final long serialVersionUID = 1L;
    private static ASTBrowserTopComponent instance;
    private static final String PREFERRED_ID = "ASTBrowserTopComponent";
    private JTree tree;
    private Listener listener;
    private HighlighterSupport highlighting = new HighlighterSupport(Color.yellow);
    private CaretListener caretListener;
    private JEditorPane lastPane;
    private ASTNode rootNode;

    private ASTBrowserTopComponent() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.tree = new JTree();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ASTBrowserTopComponent.this.mark();
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ASTBrowserTopComponent.this.mark();
            }

            public void focusLost(FocusEvent focusEvent) {
                ASTBrowserTopComponent.this.mark();
            }
        });
        this.tree.setShowsRootHandles(true);
        this.tree.setModel(new DefaultTreeModel(new TNode(null, null)));
        this.tree.setCellRenderer(new Renderer());
        this.add(new JScrollPane(this.tree), "Center");
        this.setName(NbBundle.getMessage(ASTBrowserTopComponent.class, (String)"CTL_ASTBrowserTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ASTBrowserTopComponent.class, (String)"HINT_ASTBrowserTopComponent"));
    }

    private void initComponents() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ASTBrowserTopComponent getDefault() {
        if (instance == null) {
            instance = new ASTBrowserTopComponent();
        }
        return instance;
    }

    public static synchronized ASTBrowserTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            ErrorManager.getDefault().log(16, "Cannot find ASTBrowser component. It will not be located properly in the window system.");
            return ASTBrowserTopComponent.getDefault();
        }
        if (topComponent instanceof ASTBrowserTopComponent) {
            return (ASTBrowserTopComponent)topComponent;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ASTBrowserTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ASTBrowserTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentShowing() {
        this.refresh();
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
    }

    public void componentHidden() {
        if (this.listener != null) {
            this.listener.remove();
            this.listener = null;
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void mark() {
        TNode tNode;
        EditorCookie editorCookie;
        Node[] nodeArray;
        if (this.tree.isFocusOwner() && (nodeArray = TopComponent.getRegistry().getActivatedNodes()).length == 1 && (editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class)) != null && (tNode = (TNode)this.tree.getLastSelectedPathComponent()) != null) {
            ASTItem aSTItem = tNode.getASTItem();
            if (aSTItem == null) {
                return;
            }
            this.highlighting.highlight(editorCookie.getDocument(), aSTItem.getOffset(), aSTItem.getEndOffset());
            return;
        }
        this.highlighting.removeHighlight();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ASTNode aSTNode = ASTBrowserTopComponent.this.getCurrentRootNode();
                if (aSTNode == ASTBrowserTopComponent.this.rootNode) {
                    return;
                }
                ASTBrowserTopComponent.this.rootNode = aSTNode;
                DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new TNode(null, ASTBrowserTopComponent.this.rootNode));
                ASTBrowserTopComponent.this.tree.setModel(defaultTreeModel);
            }
        });
    }

    private ASTNode getCurrentRootNode() {
        StyledDocument styledDocument;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length != 1) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes().length < 1) {
            return null;
        }
        JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
        if (this.caretListener == null) {
            this.caretListener = new CListener();
        }
        if (this.lastPane != null && this.lastPane != jEditorPane) {
            this.lastPane.removeCaretListener(this.caretListener);
            this.lastPane = null;
        }
        if (this.lastPane == null) {
            jEditorPane.addCaretListener(this.caretListener);
            this.lastPane = jEditorPane;
        }
        if ((styledDocument = editorCookie.getDocument()) == null || !(styledDocument instanceof NbEditorDocument)) {
            return null;
        }
        return ParserManagerImpl.getImpl(styledDocument).getAST();
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference<ASTBrowserTopComponent> component;

        Listener(ASTBrowserTopComponent aSTBrowserTopComponent) {
            this.component = new WeakReference<ASTBrowserTopComponent>(aSTBrowserTopComponent);
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        }

        ASTBrowserTopComponent getComponent() {
            ASTBrowserTopComponent aSTBrowserTopComponent = (ASTBrowserTopComponent)((Object)this.component.get());
            if (aSTBrowserTopComponent != null) {
                return aSTBrowserTopComponent;
            }
            this.remove();
            return null;
        }

        void remove() {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ASTBrowserTopComponent aSTBrowserTopComponent = this.getComponent();
            if (aSTBrowserTopComponent == null) {
                return;
            }
            aSTBrowserTopComponent.refresh();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ASTBrowserTopComponent.getDefault();
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return super.getTreeCellRendererComponent(jTree, ((TNode)object).getName(), bl, bl2, bl3, n, bl4);
        }
    }

    class CListener
    implements CaretListener {
        CListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (ASTBrowserTopComponent.this.rootNode == null) {
                return;
            }
            ASTPath aSTPath = ASTBrowserTopComponent.this.rootNode.findPath(caretEvent.getDot());
            if (aSTPath == null) {
                return;
            }
            TreeNode treeNode = (TreeNode)ASTBrowserTopComponent.this.tree.getModel().getRoot();
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            ListIterator<ASTItem> listIterator = aSTPath.listIterator();
            if (!listIterator.hasNext()) {
                return;
            }
            listIterator.next();
            arrayList.add(treeNode);
            while (treeNode instanceof TNode && listIterator.hasNext()) {
                if ((treeNode = ((TNode)treeNode).getTreeNode(listIterator.next())) == null) {
                    throw new NullPointerException();
                }
                arrayList.add(treeNode);
            }
            TreePath treePath = new TreePath(arrayList.toArray());
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)ASTBrowserTopComponent.this.tree.getModel().getRoot());
            ASTBrowserTopComponent.this.tree.setModel(defaultTreeModel);
            ASTBrowserTopComponent.this.tree.setSelectionPath(treePath);
            ASTBrowserTopComponent.this.tree.scrollPathToVisible(treePath);
        }
    }

    static class TNode
    implements TreeNode {
        private TNode parent;
        private ASTItem astItem;
        private List<TreeNode> children;
        private Map<ASTItem, TreeNode> map;

        TNode(TNode tNode, ASTItem aSTItem) {
            this.parent = tNode;
            this.astItem = aSTItem;
        }

        private void initChildren() {
            if (this.children != null) {
                return;
            }
            this.children = new ArrayList<TreeNode>();
            this.map = new HashMap<ASTItem, TreeNode>();
            if (this.astItem == null) {
                return;
            }
            List<ASTItem> list = this.astItem.getChildren();
            if (list != null) {
                for (ASTItem aSTItem : list) {
                    TNode tNode = new TNode(this, aSTItem);
                    this.children.add(tNode);
                    this.map.put(aSTItem, tNode);
                }
            }
        }

        String getName() {
            if (this.astItem == null) {
                return "No syntax definition.";
            }
            if (this.astItem instanceof ASTNode) {
                String string = ((ASTNode)this.astItem).getNT();
                if (string.equals("S")) {
                    string = string + " (" + this.astItem.getMimeType() + ")";
                }
                return string;
            }
            return this.astItem.toString();
        }

        ASTItem getASTItem() {
            return this.astItem;
        }

        TreeNode getTreeNode(Object object) {
            this.initChildren();
            return this.map.get(object);
        }

        public TreeNode getChildAt(int n) {
            this.initChildren();
            return this.children.get(n);
        }

        public int getChildCount() {
            this.initChildren();
            return this.children.size();
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode treeNode) {
            this.initChildren();
            return this.children.indexOf(treeNode);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            if (this.astItem == null) {
                return false;
            }
            return this.astItem.getChildren().isEmpty();
        }

        public Enumeration children() {
            return new Enumeration(){
                private Iterator it;
                {
                    this.it = TNode.this.children.iterator();
                }

                public boolean hasMoreElements() {
                    return this.it.hasNext();
                }

                public Object nextElement() {
                    return this.it.next();
                }
            };
        }
    }
}

