/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AuxClassLoader
extends AntBridge.AllPermissionURLClassLoader {
    private final ClassLoader nbLoader;

    private static boolean masked(String string) {
        return string.startsWith("org.apache.tools.") && !string.startsWith("org.apache.tools.ant.module.");
    }

    public AuxClassLoader(ClassLoader classLoader, ClassLoader classLoader2, URL uRL) {
        super(new URL[]{uRL}, classLoader2);
        this.nbLoader = classLoader;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (!AuxClassLoader.masked(string)) {
            try {
                return this.nbLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return super.findClass(string);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            Exceptions.attachMessage((Throwable)unsupportedClassVersionError, (String)("loading: " + string));
            throw unsupportedClassVersionError;
        }
    }

    @Override
    public URL findResource(String string) {
        URL uRL;
        if (!AuxClassLoader.masked(string) && (uRL = this.nbLoader.getResource(string)) != null) {
            return uRL;
        }
        return super.findResource(string);
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(this.nbLoader.getResources(string), super.findResources(string)));
    }
}

