/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.TimeDuration;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataQuery;
import org.netbeans.modules.dlight.threadmap.storage.ThreadDataImpl;
import org.netbeans.modules.dlight.threadmap.storage.ThreadInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadMapDataStorage
implements ProxyDataStorage {
    public static final String THREAD_MAP_STORAGE_TYPE_ID = "ThreadMapDataStorage";
    private static final List<ThreadMapDataStorage> instances = new ArrayList<ThreadMapDataStorage>();
    private final List<ThreadDataImpl> data = new LinkedList<ThreadDataImpl>();
    private TimeDuration frequency;
    private SQLDataStorage sqlStorage;

    public static final ThreadMapDataStorage getInstance() {
        return instances.get(0);
    }

    ThreadMapDataStorage() {
    }

    public void addThreadInfo(ThreadInfoImpl threadInfoImpl) {
        this.data.add(new ThreadDataImpl(threadInfoImpl));
    }

    public void addThreadState(ThreadInfoImpl threadInfoImpl, ThreadState threadState) {
        for (ThreadDataImpl threadDataImpl : this.data) {
            if (threadDataImpl.getThreadInfo() != threadInfoImpl) continue;
            threadDataImpl.addState(threadState);
            break;
        }
    }

    public final void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
    }

    public ThreadInfoImpl getThreadInfo(int n) {
        for (ThreadDataImpl threadDataImpl : this.data) {
            if (threadDataImpl.getThreadInfo().getThreadId() != n) continue;
            return threadDataImpl.getThreadInfo();
        }
        return null;
    }

    public void clear() {
        this.data.clear();
    }

    public void init(TimeDuration timeDuration, DataTableMetadata dataTableMetadata) {
        this.clear();
        this.frequency = timeDuration;
    }

    public ThreadMapData queryThreadMapData(ThreadMapDataQuery threadMapDataQuery) {
        final ArrayList<ThreadDataImpl> arrayList = new ArrayList<ThreadDataImpl>();
        for (ThreadDataImpl threadDataImpl : this.data) {
            arrayList.add(threadDataImpl);
        }
        ThreadMapData threadMapData = new ThreadMapData(){

            @Override
            public List<ThreadData> getThreadsData() {
                return Collections.unmodifiableList(arrayList);
            }

            @Override
            public boolean isSamplingMode() {
                return false;
            }
        };
        return threadMapData;
    }

    public boolean shutdown() {
        this.clear();
        return true;
    }

    public DataStorageType getBackendDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getBackendTablesMetadata() {
        return Collections.emptyList();
    }

    public void attachTo(DataStorage dataStorage) {
        this.sqlStorage = (SQLDataStorage)dataStorage;
    }

    public boolean hasData(DataTableMetadata dataTableMetadata) {
        return false;
    }

    public void addData(String string, List<DataRow> list) {
        if (this.sqlStorage != null) {
            this.sqlStorage.addData(string, list);
        }
    }

    public Collection<DataStorageType> getStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType(THREAD_MAP_STORAGE_TYPE_ID));
    }

    public boolean supportsType(DataStorageType dataStorageType) {
        return this.getStorageTypes().contains(dataStorageType);
    }

    public void createTables(List<DataTableMetadata> list) {
    }

    static {
        instances.add(new ThreadMapDataStorage());
    }
}

