/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class AbstractFileBuffer
implements FileBuffer {
    private final CharSequence absPath;
    private Charset encoding;

    protected AbstractFileBuffer(CharSequence charSequence) {
        this.absPath = FilePathCache.getManager().getString(charSequence);
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public File getFile() {
        return new File(((Object)this.absPath).toString());
    }

    public abstract int getLength();

    public abstract String getText(int var1, int var2) throws IOException;

    public abstract String getText() throws IOException;

    public final Reader getReader() throws IOException {
        Object object;
        Object object2;
        if (this.encoding == null) {
            object2 = this.getFile();
            object = FileUtil.toFileObject((File)object2);
            this.encoding = object != null ? FileEncodingQuery.getEncoding((FileObject)object) : FileEncodingQuery.getDefaultEncoding();
        }
        object2 = this.getInputStream();
        object = new InputStreamReader((InputStream)object2, this.encoding);
        return object;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract boolean isFileBased();

    public abstract long lastModified();

    protected void write(DataOutput dataOutput) throws IOException {
        assert (this.absPath != null);
        PersistentUtils.writeUTF(this.absPath, dataOutput);
    }

    protected AbstractFileBuffer(DataInput dataInput) throws IOException {
        this.absPath = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
        assert (this.absPath != null);
    }
}

