/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    public static Generator NONE = new Generator("NONE", null, 0);
    public static Generator CONTROLLER = new Generator("controller", null, null, "Views", null, 1);
    public static Generator INTEGRATION_TEST = new Generator("integration_test", null, 1);
    public static Generator MAILER = new Generator("mailer", null, null, "Views", null, 1);
    public static Generator MIGRATION = new Generator("migration", null, 1);
    public static Generator MODEL = new Generator("model", null, 1);
    public static Generator METAL = new Generator("metal", null, 1);
    public static Generator PLUGIN = new Generator("plugin", null, 1);
    public static Generator SCAFFOLD_ONE = new Generator("scaffold", null, "ModelName", "ScaffControllerName", "ScaffoldActions", 1);
    public static Generator SCAFFOLD_TWO = new Generator("scaffold", null, "ModelName", "ScaffoldAttrs", null, 1);
    public static Generator SESSION_MIGRATION = new Generator("session_migration", null, 1);
    public static Generator WEB_SERVICE = new Generator("web_service", null, null, "ApiMethods", null, 1);
    private final String name;
    private final FileObject location;
    private final String nameKey;
    private final String arg1Key;
    private final String arg2Key;
    private final int argsRequired;

    public Generator(String string, FileObject fileObject, int n) {
        this(string, fileObject, "Arguments", null, null, n);
    }

    private Generator(String string, FileObject fileObject, String string2, String string3, String string4, int n) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        this.argsRequired = n;
        this.name = string;
        this.location = fileObject;
        this.nameKey = string2;
        this.arg1Key = string3;
        this.arg2Key = string4;
    }

    static List<Generator> getBuiltinGenerators(String string) {
        boolean bl = string != null && string.startsWith("1.");
        ArrayList<Generator> arrayList = new ArrayList<Generator>();
        arrayList.add(CONTROLLER);
        arrayList.add(INTEGRATION_TEST);
        arrayList.add(MODEL);
        arrayList.add(MIGRATION);
        arrayList.add(MAILER);
        arrayList.add(PLUGIN);
        if (bl) {
            arrayList.add(SCAFFOLD_ONE);
        } else {
            arrayList.add(SCAFFOLD_TWO);
        }
        arrayList.add(SESSION_MIGRATION);
        if (bl) {
            arrayList.add(WEB_SERVICE);
        }
        return arrayList;
    }

    public int getArgsRequired() {
        return this.argsRequired;
    }

    public String getName() {
        return this.name;
    }

    public FileObject getDir() {
        return this.location;
    }

    public String getUsage(Project project) {
        Object object;
        Object object2;
        Object object3;
        File file;
        if (this == NONE) {
            return null;
        }
        File file2 = null;
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (this.location == null) {
            file = null;
            object3 = project.getProjectDirectory().getFileObject("vendor/rails/railties");
            if (object3 != null) {
                file = FileUtil.toFile((FileObject)object3);
            } else {
                File file3;
                object2 = rubyPlatform.getGemManager().getLatestVersion("rails");
                if (object2 != null) {
                    file = new File(rubyPlatform.getGemManager().getGemHome() + File.separator + "gems" + File.separator + "rails" + "-" + (String)object2);
                } else if (!Utilities.isWindows() && (object = rubyPlatform.getHome()) != null && (file3 = new File((File)object, "/share/rails/railties")).exists()) {
                    file = file3;
                }
            }
            if (file != null) {
                file2 = new File(file, "lib" + File.separator + "rails_generator" + File.separator + "generators" + File.separator + "components" + File.separator + this.name);
            }
        } else {
            file2 = FileUtil.toFile((FileObject)this.location);
        }
        file = new File(file2, "USAGE");
        if (!file.exists() && !(file = new File(file2, "templates" + File.separator + "USAGE")).exists()) {
            return null;
        }
        object3 = new StringBuilder();
        try {
            object2 = new BufferedReader(new FileReader(file));
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                ((StringBuilder)object3).append((String)object);
                ((StringBuilder)object3).append("\n");
            }
            if (((StringBuilder)object3).length() > 0) {
                return ((StringBuilder)object3).toString();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    String getNameLabel() {
        if (this.nameKey != null) {
            return NbBundle.getMessage(Generator.class, (String)this.nameKey);
        }
        return NbBundle.getMessage(Generator.class, (String)"Name");
    }

    String getArg1Label() {
        if (this.arg1Key != null) {
            return NbBundle.getMessage(Generator.class, (String)this.arg1Key);
        }
        return null;
    }

    String getArg2Label() {
        if (this.arg2Key != null) {
            return NbBundle.getMessage(Generator.class, (String)this.arg2Key);
        }
        return null;
    }
}

