/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceSupport;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public class WebLogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("WebLogicalViewProvider.BROKEN_LINKS_RP");
    private static final RequestProcessor BROKEN_DATASOURCE_RP = new RequestProcessor("WebLogicalViewProvider.BROKEN_DATASOURCE_RP");
    private final WebProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath", "war.content.additional", "endorsed.classpath", "web.docbase.dir"};

    public WebLogicalViewProvider(WebProject webProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = webProject;
        assert (webProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new WebLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            for (Node node2 : node.getChildren().getNodes(true)) {
                Node node3 = PackageView.findPath((Node)node2, (Object)object);
                if (node3 == null) continue;
                return node3;
            }
            Node node4 = this.findNodeInConfigFiles(node, fileObject);
            if (node4 != null) {
                return node4;
            }
            node4 = this.findNodeInDocBase(node, fileObject);
            if (node4 != null) {
                return node4;
            }
        }
        return null;
    }

    private Node findNodeInDocBase(Node node, FileObject fileObject) {
        String string = this.evaluator.getProperty("web.docbase.dir");
        if (string == null) {
            return null;
        }
        FileObject fileObject2 = this.helper.getAntProjectHelper().resolveFileObject(string);
        String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(47);
        string2 = n != -1 ? string2.substring(0, n) : "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        Node node2 = NodeOp.findChild((Node)node, (String)fileObject2.getName());
        if (node2 == null) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if ((node2 = NodeOp.findChild((Node)node2, (String)stringTokenizer.nextToken())) != null) continue;
            return null;
        }
        for (Node node3 : node2.getChildren().getNodes(true)) {
            DataObject dataObject = (DataObject)node3.getLookup().lookup(DataObject.class);
            if (dataObject == null || !dataObject.getPrimaryFile().getNameExt().equals(fileObject.getNameExt())) continue;
            node2 = node3;
            break;
        }
        return node2;
    }

    private Node findNodeInConfigFiles(Node node, FileObject fileObject) {
        String string;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string = dataObject.getName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string = fileObject.getName();
        }
        dataObject = node.getChildren().findChild("configurationFiles");
        if (dataObject == null) {
            return null;
        }
        return NodeOp.findChild((Node)dataObject, (String)string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.changeSupport.fireChange();
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private boolean isDeployOnSaveSupportedAndDisabled() {
        boolean bl = Boolean.valueOf(this.project.evaluator().getProperty("j2ee.deploy.on.save"));
        if (bl) {
            return false;
        }
        boolean bl2 = false;
        try {
            String string = this.project.evaluator().getProperty("j2ee.server.instance");
            if (string != null) {
                bl2 = Deployment.getDefault().getServerInstance(string).isDeployOnSaveSupported();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return bl2;
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String string, String string2, boolean bl) {
            return new ActionImpl(string, string2, (Lookup)(bl ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            Lookup context;
            String name;
            String command;

            public ActionImpl(String string, String string2, Lookup lookup) {
                super(string2);
                this.context = lookup;
                this.command = string;
                this.name = string2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    private final class WebLogicalViewRootNode
    extends AbstractNode {
        private final Action brokenLinksAction;
        private final BrokenServerAction brokenServerAction;
        private final BrokenDatasourceAction brokenDatasourceAction;
        private boolean broken;
        private boolean deployOnSaveDisabled;

        public WebLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)WebLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-web-project/Nodes"), WebLogicalViewProvider.createLookup(WebLogicalViewProvider.this.project));
            this.setIconBaseWithExtension("org/netbeans/modules/web/project/ui/resources/webProjectIcon.gif");
            super.setName(ProjectUtils.getInformation((Project)WebLogicalViewProvider.this.project).getDisplayName());
            if (WebLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            this.brokenDatasourceAction = new BrokenDatasourceAction();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)WebLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)j2eeModuleProvider));
            this.deployOnSaveDisabled = WebLogicalViewProvider.this.isDeployOnSaveSupportedAndDisabled();
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)WebLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(WebLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.broken || this.brokenServerAction.isEnabled() || this.brokenDatasourceAction.isEnabled()) {
                return ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave((Image)image);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            if (this.broken || this.brokenServerAction.isEnabled() || this.brokenDatasourceAction.isEnabled()) {
                return ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave((Image)image);
            }
            return image;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.brokenServerAction.isEnabled() || this.brokenDatasourceAction.isEnabled() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)WebLogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(WebLogicalViewRootNode.class);
        }

        private void setDeployOnSaveDisabled(boolean bl) {
            this.deployOnSaveDisabled = bl;
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(WebLogicalViewProvider.class);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)WebLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            if (j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_RedeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Rest_Actions_holder"));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                arrayList.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                arrayList.add(this.brokenServerAction);
            }
            if (this.brokenDatasourceAction.isEnabled()) {
                arrayList.add(this.brokenDatasourceAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private class BrokenDatasourceAction
        extends AbstractAction
        implements Runnable,
        ConnectionListener {
            private volatile boolean brokenDatasource;
            private RequestProcessor.Task task = null;

            public BrokenDatasourceAction() {
                ConnectionManager.getDefault().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this, (Object)ConnectionManager.getDefault()));
                this.putValue("Name", NbBundle.getMessage(WebLogicalViewProvider.class, (String)"LBL_Fix_Broken_Datasource_Action"));
                this.checkMissingDatabaseConnection();
            }

            private boolean isVisualWebLegacyProject() {
                String string;
                boolean bl = false;
                AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)WebLogicalViewProvider.this.project);
                Element element = auxiliaryConfiguration.getConfigurationFragment("creator-data", "http://www.sun.com/creator/ns", true);
                if (element != null && (string = element.getAttribute("jsf.project.version")) != null && !string.equals("4.0")) {
                    bl = true;
                }
                return bl;
            }

            public boolean isEnabled() {
                return this.brokenDatasource;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenDatasourceSupport.fixDatasources((Project)WebLogicalViewProvider.this.project);
                this.checkMissingDatabaseConnection();
            }

            private void checkMissingDatabaseConnection() {
                if (this.task == null) {
                    this.task = BROKEN_DATASOURCE_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }

            public void run() {
                this.doCheckMissingDatabaseConnection();
            }

            private void doCheckMissingDatabaseConnection() {
                boolean bl = this.brokenDatasource;
                this.brokenDatasource = !BrokenDatasourceSupport.getBrokenDatasources((Project)WebLogicalViewProvider.this.project).isEmpty();
                if (bl != this.brokenDatasource) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BrokenDatasourceAction.this.setEnabled(BrokenDatasourceAction.this.brokenDatasource);
                            WebLogicalViewRootNode.this.fireIconChange();
                            WebLogicalViewRootNode.this.fireOpenedIconChange();
                            WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                            if (BrokenDatasourceAction.this.brokenDatasource && !BrokenDatasourceAction.this.isVisualWebLegacyProject()) {
                                BrokenDatasourceSupport.showAlert();
                            }
                        }
                    });
                }
            }

            public void connectionsChanged() {
                this.checkMissingDatabaseConnection();
            }
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(WebLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                WebLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Profile profile = Profile.fromPropertiesString((String)WebLogicalViewProvider.this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform"));
                if (profile == null) {
                    profile = Profile.JAVA_EE_5;
                    Logger.getLogger(WebLogicalViewProvider.class.getName()).warning("project [" + WebLogicalViewProvider.this.project.getProjectDirectory() + "] is missing " + "j2ee.platform" + ". " + "default value will be used instead: " + profile);
                    this.updateJ2EESpec(WebLogicalViewProvider.this.project, WebLogicalViewProvider.this.project.getAntProjectHelper(), profile);
                }
                if ((string = BrokenServerSupport.selectServer((Profile)profile, (J2eeModule.Type)J2eeModule.Type.WAR)) != null) {
                    WebProjectProperties.setServerInstance(WebLogicalViewProvider.this.project, WebLogicalViewProvider.this.helper, string);
                }
                this.checkMissingServer();
            }

            private void updateJ2EESpec(final Project project, final AntProjectHelper antProjectHelper, final Profile profile) {
                ProjectManager.mutex().postWriteRequest(new Runnable(){

                    public void run() {
                        try {
                            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put("j2ee.platform", profile.toPropertiesString());
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String string) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean bl = this.brokenServer;
                String string = WebLogicalViewProvider.this.evaluator.getProperty("j2ee.server.instance");
                this.brokenServer = BrokenServerSupport.isBroken((String)string);
                if (bl != this.brokenServer) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WebLogicalViewRootNode.this.fireIconChange();
                            WebLogicalViewRootNode.this.fireOpenedIconChange();
                            WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                        }
                    });
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(WebLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(WebLogicalViewRootNode.this.broken);
                WebLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                WebLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)WebLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WebLogicalViewProvider.this.helper.requestUpdate();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)WebLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)WebLogicalViewProvider.this.resolver, (String[])WebLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean bl;
                boolean bl2 = WebLogicalViewRootNode.this.broken;
                WebLogicalViewRootNode.this.broken = WebLogicalViewProvider.this.hasBrokenLinks();
                if (bl2 != WebLogicalViewRootNode.this.broken) {
                    this.setEnabled(WebLogicalViewRootNode.this.broken);
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
                if ((bl2 = WebLogicalViewRootNode.this.deployOnSaveDisabled) != (bl = WebLogicalViewProvider.this.isDeployOnSaveSupportedAndDisabled())) {
                    WebLogicalViewRootNode.this.setDeployOnSaveDisabled(bl);
                }
            }

            public void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

