/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Exceptions;

public class PathUtils {
    private PathUtils() {
    }

    public static String getPathFromSymlink(String string, ExecutionEnvironment executionEnvironment) {
        try {
            int n;
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
            nativeProcessBuilder.setExecutable("/bin/ls").setArguments(new String[]{"-l", string}).redirectError();
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            if (string2 != null && (n = string2.indexOf("->")) > 0) {
                return string2.substring(n + 2).trim();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public static String getExePath(long l, ExecutionEnvironment executionEnvironment) {
        if (l > 0L) {
            String string = "/proc/" + Long.toString(l);
            File file = new File(string, "path/a.out");
            String string2 = PathUtils.getPathFromSymlink(file.getAbsolutePath(), executionEnvironment);
            if (string2 == null) {
                file = new File(string, "exe");
                string2 = PathUtils.getPathFromSymlink(file.getAbsolutePath(), executionEnvironment);
            }
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
        }
        return null;
    }

    public static String getExePathLocal(long l) {
        return PathUtils.getExePath(l, ExecutionEnvironmentFactory.getLocal());
    }
}

