/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.Copy;
import org.netbeans.upgrade.CopyFiles;
import org.netbeans.upgrade.IncludeExclude;
import org.netbeans.upgrade.PathTransformation;
import org.netbeans.upgrade.systemoptions.Importer;
import org.netbeans.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.xml.sax.SAXException;

public final class AutoUpgrade {
    private static final Logger LOGGER = Logger.getLogger(AutoUpgrade.class.getName());
    private static final List VERSION_TO_CHECK = Arrays.asList(".netbeans/6.7", ".netbeans/6.5", ".netbeans/6.1", ".netbeans/6.0", ".netbeans/5.5.1", ".netbeans/5.5");

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[1];
        File file = AutoUpgrade.checkPrevious(stringArray2, VERSION_TO_CHECK);
        if (file != null) {
            if (!AutoUpgrade.showUpgradeDialog(file)) {
                throw new UserCancelException();
            }
            if (stringArray2[0].compareTo("6.5") < 0) {
                AutoUpgrade.doUpgrade(file, stringArray2[0]);
                AutoUpgrade.doNonStandardUpgrade(file, stringArray2[0]);
                AutoUpgrade.upgradeBuildProperties(file, stringArray2);
                Importer.doImport();
            } else {
                AutoUpgrade.copyToUserdir(file);
                Importer.doImport();
            }
        }
    }

    private static void upgradeBuildProperties(File file, String[] stringArray) throws IOException {
        File file2 = new File(System.getProperty("netbeans.user", ""));
        String[] stringArray2 = new String[]{"^nbplatform[.](?!default[.]netbeans[.]dest[.]dir).+[.].+=.+$", "^var[.].*"};
        Copy.appendSelectedLines(new File(file, "build.properties"), file2, stringArray2);
    }

    private static File checkPrevious(String[] stringArray, List list) {
        String string = System.getProperty("user.home");
        File file = null;
        if (string != null) {
            File file2 = new File(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && file == null) {
                String string2 = (String)iterator.next();
                file = new File(file2.getAbsolutePath(), string2);
                if (file.isDirectory()) {
                    stringArray[0] = file.getName();
                    break;
                }
                file = null;
            }
            return file;
        }
        return null;
    }

    private static boolean showUpgradeDialog(File file) {
        Util.setDefaultLookAndFeel();
        JOptionPane jOptionPane = new JOptionPane(new AutoUpgradePanel(file.getAbsolutePath()), 3, 0);
        JDialog jDialog = Util.createJOptionDialog(jOptionPane, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Confirmation_Title"));
        jDialog.setVisible(true);
        return new Integer(0).equals(jOptionPane.getValue());
    }

    static void doUpgrade(File file, String string) throws IOException, PropertyVetoException {
        IncludeExclude includeExclude;
        Object object;
        File file2 = new File(System.getProperty("netbeans.user", ""));
        try {
            object = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + string), "utf-8");
            includeExclude = IncludeExclude.create((Reader)object);
            ((Reader)object).close();
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Cannot import from version: " + string);
            iOException2.initCause(iOException);
            throw iOException2;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + string + ". Importing from " + file + " to " + file2);
        object = new File(file, "config");
        LocalFileSystem localFileSystem = new LocalFileSystem();
        localFileSystem.setRootDirectory((File)object);
        XMLFileSystem xMLFileSystem = null;
        try {
            URL uRL = AutoUpgrade.class.getResource("layer" + string + ".xml");
            xMLFileSystem = uRL != null ? new XMLFileSystem(uRL) : null;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("Cannot import from version: " + string);
            iOException.initCause(sAXException);
            throw iOException;
        }
        LocalFileSystem localFileSystem2 = xMLFileSystem != null ? AutoUpgrade.createLayeredSystem(localFileSystem, xMLFileSystem) : localFileSystem;
        Copy.copyDeep(localFileSystem2.getRoot(), FileUtil.getConfigRoot(), includeExclude, PathTransformation.getInstance(string));
    }

    private static void doNonStandardUpgrade(File file, String string) throws IOException, PropertyVetoException {
        IncludeExclude includeExclude;
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        File file2 = new File(System.getProperty("netbeans.user", ""));
        try {
            inputStream = AutoUpgrade.class.getResourceAsStream("nonstandard" + string);
            if (inputStream == null) {
                return;
            }
            inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            includeExclude = IncludeExclude.create(inputStreamReader);
            ((Reader)inputStreamReader).close();
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Cannot import from version: " + string + "nonstandard");
            iOException2.initCause(iOException);
            throw iOException2;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + string + "nonstandard" + ". Importing from " + file + " to " + file2);
        inputStream = new LocalFileSystem();
        inputStream.setRootDirectory(file);
        inputStreamReader = new LocalFileSystem();
        inputStreamReader.setRootDirectory(file2);
        Copy.copyDeep(inputStream.getRoot(), inputStreamReader.getRoot(), includeExclude, PathTransformation.getInstance(string));
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem localFileSystem, XMLFileSystem xMLFileSystem) {
        MultiFileSystem multiFileSystem = new MultiFileSystem(new FileSystem[]{localFileSystem, xMLFileSystem}){
            {
                this.setPropagateMasks(true);
            }
        };
        return multiFileSystem;
    }

    private static void copyToUserdir(File file) throws IOException, PropertyVetoException {
        File file2 = new File(System.getProperty("netbeans.user", ""));
        File file3 = InstalledFileLocator.getDefault().locate("modules", null, false).getParentFile().getParentFile();
        File file4 = new File(file3, "etc/netbeans.import");
        LOGGER.fine("Import file: " + file4);
        LOGGER.info("Importing from " + file + " to " + file2);
        CopyFiles.copyDeep(file, file2, file4);
    }
}

