/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.hints.options.DepScanningSettings;
import org.netbeans.modules.java.hints.options.HintsPanel;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class HintsPanelLogic
implements MouseListener,
KeyListener,
TreeSelectionListener,
ChangeListener,
ActionListener {
    private Map<AbstractHint, ModifiedPreferences> changes = new HashMap<AbstractHint, ModifiedPreferences>();
    private DepScanningSettings.DependencyTracking depScn = null;
    private static Map<AbstractHint.HintSeverity, Integer> severity2index = new HashMap<AbstractHint.HintSeverity, Integer>();
    private static Map<DepScanningSettings.DependencyTracking, Integer> deptracking2index;
    private static final String DESCRIPTION_HEADER = "<html><head></head><body>";
    private static final String DESCRIPTION_FOOTER = "</body></html>";
    private JTree errorTree;
    private JLabel severityLabel;
    private JComboBox severityComboBox;
    private JCheckBox tasklistCheckBox;
    private JPanel customizerPanel;
    private JEditorPane descriptionTextArea;
    private DefaultComboBoxModel defModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel depScanningModel = new DefaultComboBoxModel();
    private String defLabel = NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label");
    private String depScanningLabel = NbBundle.getMessage(HintsPanel.class, (String)"CTL_Scope_Label");
    private String depScanningDescription = NbBundle.getMessage(HintsPanel.class, (String)"CTL_Scope_Desc");

    HintsPanelLogic() {
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsError"));
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsWarning"));
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_WarningOnCurrentLine"));
        this.depScanningModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AllProjects"));
        this.depScanningModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_Project"));
        this.depScanningModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_SrcRoot"));
    }

    void connect(JTree jTree, JLabel jLabel, JComboBox jComboBox, JCheckBox jCheckBox, JPanel jPanel, JEditorPane jEditorPane) {
        this.errorTree = jTree;
        this.severityLabel = jLabel;
        this.severityComboBox = jComboBox;
        this.tasklistCheckBox = jCheckBox;
        this.customizerPanel = jPanel;
        this.descriptionTextArea = jEditorPane;
        this.valueChanged(null);
        jTree.addKeyListener(this);
        jTree.addMouseListener(this);
        jTree.getSelectionModel().addTreeSelectionListener(this);
        jComboBox.addActionListener(this);
        jCheckBox.addChangeListener(this);
    }

    void disconnect() {
        this.errorTree.removeKeyListener(this);
        this.errorTree.removeMouseListener(this);
        this.errorTree.getSelectionModel().removeTreeSelectionListener(this);
        this.severityComboBox.removeActionListener(this);
        this.tasklistCheckBox.removeChangeListener(this);
        this.componentsSetEnabled(false);
    }

    synchronized void applyChanges() {
        for (AbstractHint abstractHint : this.changes.keySet()) {
            ModifiedPreferences modifiedPreferences = this.changes.get(abstractHint);
            modifiedPreferences.store(abstractHint.getPreferences(HintsSettings.getCurrentProfileId()));
        }
        if (this.depScn != null) {
            DepScanningSettings.setDependencyTracking(this.depScn);
        }
    }

    boolean isChanged() {
        return !this.changes.isEmpty() || this.depScn != null;
    }

    synchronized Preferences getCurrentPrefernces(AbstractHint abstractHint) {
        Preferences preferences = this.changes.get(abstractHint);
        return preferences == null ? abstractHint.getPreferences(HintsSettings.getCurrentProfileId()) : preferences;
    }

    synchronized Preferences getPreferences4Modification(AbstractHint abstractHint) {
        Preferences preferences = this.changes.get(abstractHint);
        if (preferences == null) {
            preferences = new ModifiedPreferences(abstractHint.getPreferences(HintsSettings.getCurrentProfileId()));
            this.changes.put(abstractHint, (ModifiedPreferences)preferences);
        }
        return preferences;
    }

    synchronized DepScanningSettings.DependencyTracking getCurrentDependencyTracking() {
        return this.depScn != null ? this.depScn : DepScanningSettings.getDependencyTracking();
    }

    static Object getUserObject(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    static Object getUserObject(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode.getUserObject();
    }

    boolean isSelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            AbstractHint abstractHint;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof AbstractHint) || !HintsSettings.isEnabled(abstractHint = (AbstractHint)object, this.getCurrentPrefernces(abstractHint))) continue;
            return true;
        }
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point = mouseEvent.getPoint();
        TreePath treePath = this.errorTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treePath != null && (rectangle = this.errorTree.getPathBounds(treePath)) != null && rectangle.contains(point)) {
            this.toggle(treePath);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        JTree jTree;
        TreePath treePath;
        if ((keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) && keyEvent.getSource() instanceof JTree && this.toggle(treePath = (jTree = (JTree)keyEvent.getSource()).getSelectionPath())) {
            keyEvent.consume();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (object instanceof AbstractHint) {
            if (this.defModel != this.severityComboBox.getModel()) {
                this.severityComboBox.setModel(this.defModel);
                Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
            }
            AbstractHint abstractHint = (AbstractHint)object;
            this.componentsSetEnabled(true);
            Preferences preferences = this.getCurrentPrefernces(abstractHint);
            AbstractHint.HintSeverity hintSeverity = HintsSettings.getSeverity(abstractHint, preferences);
            if (hintSeverity != null) {
                this.severityComboBox.setSelectedIndex(severity2index.get((Object)hintSeverity));
                this.severityComboBox.setEnabled(true);
            } else {
                this.severityComboBox.setSelectedIndex(severity2index.get((Object)AbstractHint.HintSeverity.ERROR));
                this.severityComboBox.setEnabled(false);
            }
            boolean bl = HintsSettings.isShowInTaskList(abstractHint, preferences);
            this.tasklistCheckBox.setSelected(bl);
            String string = abstractHint.getDescription();
            this.descriptionTextArea.setText(string == null ? "" : this.wrapDescription(string));
            this.customizerPanel.removeAll();
            JComponent jComponent = abstractHint.getCustomizer(treeSelectionEvent == null ? this.getCurrentPrefernces(abstractHint) : this.getPreferences4Modification(abstractHint));
            if (jComponent != null) {
                this.customizerPanel.add((Component)jComponent, "Center");
            }
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
        } else if (object instanceof String) {
            DepScanningSettings.DependencyTracking dependencyTracking = this.getCurrentDependencyTracking();
            if (this.depScanningModel != this.severityComboBox.getModel()) {
                this.severityComboBox.setModel(this.depScanningModel);
                Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.depScanningLabel);
            }
            this.componentsSetEnabled(false);
            this.severityComboBox.setEnabled(true);
            this.descriptionTextArea.setEnabled(true);
            this.descriptionTextArea.setText(this.wrapDescription(this.depScanningDescription));
            this.descriptionTextArea.setCaretPosition(0);
            if (dependencyTracking != DepScanningSettings.DependencyTracking.DISABLED) {
                this.severityComboBox.setSelectedIndex(deptracking2index.get((Object)dependencyTracking));
            }
        } else {
            if (this.defModel != this.severityComboBox.getModel()) {
                this.severityComboBox.setModel(this.defModel);
                Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
            }
            this.componentsSetEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.errorTree.getSelectionPath() == null || !this.severityComboBox.equals(actionEvent.getSource())) {
            return;
        }
        Object object = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (object instanceof AbstractHint) {
            AbstractHint abstractHint = (AbstractHint)object;
            Preferences preferences = this.getPreferences4Modification(abstractHint);
            if (HintsSettings.getSeverity(abstractHint, preferences) != null) {
                HintsSettings.setSeverity(preferences, this.index2severity(this.severityComboBox.getSelectedIndex()));
            }
        } else if (object instanceof String && this.getCurrentDependencyTracking() != DepScanningSettings.DependencyTracking.DISABLED) {
            this.depScn = this.index2deptracking(this.severityComboBox.getSelectedIndex());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    private String wrapDescription(String string) {
        return new StringBuffer(DESCRIPTION_HEADER).append(string).append(DESCRIPTION_FOOTER).toString();
    }

    private AbstractHint.HintSeverity index2severity(int n) {
        for (Map.Entry<AbstractHint.HintSeverity, Integer> entry : severity2index.entrySet()) {
            if (entry.getValue() != n) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown severity");
    }

    private DepScanningSettings.DependencyTracking index2deptracking(int n) {
        for (Map.Entry<DepScanningSettings.DependencyTracking, Integer> entry : deptracking2index.entrySet()) {
            if (entry.getValue() != n) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown severity");
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = HintsPanelLogic.getUserObject(treePath);
        HintsPanel.ExtendedModel extendedModel = (HintsPanel.ExtendedModel)this.errorTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (object instanceof AbstractHint) {
            AbstractHint abstractHint = (AbstractHint)object;
            boolean bl = HintsSettings.isEnabled(abstractHint, this.getCurrentPrefernces(abstractHint));
            Preferences preferences = this.getPreferences4Modification(abstractHint);
            HintsSettings.setEnabled(preferences, !bl);
            extendedModel.nodeChanged(defaultMutableTreeNode);
            extendedModel.nodeChanged(defaultMutableTreeNode.getParent());
        } else if (object instanceof FileObject) {
            boolean bl = !this.isSelected(defaultMutableTreeNode);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                AbstractHint abstractHint;
                boolean bl2;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                Object object2 = defaultMutableTreeNode2.getUserObject();
                if (!(object2 instanceof AbstractHint) || (bl2 = HintsSettings.isEnabled(abstractHint = (AbstractHint)object2, this.getCurrentPrefernces(abstractHint))) == bl) continue;
                Preferences preferences = this.getPreferences4Modification(abstractHint);
                HintsSettings.setEnabled(preferences, bl);
                extendedModel.nodeChanged(defaultMutableTreeNode2);
            }
            extendedModel.nodeChanged(defaultMutableTreeNode);
        } else if (object instanceof String) {
            DepScanningSettings.DependencyTracking dependencyTracking = this.getCurrentDependencyTracking();
            this.depScn = dependencyTracking != DepScanningSettings.DependencyTracking.DISABLED ? DepScanningSettings.DependencyTracking.DISABLED : this.index2deptracking(this.severityComboBox.getSelectedIndex());
            extendedModel.nodeChanged(defaultMutableTreeNode);
            extendedModel.nodeChanged(defaultMutableTreeNode.getParent());
        }
        return false;
    }

    private void componentsSetEnabled(boolean bl) {
        if (!bl) {
            this.customizerPanel.removeAll();
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
            this.severityComboBox.setSelectedIndex(severity2index.get((Object)HintsSettings.SEVERITY_DEFAUT));
            this.tasklistCheckBox.setSelected(true);
            this.descriptionTextArea.setText("");
        }
        this.severityComboBox.setEnabled(bl);
        this.tasklistCheckBox.setEnabled(bl);
        this.descriptionTextArea.setEnabled(bl);
    }

    static {
        severity2index.put(AbstractHint.HintSeverity.ERROR, 0);
        severity2index.put(AbstractHint.HintSeverity.WARNING, 1);
        severity2index.put(AbstractHint.HintSeverity.CURRENT_LINE_WARNING, 2);
        deptracking2index = new HashMap<DepScanningSettings.DependencyTracking, Integer>();
        deptracking2index.put(DepScanningSettings.DependencyTracking.ENABLED, 0);
        deptracking2index.put(DepScanningSettings.DependencyTracking.ENABLED_WITHIN_PROJECT, 1);
        deptracking2index.put(DepScanningSettings.DependencyTracking.ENABLED_WITHIN_ROOT, 2);
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public ModifiedPreferences(Preferences preferences) {
            super(null, "");
            try {
                for (String string : preferences.keys()) {
                    this.put(string, preferences.get(string, null));
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }

        public void store(Preferences preferences) {
            try {
                for (String string : this.keys()) {
                    preferences.put(string, this.get(string, null));
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }

        protected void putSpi(String string, String string2) {
            this.map.put(string, string2);
        }

        protected String getSpi(String string) {
            return (String)this.map.get(string);
        }

        protected void removeSpi(String string) {
            this.map.remove(string);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] stringArray = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(stringArray);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

