/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.swing.JComponent;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleCheck
extends AbstractHint {
    private volatile transient boolean stop;
    private static final SpecificationVersion SOURCE_LEVEL_1_5 = new SpecificationVersion("1.5");

    public DoubleCheck() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.SYNCHRONIZED);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        Tree tree = treePath.getLeaf();
        if (tree == null || tree.getKind() != Tree.Kind.SYNCHRONIZED) {
            return null;
        }
        SynchronizedTree synchronizedTree = (SynchronizedTree)tree;
        TreePath treePath2 = this.findOuterIf(compilationInfo, treePath);
        if (treePath2 == null) {
            return null;
        }
        IfTree ifTree = null;
        TreePath treePath3 = new TreePath(treePath, synchronizedTree.getBlock());
        for (StatementTree statementTree : synchronizedTree.getBlock().getStatements()) {
            if (this.sameIfAndValidate(compilationInfo, new TreePath(treePath3, statementTree), treePath2)) {
                ifTree = (IfTree)statementTree;
                break;
            }
            if (!this.stop) continue;
            return null;
        }
        if (ifTree == null) {
            return null;
        }
        List<FixImpl> list = Collections.singletonList(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), synchronizedTree);
        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(DoubleCheck.class, (String)"MSG_FixDoubleCheck"), (List)list, (FileObject)compilationInfo.getFileObject(), (int)n, (int)(n + "synchronized".length()));
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_DoubleCheck");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_DoubleCheck");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private TreePath findOuterIf(CompilationInfo compilationInfo, TreePath treePath) {
        while (!this.stop && (treePath = treePath.getParentPath()) != null) {
            BlockTree blockTree;
            Tree tree = treePath.getLeaf();
            if (tree.getKind() == Tree.Kind.IF) {
                return treePath;
            }
            if (tree.getKind() == Tree.Kind.BLOCK && (blockTree = (BlockTree)tree).getStatements().size() == 1) continue;
            return null;
        }
        return null;
    }

    private boolean sameIfAndValidate(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2) {
        StatementTree statementTree = (StatementTree)treePath.getLeaf();
        if (statementTree.getKind() != Tree.Kind.IF) {
            return false;
        }
        IfTree ifTree = (IfTree)statementTree;
        IfTree ifTree2 = (IfTree)treePath2.getLeaf();
        if (ifTree.getElseStatement() != null) {
            return false;
        }
        if (ifTree2.getElseStatement() != null) {
            return false;
        }
        TreePath treePath3 = this.equalToNull(new TreePath(treePath, ifTree.getCondition()));
        TreePath treePath4 = this.equalToNull(new TreePath(treePath2, ifTree2.getCondition()));
        if (treePath3 == null || treePath4 == null) {
            return false;
        }
        Element element = compilationInfo.getTrees().getElement(treePath3);
        Element element2 = compilationInfo.getTrees().getElement(treePath4);
        if (element != null && ((Object)element).equals(element2)) {
            return DoubleCheck.getSourceLevel(compilationInfo).compareTo((Object)SOURCE_LEVEL_1_5) < 0 || !element.getModifiers().contains((Object)Modifier.VOLATILE);
        }
        return false;
    }

    private TreePath equalToNull(TreePath treePath) {
        ExpressionTree expressionTree;
        ExpressionTree expressionTree2 = (ExpressionTree)treePath.getLeaf();
        if (expressionTree2.getKind() == Tree.Kind.PARENTHESIZED) {
            expressionTree = (ParenthesizedTree)expressionTree2;
            expressionTree2 = expressionTree.getExpression();
            treePath = new TreePath(treePath, expressionTree2);
        }
        if (expressionTree2.getKind() != Tree.Kind.EQUAL_TO) {
            return null;
        }
        expressionTree = (BinaryTree)expressionTree2;
        if (expressionTree.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL && expressionTree.getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return new TreePath(treePath, expressionTree.getRightOperand());
        }
        if (expressionTree.getLeftOperand().getKind() != Tree.Kind.NULL_LITERAL && expressionTree.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            return new TreePath(treePath, expressionTree.getLeftOperand());
        }
        return null;
    }

    private static SpecificationVersion getSourceLevel(CompilationInfo compilationInfo) {
        String string = SourceLevelQuery.getSourceLevel((FileObject)compilationInfo.getFileObject());
        if (string == null) {
            return SOURCE_LEVEL_1_5;
        }
        return new SpecificationVersion(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private TreePathHandle synchHandle;
        private TreePathHandle ifHandle;
        private FileObject file;

        public FixImpl(TreePathHandle treePathHandle, TreePathHandle treePathHandle2, FileObject fileObject) {
            this.synchHandle = treePathHandle;
            this.ifHandle = treePathHandle2;
            this.file = fileObject;
        }

        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_DoubleCheck");
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            modificationResult.commit();
            return null;
        }

        public String toString() {
            return "FixDoubleCheck";
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            Tree tree = this.synchHandle.resolve((CompilationInfo)workingCopy).getLeaf();
            Tree tree2 = this.ifHandle.resolve((CompilationInfo)workingCopy).getLeaf();
            workingCopy.rewrite(tree2, tree);
        }
    }
}

