/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.javaee.AntDeploymentProviderImpl;
import org.netbeans.modules.glassfish.javaee.FindJSPServletImpl;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentFactory;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2MessageDestinationManager;
import org.netbeans.modules.glassfish.javaee.Hk2ServerInstanceDescriptor;
import org.netbeans.modules.glassfish.javaee.Hk2StartServer;
import org.netbeans.modules.glassfish.javaee.JDBCDriverDeployerImpl;
import org.netbeans.modules.glassfish.javaee.JavaEEServerModule;
import org.netbeans.modules.glassfish.javaee.db.Hk2DatasourceManager;
import org.netbeans.modules.glassfish.javaee.ide.FastDeploy;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInitializationException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInstanceDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;

public class Hk2OptionalFactory
extends OptionalDeploymentManagerFactory {
    private final DeploymentFactory df;
    private final ServerUtilities commonUtilities;

    protected Hk2OptionalFactory(DeploymentFactory deploymentFactory, ServerUtilities serverUtilities) {
        this.df = deploymentFactory;
        this.commonUtilities = serverUtilities;
    }

    public static Hk2OptionalFactory createPrelude() {
        ServerUtilities serverUtilities = ServerUtilities.getPreludeUtilities();
        return null == serverUtilities ? null : new Hk2OptionalFactory(Hk2DeploymentFactory.createPrelude(), serverUtilities);
    }

    public static Hk2OptionalFactory createEe6() {
        ServerUtilities serverUtilities = ServerUtilities.getEe6Utilities();
        return null == serverUtilities ? null : new Hk2OptionalFactory(Hk2DeploymentFactory.createEe6(), serverUtilities);
    }

    public StartServer getStartServer(DeploymentManager deploymentManager) {
        return new Hk2StartServer(deploymentManager);
    }

    public IncrementalDeployment getIncrementalDeployment(DeploymentManager deploymentManager) {
        Hk2DeploymentManager hk2DeploymentManager;
        FastDeploy fastDeploy = null;
        if (deploymentManager instanceof Hk2DeploymentManager && (hk2DeploymentManager = (Hk2DeploymentManager)deploymentManager).isLocal()) {
            fastDeploy = new FastDeploy(hk2DeploymentManager);
        }
        return fastDeploy;
    }

    public FindJSPServlet getFindJSPServlet(DeploymentManager deploymentManager) {
        assert (deploymentManager instanceof Hk2DeploymentManager) : "dm isn't an hk2dm";
        FindJSPServletImpl findJSPServletImpl = null;
        try {
            Hk2DeploymentManager hk2DeploymentManager = (Hk2DeploymentManager)deploymentManager;
            if (!hk2DeploymentManager.getCommonServerSupport().isRemote()) {
                findJSPServletImpl = new FindJSPServletImpl(hk2DeploymentManager, this);
            }
        }
        catch (ClassCastException classCastException) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "caller passed invalid param", classCastException);
        }
        return findJSPServletImpl;
    }

    public boolean isCommonUIRequired() {
        return false;
    }

    public WizardDescriptor.InstantiatingIterator getAddInstanceIterator() {
        return new J2eeInstantiatingIterator(this.commonUtilities);
    }

    public DatasourceManager getDatasourceManager(DeploymentManager deploymentManager) {
        return deploymentManager instanceof Hk2DeploymentManager ? new Hk2DatasourceManager((Hk2DeploymentManager)deploymentManager) : null;
    }

    public JDBCDriverDeployer getJDBCDriverDeployer(DeploymentManager deploymentManager) {
        assert (deploymentManager instanceof Hk2DeploymentManager) : "dm isn't an hk2dm";
        JDBCDriverDeployerImpl jDBCDriverDeployerImpl = null;
        try {
            jDBCDriverDeployerImpl = new JDBCDriverDeployerImpl((Hk2DeploymentManager)deploymentManager, this);
        }
        catch (ClassCastException classCastException) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "caller passed invalid param", classCastException);
        }
        return jDBCDriverDeployerImpl;
    }

    public MessageDestinationDeployment getMessageDestinationDeployment(DeploymentManager deploymentManager) {
        return deploymentManager instanceof Hk2DeploymentManager ? new Hk2MessageDestinationManager((Hk2DeploymentManager)deploymentManager) : null;
    }

    public AntDeploymentProvider getAntDeploymentProvider(DeploymentManager deploymentManager) {
        assert (deploymentManager instanceof Hk2DeploymentManager) : "dm isn't an hk2dm";
        AntDeploymentProviderImpl antDeploymentProviderImpl = null;
        try {
            antDeploymentProviderImpl = new AntDeploymentProviderImpl((Hk2DeploymentManager)deploymentManager, this);
        }
        catch (ClassCastException classCastException) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "caller passed invalid param", classCastException);
        }
        return antDeploymentProviderImpl;
    }

    public ServerInstanceDescriptor getServerInstanceDescriptor(DeploymentManager deploymentManager) {
        Hk2ServerInstanceDescriptor hk2ServerInstanceDescriptor = null;
        if (deploymentManager instanceof Hk2DeploymentManager) {
            hk2ServerInstanceDescriptor = new Hk2ServerInstanceDescriptor((Hk2DeploymentManager)deploymentManager);
        } else {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Invalid deployment manager: " + deploymentManager);
        }
        return hk2ServerInstanceDescriptor;
    }

    public void finishServerInitialization() throws ServerInitializationException {
        try {
            String[] stringArray = InstanceProperties.getInstanceList();
            if (null != stringArray) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : stringArray) {
                    if (!this.df.handlesURI(string)) continue;
                    InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
                    String string2 = instanceProperties.getProperty("homefolder");
                    String string3 = instanceProperties.getProperty("domainsfolder") + File.separator + instanceProperties.getProperty("domainname");
                    File file = new File(string2);
                    File file2 = new File(string3);
                    if (file.exists() && file.isDirectory() && file2.exists() && file2.isDirectory() && file2.canWrite()) continue;
                    arrayList.add(string);
                }
                for (String string : arrayList) {
                    InstanceProperties.removeInstance((String)string);
                }
            }
        }
        catch (Exception exception) {
            throw new ServerInitializationException("failed to init default instance", (Throwable)exception);
        }
    }

    private static class J2eeInstantiatingIterator
    implements WizardDescriptor.InstantiatingIterator {
        private final WizardDescriptor.InstantiatingIterator delegate;
        private ServerUtilities su;

        public J2eeInstantiatingIterator(ServerUtilities serverUtilities) {
            this.delegate = serverUtilities.getAddInstanceIterator();
            this.su = serverUtilities;
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.delegate.removeChangeListener(changeListener);
        }

        public void previousPanel() {
            this.delegate.previousPanel();
        }

        public void nextPanel() {
            this.delegate.nextPanel();
        }

        public String name() {
            return this.delegate.name();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public WizardDescriptor.Panel current() {
            return this.delegate.current();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.delegate.addChangeListener(changeListener);
        }

        public void uninitialize(WizardDescriptor wizardDescriptor) {
            this.delegate.uninitialize(wizardDescriptor);
        }

        public Set instantiate() throws IOException {
            Set set = this.delegate.instantiate();
            if (!set.isEmpty()) {
                Object e = set.iterator().next();
                if (e instanceof ServerInstance) {
                    ServerInstance serverInstance = (ServerInstance)e;
                    Lookup lookup = this.su.getLookupFor(serverInstance);
                    if (lookup != null) {
                        JavaEEServerModule javaEEServerModule = (JavaEEServerModule)lookup.lookup(JavaEEServerModule.class);
                        if (javaEEServerModule != null) {
                            return Collections.singleton(javaEEServerModule.getInstanceProperties());
                        }
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, "No JavaEE facade found for " + serverInstance.getDisplayName());
                    } else {
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, "No lookup found for " + serverInstance.getDisplayName());
                    }
                } else {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "AddServerWizard iterator must return a set of ServerInstance objects.");
                }
            }
            return Collections.EMPTY_SET;
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            this.delegate.initialize(wizardDescriptor);
        }
    }
}

