/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnElementHolder;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.DBMemoryCollection;
import org.netbeans.modules.dbschema.TableElement;

public final class IndexElement
extends DBMemberElement
implements ColumnElementHolder {
    public IndexElement() {
        this(new Memory(), null);
    }

    public IndexElement(Impl impl, TableElement tableElement) {
        super(impl, tableElement);
    }

    final Impl getIndexImpl() {
        return (Impl)this.getElementImpl();
    }

    public boolean isUnique() {
        return this.getIndexImpl().isUnique();
    }

    public void setUnique(boolean bl) throws DBException {
        this.getIndexImpl().setUnique(bl);
    }

    public void addColumn(ColumnElement columnElement) throws DBException {
        this.addColumns(new ColumnElement[]{columnElement});
    }

    public void addColumns(ColumnElement[] columnElementArray) throws DBException {
        for (int i = 0; i < columnElementArray.length; ++i) {
            if (this.getColumn(columnElementArray[i].getName()) == null) continue;
            this.throwAddException("FMT_EXC_AddColumn", columnElementArray[i]);
        }
        this.getIndexImpl().changeColumns(columnElementArray, 1);
    }

    public void removeColumn(ColumnElement columnElement) throws DBException {
        this.removeColumns(new ColumnElement[]{columnElement});
    }

    public void removeColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getIndexImpl().changeColumns(columnElementArray, -1);
    }

    public void setColumns(ColumnElement[] columnElementArray) throws DBException {
        if (columnElementArray == null) {
            throw new NullPointerException(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("NulIndexes"));
        }
        this.getIndexImpl().changeColumns(columnElementArray, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getIndexImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier dBIdentifier) {
        return this.getIndexImpl().getColumn(dBIdentifier);
    }

    private void throwAddException(String string, ColumnElement columnElement) throws DBException {
        String string2 = columnElement.getName().getName();
        throw new DBException(string2);
    }

    static class Memory
    extends DBMemberElement.Memory
    implements Impl {
        private boolean _unique;
        private DBMemoryCollection.Column columns;

        Memory() {
            this._unique = true;
        }

        Memory(IndexElement indexElement) {
            super(indexElement);
            this._unique = indexElement.isUnique();
        }

        public boolean isUnique() {
            return this._unique;
        }

        public void setUnique(boolean bl) {
            boolean bl2 = this._unique;
            this._unique = bl;
            this.firePropertyChange("unique", bl2, bl);
        }

        public synchronized void changeColumns(ColumnElement[] columnElementArray, int n) {
            this.initColumns();
            this.columns.change(columnElementArray, n);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier dBIdentifier) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(dBIdentifier);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }
    }

    public static interface Impl
    extends DBMemberElement.Impl {
        public boolean isUnique();

        public void setUnique(boolean var1) throws DBException;

        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);
    }
}

