/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.Dimension;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.options.indentation.CustomizerSelector;
import org.netbeans.modules.options.indentation.IndentationPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class IndentationPanelController
implements PreferencesCustomizer,
PreviewProvider {
    private static final Logger LOG = Logger.getLogger(IndentationPanelController.class.getName());
    private final MimePath mimePath;
    private final CustomizerSelector.PreferencesFactory prefsFactory;
    private final Preferences allLanguagesPreferences;
    private final Preferences preferences;
    private final PreferencesCustomizer delegate;
    private JComponent indentationPanel;

    public IndentationPanelController(Preferences preferences) {
        this(MimePath.EMPTY, null, preferences, null, null);
    }

    public IndentationPanelController(MimePath mimePath, CustomizerSelector.PreferencesFactory preferencesFactory, Preferences preferences, Preferences preferences2, PreferencesCustomizer preferencesCustomizer) {
        assert (mimePath != null);
        assert (preferences != null);
        assert (preferences2 == null && preferencesCustomizer == null || preferences2 != null && preferencesCustomizer != null);
        assert (preferencesCustomizer == null || preferencesCustomizer instanceof PreviewProvider);
        this.mimePath = mimePath;
        this.prefsFactory = preferencesFactory;
        this.preferences = preferences;
        this.allLanguagesPreferences = preferences2;
        this.delegate = preferencesCustomizer;
    }

    public JComponent getComponent() {
        if (this.indentationPanel == null) {
            if (this.delegate != null) {
                this.indentationPanel = new JPanel();
                this.indentationPanel.setLayout(new BoxLayout(this.indentationPanel, 1));
                JComponent jComponent = this.delegate.getComponent();
                this.indentationPanel.setName(jComponent.getName());
                this.indentationPanel.add(new IndentationPanel(this.mimePath, this.prefsFactory, this.preferences, this.allLanguagesPreferences, (PreviewProvider)((Object)this.delegate)));
                this.indentationPanel.add(jComponent);
                JPanel jPanel = new JPanel();
                jPanel.setPreferredSize(new Dimension(10, Integer.MAX_VALUE));
                this.indentationPanel.add(jPanel);
            } else {
                this.indentationPanel = new IndentationPanel(this.mimePath, this.prefsFactory, this.preferences, null, null);
            }
        }
        return this.indentationPanel;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IndentationPanelController.class, (String)"indentation-customizer-display-name");
    }

    public String getId() {
        return "tabs-and-indents";
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = null;
        if (this.delegate != null) {
            helpCtx = this.delegate.getHelpCtx();
        }
        return helpCtx != null ? helpCtx : new HelpCtx("netbeans.optionsDialog.editor.identation");
    }

    public JComponent getPreviewComponent() {
        if (this.delegate != null) {
            return ((PreviewProvider)((Object)this.delegate)).getPreviewComponent();
        }
        return this.getIndentationPanel().getPreviewProvider().getPreviewComponent();
    }

    public void refreshPreview() {
        if (this.delegate != null) {
            ((PreviewProvider)((Object)this.delegate)).refreshPreview();
        } else {
            this.getIndentationPanel().getPreviewProvider().refreshPreview();
        }
    }

    private IndentationPanel getIndentationPanel() {
        assert (this.indentationPanel instanceof IndentationPanel);
        return (IndentationPanel)this.indentationPanel;
    }
}

