/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.MultipleCallStackPanel;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.CallStackTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadDumpFilter;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateIcon;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadStackVisualizer
extends JPanel
implements Visualizer<ThreadStackVisualizerConfiguration>,
SessionStateListener,
DataFilterListener {
    private final ThreadStackVisualizerConfiguration configuration;
    private ThreadDump descriptor;
    private ThreadStackVisualizerConfiguration.StackNameProvider stackNameProvider;
    private long dumpTime;
    private final MultipleCallStackPanel stackPanel;
    private JPanel emptyPanel;
    private final CardLayout cardLayout = new CardLayout();
    private DLightSession session;
    private List<DataFilter> filters;
    private int prefferedSelection = -1;
    private final Object lock = new Lock();
    private final Object uiLock = new UiLock();
    private boolean needUpdate = false;

    ThreadStackVisualizer(ThreadStackVisualizerConfiguration threadStackVisualizerConfiguration, StackDataProvider stackDataProvider) {
        this.descriptor = threadStackVisualizerConfiguration.getThreadDump();
        this.dumpTime = threadStackVisualizerConfiguration.getDumpTime();
        this.stackNameProvider = threadStackVisualizerConfiguration.getStackNameProvider();
        this.configuration = threadStackVisualizerConfiguration;
        this.stackPanel = MultipleCallStackPanel.createInstance((SourceFileInfoDataProvider)stackDataProvider);
        this.setLayout(this.cardLayout);
        this.emptyPanel = new JPanel();
        this.add((Component)this.emptyPanel, "empty");
        this.add((Component)this.stackPanel, "stack");
        if (this.descriptor == null || this.descriptor.getThreadStates().isEmpty()) {
            this.setEmptyContent();
        } else {
            this.setNonEmptyContent();
        }
    }

    private void setEmptyContent() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cardLayout.show(this, "empty");
        this.emptyPanel.removeAll();
        this.emptyPanel.setLayout(new BoxLayout(this.emptyPanel, 1));
        long l = 0L;
        if (this.descriptor != null) {
            l = ThreadStateColumnImpl.timeStampToMilliSeconds(this.descriptor.getTimestamp()) - this.dumpTime;
        }
        String string = TimeLineUtils.getMillisValue(l);
        String string2 = NbBundle.getMessage(ThreadStackVisualizer.class, (String)"ThreadStackVisualizerNoStackAt", (Object)string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setAlignmentX(0.5f);
        this.emptyPanel.add(jLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNonEmptyContent() {
        Object object = this.lock;
        synchronized (object) {
            long l = ThreadStateColumnImpl.timeStampToMilliSeconds(this.descriptor.getTimestamp()) - this.dumpTime;
            String string = TimeLineUtils.getMillisValue(l);
            final String string2 = NbBundle.getMessage(ThreadStackVisualizer.class, (String)"ThreadStackVisualizerStackAt", (Object)string);
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    final ThreadSnapshot[] threadSnapshotArray = ThreadStackVisualizer.this.descriptor.getThreadStates().toArray(new ThreadSnapshot[0]);
                    final Vector<List> vector = new Vector<List>();
                    vector.setSize(threadSnapshotArray.length);
                    int n = threadSnapshotArray.length;
                    for (int i = 0; i < n; ++i) {
                        ThreadSnapshot threadSnapshot = threadSnapshotArray[i];
                        ThreadState.MSAState mSAState = threadSnapshot.getState();
                        ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
                        if (threadStateResources == null) continue;
                        vector.set(i, threadSnapshot.getStack());
                    }
                    UIThread.invoke((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = ThreadStackVisualizer.this.uiLock;
                            synchronized (object) {
                                assert (SwingUtilities.isEventDispatchThread());
                                ThreadStackVisualizer.this.stackPanel.clean();
                                ThreadStackVisualizer.this.stackPanel.setRootVisible(string2);
                                int n = threadSnapshotArray.length;
                                for (int i = 0; i < n; ++i) {
                                    List list;
                                    ThreadSnapshot threadSnapshot = threadSnapshotArray[i];
                                    ThreadState.MSAState mSAState = threadSnapshot.getState();
                                    ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
                                    if (threadStateResources == null || (list = (List)vector.get(i)) == null) continue;
                                    ThreadStackVisualizer.this.stackPanel.add(ThreadStackVisualizer.this.stackNameProvider.getStackName(threadSnapshot), (Icon)new ThreadStateIcon(mSAState, 10, 10), list, ThreadStackVisualizer.this.configuration.getStackNodeActionsProvider().getStackNodeActions(threadSnapshot.getThreadInfo().getThreadId()));
                                    if (ThreadStackVisualizer.this.configuration.getPreferredSelection() != (long)threadSnapshot.getThreadInfo().getThreadId()) continue;
                                    ThreadStackVisualizer.this.prefferedSelection = i;
                                }
                                ThreadStackVisualizer.this.cardLayout.show(ThreadStackVisualizer.this, "stack");
                                ThreadStackVisualizer.this.selectRootNode();
                            }
                        }
                    });
                }
            }, (String)"Fill in panel for a stack");
        }
    }

    void selectRootNode() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (ThreadStackVisualizer.this.configuration.getPrefferedExpansion() == ThreadStackVisualizerConfiguration.ExpansionMode.ExpandAll) {
                    ThreadStackVisualizer.this.stackPanel.expandAll();
                }
                int n = 0;
                for (Node node : ThreadStackVisualizer.this.stackPanel.getExplorerManager().getRootContext().getChildren().getNodes()) {
                    if (n == ThreadStackVisualizer.this.prefferedSelection) {
                        try {
                            if (ThreadStackVisualizer.this.configuration.getPrefferedExpansion() == ThreadStackVisualizerConfiguration.ExpansionMode.ExpandCurrent) {
                                ThreadStackVisualizer.this.stackPanel.expandNode(node);
                            }
                            ThreadStackVisualizer.this.stackPanel.getExplorerManager().setSelectedNodes(new Node[]{node});
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            Exceptions.printStackTrace((Throwable)propertyVetoException);
                        }
                        break;
                    }
                    ++n;
                }
            }
        }, 500);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CallStackDetails");
    }

    public ThreadStackVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return CallStackTopComponent.findInstance();
    }

    @Override
    public boolean requestFocus(boolean bl) {
        if (this.stackPanel != null) {
            return this.stackPanel.requestFocus(bl);
        }
        return super.requestFocus(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.needUpdate) {
                return;
            }
            Collection<ThreadDumpFilter> collection = this.getDataFilter(ThreadDumpFilter.class);
            if (collection != null && !collection.isEmpty()) {
                ThreadDumpFilter threadDumpFilter = collection.iterator().next();
                this.dumpTime = threadDumpFilter.getDumpTime();
                this.descriptor = threadDumpFilter.getThreadDump();
            }
            this.needUpdate = false;
            if (!EventQueue.isDispatchThread()) {
                UIThread.invoke((Runnable)new Runnable(){

                    public void run() {
                        if (ThreadStackVisualizer.this.descriptor == null || ThreadStackVisualizer.this.descriptor.getThreadStates().isEmpty()) {
                            ThreadStackVisualizer.this.setEmptyContent();
                        } else {
                            ThreadStackVisualizer.this.setNonEmptyContent();
                        }
                    }
                });
            } else if (this.descriptor == null || this.descriptor.getThreadStates().isEmpty()) {
                this.setEmptyContent();
            } else {
                this.setNonEmptyContent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends DataFilter> Collection<T> getDataFilter(Class<T> clazz) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (DataFilter dataFilter : this.filters) {
                if (dataFilter.getClass() == clazz) {
                    arrayList.add(clazz.cast(dataFilter));
                    continue;
                }
                try {
                    Class<T> clazz2 = dataFilter.getClass().asSubclass(clazz);
                    arrayList.add(clazz.cast(dataFilter));
                }
                catch (ClassCastException classCastException) {}
            }
            return arrayList;
        }
    }

    public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        if (this.session == null | this.session != dLightSession) {
            if (this.session != dLightSession && this.session != null) {
                this.session.removeSessionStateListener((SessionStateListener)this);
                this.session.removeDataFilterListener((DataFilterListener)this);
            }
            this.session = dLightSession;
            this.session.addDataFilterListener((DataFilterListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        if (bl) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.filters = new ArrayList<DataFilter>(list);
            this.needUpdate = !this.getDataFilter(ThreadDumpFilter.class).isEmpty();
        }
    }

    public void updateVisualizerConfiguration(ThreadStackVisualizerConfiguration threadStackVisualizerConfiguration) {
        this.configuration.update(threadStackVisualizerConfiguration);
    }

    private static final class UiLock {
        private UiLock() {
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

