/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.vmd.api.model.Debug;
import org.openide.text.IndentEngine;

public final class CodeWriter {
    private StyledDocument document;
    private String forceValue;
    private SimpleSection section;
    private int offset;
    private int endOffset;
    private Writer writer;
    private StringWriter memory;
    private boolean committed;

    public CodeWriter(StyledDocument styledDocument, SimpleSection simpleSection) {
        this(styledDocument, simpleSection.getStartPosition().getOffset(), Integer.MIN_VALUE, null);
        this.section = simpleSection;
    }

    public CodeWriter(StyledDocument styledDocument, SimpleSection simpleSection, SimpleSection simpleSection2, String string) {
        this(styledDocument, simpleSection.getEndPosition().getOffset() + 1, simpleSection2.getStartPosition().getOffset(), string);
    }

    private CodeWriter(StyledDocument styledDocument, int n, int n2, String string) {
        this.document = styledDocument;
        this.forceValue = string;
        this.offset = n;
        this.endOffset = n2;
    }

    public CodeWriter write(String string) {
        assert (!this.committed);
        if (this.forceValue != null) {
            return this;
        }
        try {
            if (this.writer == null) {
                this.memory = new StringWriter(512);
                IndentEngine indentEngine = IndentEngine.find((Document)this.document);
                this.writer = indentEngine != null ? indentEngine.createWriter((Document)this.document, this.offset, (Writer)this.memory) : this.memory;
            }
            this.writer.write(string);
            return this;
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
    }

    public void commit() {
        assert (!this.committed);
        try {
            String string;
            if (this.forceValue != null) {
                string = this.forceValue;
            } else if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                string = this.memory.getBuffer().toString();
            } else {
                string = "";
            }
            if (this.section != null) {
                this.section.setText(string);
            } else {
                if (this.endOffset != Integer.MIN_VALUE) {
                    this.document.remove(this.offset, this.endOffset - this.offset);
                }
                this.document.insertString(this.offset, string, null);
            }
            this.committed = true;
            this.writer = null;
            this.memory = null;
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
        catch (BadLocationException badLocationException) {
            throw Debug.error((Object[])new Object[]{badLocationException});
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }
}

