/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.TablesClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStatement {
    SQLStatementKind kind;
    int startOffset;
    int endOffset;
    SortedMap<Integer, Context> offset2Context;
    TablesClause tablesClause;
    private List<SelectStatement> subqueries;

    SQLStatement(int n, int n2, SortedMap<Integer, Context> sortedMap) {
        this(n, n2, sortedMap, null, null);
    }

    SQLStatement(int n, int n2, SortedMap<Integer, Context> sortedMap, TablesClause tablesClause) {
        this(n, n2, sortedMap, tablesClause, null);
    }

    SQLStatement(int n, int n2, SortedMap<Integer, Context> sortedMap, TablesClause tablesClause, List<SelectStatement> list) {
        this.startOffset = n;
        this.endOffset = n2;
        this.offset2Context = sortedMap;
        this.tablesClause = tablesClause;
        this.subqueries = list;
    }

    public SQLStatementKind getKind() {
        return this.kind;
    }

    public Context getContextAtOffset(int n) {
        if (n < this.startOffset || n > this.endOffset) {
            return null;
        }
        Context context = null;
        if (this.subqueries != null) {
            for (SelectStatement object : this.subqueries) {
                context = object.getContextAtOffset(n);
                if (context == null) continue;
                return context;
            }
        }
        for (Map.Entry entry : this.offset2Context.entrySet()) {
            if (n >= (Integer)entry.getKey()) {
                context = (Context)((Object)entry.getValue());
                continue;
            }
            return context;
        }
        return context;
    }

    public List<SelectStatement> getSubqueries() {
        return this.subqueries;
    }

    TablesClause getTablesClause() {
        return this.tablesClause;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Context {
        START(0),
        DELETE(200),
        DROP(300),
        DROP_TABLE(310),
        INSERT(400),
        INSERT_INTO(410),
        COLUMNS(420),
        VALUES(430),
        SELECT(500),
        FROM(510),
        JOIN_CONDITION(520),
        WHERE(530),
        GROUP(540),
        GROUP_BY(550),
        HAVING(560),
        ORDER(570),
        ORDER_BY(580),
        UPDATE(600),
        SET(610),
        CREATE(700),
        CREATE_PROCEDURE(710),
        CREATE_FUNCTION(720),
        BEGIN(730),
        END(740);

        private final int order;

        private Context(int n2) {
            this.order = n2;
        }

        public boolean isAfter(Context context) {
            return this.order >= context.order;
        }
    }
}

