/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.CommandReport;
import org.netbeans.modules.subversion.client.MissingClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.config.CertificateFile;
import org.netbeans.modules.subversion.kenai.SvnKenaiSupport;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientExceptionHandler {
    private final ISVNClientAdapter adapter;
    private final SvnClient client;
    private final SvnClientDescriptor desc;
    private final int handledExceptions;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String CHARSET_NAME = "ASCII7";
    private final boolean commandLine;
    private CertificateFailure[] failures = new CertificateFailure[]{new CertificateFailure(1, "certificate is not yet valid", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotYetValid")), new CertificateFailure(2, "certificate has expired", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureHasExpired")), new CertificateFailure(4, "certificate issued for a different hostname", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureWrongHostname")), new CertificateFailure(8, "issuer is not trusted", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotTrusted"))};
    public static final int EX_UNKNOWN = 0;
    public static final int EX_ACTION_CANCELED_BY_USER = 2;
    public static final int EX_AUTHENTICATION = 4;
    public static final int EX_NO_CERTIFICATE = 8;
    public static final int EX_WRONG_URL = 16;
    public static final int EX_NO_HOST_CONNECTION = 32;
    public static final int EX_UNVERSIONED_RESOURCE = 64;
    public static final int EX_WRONG_URL_IN_REVISION = 128;
    public static final int EX_URL_NON_EXISTENT = 256;
    public static final int EX_HTTP_405 = 512;
    public static final int EX_IS_ALREADY_WC = 1024;
    public static final int EX_CLOSED_CONNECTION = 2048;
    public static final int EX_COMMIT_FAILED = 4096;
    public static final int EX_FILE_ALREADY_EXISTS = 8192;
    public static final int EX_IS_OUT_OF_DATE = 16384;
    public static final int EX_NO_SVN_CLIENT = 32768;
    public static final int EX_HTTP_FORBIDDEN = 65536;
    public static final int EX_SSL_NEGOTIATION_FAILED = 131072;
    public static final int EX_HANDLED_EXCEPTIONS = 131116;
    public static final int EX_DEFAULT_HANDLED_EXCEPTIONS = 131116;
    private final SVNClientException exception;
    private final int exceptionMask;
    static final String ACTION_CANCELED_BY_USER = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ActionCanceledByUser");

    public SvnClientExceptionHandler(SVNClientException sVNClientException, ISVNClientAdapter iSVNClientAdapter, SvnClient svnClient, SvnClientDescriptor svnClientDescriptor, int n, boolean bl) {
        this.exception = sVNClientException;
        this.adapter = iSVNClientAdapter;
        this.client = svnClient;
        this.desc = svnClientDescriptor;
        this.handledExceptions = n;
        this.exceptionMask = SvnClientExceptionHandler.getMask(sVNClientException.getMessage());
        this.commandLine = bl;
    }

    public boolean handleException() throws Exception {
        if (this.exceptionMask != 0) {
            if ((this.handledExceptions & this.exceptionMask & 0x20) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
            if ((this.handledExceptions & this.exceptionMask & 8) == this.exceptionMask) {
                return this.handleNoCertificateError();
            }
            if ((this.handledExceptions & this.exceptionMask & 4) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
            if ((this.handledExceptions & this.exceptionMask & 0x20000) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
        }
        throw this.getException();
    }

    public boolean handleKenaiAuthorisation(SvnKenaiSupport svnKenaiSupport, String string) {
        PasswordAuthentication passwordAuthentication = svnKenaiSupport.getPasswordAuthentication(true);
        if (passwordAuthentication == null) {
            return false;
        }
        String string2 = passwordAuthentication.getUserName();
        char[] cArray = passwordAuthentication.getPassword();
        this.adapter.setUsername(string2 != null ? string2 : "");
        if (this.commandLine) {
            this.adapter.setPassword(cArray != null ? new String(cArray) : "");
        }
        return true;
    }

    private boolean handleRepositoryConnectError() {
        boolean bl;
        SVNUrl sVNUrl = this.getRemoteHostUrl();
        SvnKenaiSupport svnKenaiSupport = SvnKenaiSupport.getInstance();
        if (svnKenaiSupport.isKenai(sVNUrl.toString())) {
            return svnKenaiSupport.showLogin() && this.handleKenaiAuthorisation(svnKenaiSupport, sVNUrl.toString());
        }
        Repository repository = new Repository(64, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_ConnectionParameters"));
        repository.selectUrl(sVNUrl, true);
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Retry"));
        String string = (this.exceptionMask & 0x20) == this.exceptionMask ? NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_CouldNotConnect") : NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_AuthFailed");
        Object object = repository.show(string, new HelpCtx(this.getClass()), new Object[]{jButton, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel")}, jButton);
        boolean bl2 = bl = object == jButton;
        if (bl) {
            RepositoryConnection repositoryConnection = repository.getSelectedRC();
            String string2 = repositoryConnection.getUsername();
            String string3 = repositoryConnection.getPassword();
            this.adapter.setUsername(string2);
            if (this.commandLine) {
                this.adapter.setPassword(string3);
            }
            SvnModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
        }
        return bl;
    }

    private boolean handleNoCertificateError() throws Exception {
        SSLSocket sSLSocket;
        SVNUrl sVNUrl = this.getSVNUrl();
        String string = sVNUrl.getProtocol() + "://" + sVNUrl.getHost() + ":" + sVNUrl.getPort();
        String string2 = SvnUtils.ripUserFromHost(sVNUrl.getHost());
        File file = CertificateFile.getSystemCertFile(string);
        File file2 = CertificateFile.getNBCertFile(string);
        if (!file2.exists() && file.exists()) {
            FileUtils.copyFile(file, CertificateFile.getNBCertFile(string));
            return true;
        }
        try {
            sSLSocket = this.getSSLSocket(string2, sVNUrl.getPort());
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.SEVERE, null, exception);
            return false;
        }
        if (sSLSocket == null) {
            return false;
        }
        X509Certificate x509Certificate = null;
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSocket.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            Subversion.LOG.log(Level.SEVERE, null, sSLPeerUnverifiedException);
            return false;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (!(certificateArray[i] instanceof X509Certificate)) continue;
            x509Certificate = (X509Certificate)certificateArray[i];
            try {
                x509Certificate.checkValidity();
                break;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                continue;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(this.getCertMessage(x509Certificate, string2));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.subversion.serverCertificateVerification"));
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton jButton2 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton jButton3 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{jButton, jButton2, jButton3});
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() != jButton && dialogDescriptor.getValue() != jButton2) {
            return false;
        }
        CertificateFile certificateFile = null;
        try {
            boolean bl = dialogDescriptor.getValue() == jButton2;
            certificateFile = new CertificateFile(x509Certificate, "https://" + string2 + ":" + sVNUrl.getPort(), this.getFailuresMask(), bl);
            certificateFile.store();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Subversion.LOG.log(Level.SEVERE, null, certificateEncodingException);
            return false;
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.SEVERE, null, iOException);
            return false;
        }
        return true;
    }

    private SVNUrl getSVNUrl() {
        String string = this.getRealmFromException();
        SVNUrl sVNUrl = null;
        if (string != null) {
            try {
                sVNUrl = new SVNUrl(string);
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
            }
        }
        if (sVNUrl == null) {
            sVNUrl = this.client.getSvnUrl();
        }
        return sVNUrl;
    }

    private String getRealmFromException() {
        String[] stringArray;
        String string = this.exception.getMessage().toLowerCase();
        for (String string2 : stringArray = new String[]{"host not found (", "could not connect to server (", "could not resolve hostname (", "issuer is not trusted (", "authorization failed ("}) {
            int n;
            int n2 = string.indexOf(string2);
            if (n2 < 0 || (n = string.indexOf(")", n2 + string2.length())) < 0) continue;
            return string.substring(n2 + string2.length(), n);
        }
        return null;
    }

    private SSLSocket getSSLSocket(String string, int n) throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        ProxySettings proxySettings = new ProxySettings();
        String string2 = proxySettings.getHttpsHost();
        int n2 = proxySettings.getHttpsPort();
        if (string2.equals("")) {
            string2 = proxySettings.getHttpHost();
            n2 = proxySettings.getHttpPort();
        }
        Socket socket = new Socket(Proxy.NO_PROXY);
        if (proxySettings.isDirect()) {
            socket.connect(new InetSocketAddress(string, n));
        } else {
            boolean bl = false;
            try {
                socket.connect(new InetSocketAddress(string, n));
                bl = true;
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.FINE, null, exception);
            }
            if (!bl) {
                socket = new Socket(Proxy.NO_PROXY);
                socket.connect(new InetSocketAddress(string2, n2));
                this.connectProxy(socket, string, n, string2, n2, proxySettings.getUsername(), proxySettings.getPassword());
            }
        }
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(this.getKeyManagers(), trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    private KeyManager[] getKeyManagers() {
        try {
            SVNUrl sVNUrl = this.getRemoteHostUrl();
            RepositoryConnection repositoryConnection = SvnModuleConfig.getDefault().getRepositoryConnection(sVNUrl.toString());
            if (repositoryConnection == null) {
                return null;
            }
            String string = repositoryConnection.getCertFile();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            String string2 = repositoryConnection.getCertPassword();
            char[] cArray = string2 != null ? string2.toCharArray() : null;
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(new FileInputStream(string), cArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.SEVERE, null, exception);
            return null;
        }
    }

    private SVNUrl getRemoteHostUrl() {
        SVNUrl sVNUrl;
        SVNUrl sVNUrl2 = sVNUrl = this.desc != null ? this.desc.getSvnUrl() : null;
        if (sVNUrl == null) {
            sVNUrl = this.getSVNUrl();
        }
        return sVNUrl;
    }

    private void connectProxy(Socket socket, String string, int n, String string2, int n2, String string3, String string4) throws IOException {
        byte[] byArray;
        StringBuilder stringBuilder = new StringBuilder("CONNECT ").append(string).append(":").append(n).append(" HTTP/1.0\r\n").append("Connection: Keep-Alive\r\n");
        if (string3 != null && string4 != null && string3.length() > 0) {
            Subversion.LOG.info("connectProxy: adding proxy authorization field");
            stringBuilder.append("Proxy-Authorization: Basic ").append(Base64Encoder.encode((byte[])(string3 + ":" + string4).getBytes())).append("\r\n");
        }
        String string5 = stringBuilder.append("\r\n").toString();
        try {
            byArray = string5.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string5.getBytes();
        }
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        while (n4 < 2) {
            byte by = (byte)inputStream.read();
            if (by < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (by == 10) {
                bl = true;
                ++n4;
                continue;
            }
            if (by == 13) continue;
            n4 = 0;
            if (bl || n3 >= byArray2.length) continue;
            byArray2[n3++] = by;
        }
        String string6 = "";
        try {
            string6 = new String(byArray2, 0, n3, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string6 = new String(byArray2, 0, n3);
        }
        if (!this.isOKresponse(string6.toLowerCase())) {
            throw new IOException("Unable to connect through proxy " + string2 + ":" + n2 + ".  Proxy returns \"" + string6 + "\"");
        }
    }

    private boolean isOKresponse(String string) {
        return string.startsWith("http/1.1 200") || string.startsWith("http/1.0 200");
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private String getCertMessage(X509Certificate x509Certificate, String string) {
        CertificateFailure[] certificateFailureArray = this.getCertFailures();
        Object[] objectArray = new Object[]{string, x509Certificate.getNotBefore(), x509Certificate.getNotAfter(), x509Certificate.getIssuerDN().getName(), this.getFingerprint(x509Certificate, "SHA1"), this.getFingerprint(x509Certificate, "MD5")};
        String string2 = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_BadCertificate", (Object[])objectArray);
        for (int i = 0; i < certificateFailureArray.length; ++i) {
            string2 = certificateFailureArray[i].message + string2;
        }
        return string2;
    }

    private CertificateFailure[] getCertFailures() {
        ArrayList<CertificateFailure> arrayList = new ArrayList<CertificateFailure>();
        String string = this.getException().getMessage();
        for (int i = 0; i < this.failures.length; ++i) {
            if (string.indexOf(this.failures[i].error) <= -1) continue;
            arrayList.add(this.failures[i]);
        }
        return arrayList.toArray(new CertificateFailure[arrayList.size()]);
    }

    private int getFailuresMask() {
        CertificateFailure[] certificateFailureArray = this.getCertFailures();
        if (certificateFailureArray.length == 0) {
            return 15;
        }
        int n = 0;
        for (int i = 0; i < certificateFailureArray.length; ++i) {
            n |= certificateFailureArray[i].mask;
        }
        return n;
    }

    private String getFingerprint(X509Certificate x509Certificate, String string) {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            return Utils.getHash((String)string, (byte[])byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Subversion.LOG.log(Level.INFO, certificateEncodingException.getMessage(), certificateEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Subversion.LOG.log(Level.INFO, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        return "";
    }

    private SVNClientException getException() {
        return this.exception;
    }

    private static int getMask(String string) {
        if (string == null || string.trim().equals("")) {
            return 0;
        }
        if (SvnClientExceptionHandler.isAuthentication(string = string.toLowerCase())) {
            return 4;
        }
        if (SvnClientExceptionHandler.isCancelledAction(string)) {
            return 2;
        }
        if (SvnClientExceptionHandler.isNoCertificate(string)) {
            return 8;
        }
        if (SvnClientExceptionHandler.isWrongUrl(string)) {
            return 16;
        }
        if (SvnClientExceptionHandler.isNoHostConnection(string)) {
            return 32;
        }
        if (SvnClientExceptionHandler.isUnversionedResource(string)) {
            return 64;
        }
        if (SvnClientExceptionHandler.isWrongURLInRevision(string)) {
            return 128;
        }
        if (SvnClientExceptionHandler.isHTTP405(string)) {
            return 512;
        }
        if (SvnClientExceptionHandler.isAlreadyAWorkingCopy(string)) {
            return 1024;
        }
        if (SvnClientExceptionHandler.isClosedConnection(string)) {
            return 2048;
        }
        if (SvnClientExceptionHandler.isCommitFailed(string)) {
            return 4096;
        }
        if (SvnClientExceptionHandler.isNoCliSvnClient(string)) {
            return 32768;
        }
        if (SvnClientExceptionHandler.isHTTP403(string)) {
            return 65536;
        }
        if (SvnClientExceptionHandler.isSSLNegotiation(string)) {
            return 131072;
        }
        return 0;
    }

    public static boolean isCancelledAction(String string) {
        return string.equals(ACTION_CANCELED_BY_USER);
    }

    static boolean isOperationCancelled(String string) {
        return (string = string.toLowerCase()).indexOf("operation canceled") > -1;
    }

    public static boolean isAuthentication(String string) {
        return (string = string.toLowerCase()).indexOf("authentication error from server: username not found") > -1 || string.indexOf("authorization failed") > -1 || string.indexOf("authentication failed") > -1 || string.indexOf("authentication error from server: password incorrect") > -1 || string.indexOf("can't get password") > -1 || string.indexOf("can't get username or password") > -1;
    }

    public static boolean isNoCertificate(String string) {
        return (string = string.toLowerCase()).indexOf("server certificate verification failed") > -1;
    }

    public static boolean isWrongUrl(String string) {
        return (string = string.toLowerCase()).indexOf("(not a valid url)") > -1 || string.indexOf("bad url passed to ra layer") > -1;
    }

    private static boolean isNoHostConnection(String string) {
        return (string = string.toLowerCase()).indexOf("host not found") > -1 || string.indexOf("could not connect to server") > -1 || string.indexOf("could not resolve hostname") > -1;
    }

    public static boolean isUnversionedResource(String string) {
        return (string = string.toLowerCase()).indexOf("(not a versioned resource)") > -1 || string.indexOf("is not a working copy") > -1;
    }

    public static boolean isTooOldClientForWC(String string) {
        return (string = string.toLowerCase()).indexOf("this client is too old") > -1;
    }

    public static boolean isWrongURLInRevision(String string) {
        if ((string = string.toLowerCase()).indexOf("no such revision") > -1) {
            return true;
        }
        int n = string.indexOf("unable to find repository location for");
        if (n > -1 && string.indexOf("in revision", n + 23) > -1) {
            return true;
        }
        n = string.indexOf("url");
        return n > -1 && string.indexOf("non-existent in that revision", n + 3) > -1;
    }

    private static boolean isHTTP405(String string) {
        return string.indexOf("405") > -1;
    }

    public static boolean isHTTP403(String string) {
        return string.indexOf("403") > -1;
    }

    public static boolean isSSLNegotiation(String string) {
        return (string = string.toLowerCase()).indexOf("ssl negotiation failed: ssl error: sslv3 alert handshake failure") > -1;
    }

    public static boolean isReportOf200(String string) {
        int n = (string = string.toLowerCase()).indexOf("svn: report of");
        if (n < 0) {
            return false;
        }
        return string.indexOf("200", n + 13) > -1;
    }

    public static boolean isSecureConnTruncated(String string) {
        return (string = string.toLowerCase()).indexOf("could not read chunk size: secure connection truncated") > -1;
    }

    public static boolean isFileNotFoundInRevision(String string) {
        return (string = string.toLowerCase()).indexOf("file not found: revision") > -1 || string.indexOf("unable to find repository location for") > -1 && string.indexOf("in revision") > -1;
    }

    public static boolean isPathNotFound(String string) {
        return (string = string.toLowerCase()).indexOf("path not found") > -1;
    }

    private static boolean isAlreadyAWorkingCopy(String string) {
        return (string = string.toLowerCase()).indexOf("is already a working copy for a different url") > -1;
    }

    private static boolean isClosedConnection(String string) {
        return (string = string.toLowerCase()).indexOf("could not read status line: an existing connection was forcibly closed by the remote host.") > -1;
    }

    private static boolean isCommitFailed(String string) {
        return (string = string.toLowerCase()).indexOf("commit failed (details follow)") > -1;
    }

    public static boolean isFileAlreadyExists(String string) {
        return (string = string.toLowerCase()).indexOf("file already exists") > -1 || string.indexOf("mkcol") > -1 && SvnClientExceptionHandler.isHTTP405(string);
    }

    private static boolean isOutOfDate(String string) {
        return (string = string.toLowerCase()).indexOf("out of date") > -1 || string.indexOf("out-of-date") > -1;
    }

    public static boolean isNoCliSvnClient(String string) {
        return (string = string.toLowerCase()).indexOf("command line client adapter is not available") > -1 || string.indexOf(CommandlineClient.ERR_CLI_NOT_AVALABLE) > -1;
    }

    public static boolean isUnsupportedJavaHl(String string) {
        return (string = string.toLowerCase()).indexOf(CommandlineClient.ERR_JAVAHL_NOT_SUPPORTED) > -1;
    }

    public static boolean isMissingOrLocked(String string) {
        int n = (string = string.toLowerCase()).indexOf("svn: working copy");
        if (n > -1) {
            return string.indexOf("is missing or not locked", n + 17) > -1;
        }
        n = string.indexOf("svn: directory");
        if (n > -1) {
            return string.indexOf("is missing", n + 13) > -1;
        }
        return false;
    }

    public static boolean isTargetDirectory(String string) {
        return (string = string.toLowerCase()).indexOf("refers to a directory") > -1;
    }

    public static boolean isWrongUUID(String string) {
        return (string = string.toLowerCase()).contains("has uuid") && string.contains("but the wc has");
    }

    public static void notifyException(Exception exception, boolean bl, boolean bl2) {
        if (SvnClientExceptionHandler.isNoCliSvnClient(exception.getMessage())) {
            if (bl2) {
                SvnClientExceptionHandler.notifyNoClient();
            }
            return;
        }
        if (SvnClientExceptionHandler.isCancelledAction(exception.getMessage())) {
            SvnClientExceptionHandler.cancelledAction();
            return;
        }
        Subversion.LOG.log(Level.INFO, exception.getMessage(), exception);
        if (bl) {
            String string = SvnClientExceptionHandler.getCustomizedMessage(exception);
            if (string == null) {
                string = exception instanceof SVNClientException ? SvnClientExceptionHandler.parseExceptionMessage((SVNClientException)((Object)exception)) : exception.getMessage();
            }
            SvnClientExceptionHandler.annotate(string);
        }
    }

    public static boolean handleLogException(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNClientException sVNClientException) {
        String string = sVNUrl.getProtocol();
        if (string.startsWith("https") && SvnClientExceptionHandler.isSecureConnTruncated(sVNClientException.getMessage()) || string.startsWith("http") && SvnClientExceptionHandler.isReportOf200(sVNClientException.getMessage()) || (string.startsWith("file") || string.startsWith("svn+")) && SvnClientExceptionHandler.isFileNotFoundInRevision(sVNClientException.getMessage())) {
            Subversion.LOG.log(Level.INFO, sVNClientException.getMessage(), sVNClientException);
            SvnClientExceptionHandler.annotate(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ErrorFileNotFoundInRevision", (Object[])new String[]{sVNRevision.toString()}));
            return true;
        }
        return false;
    }

    private static void notifyNoClient() {
        MissingClient missingClient = new MissingClient();
        missingClient.show();
    }

    private static String getCustomizedMessage(Exception exception) {
        String string = null;
        if (SvnClientExceptionHandler.isHTTP405(exception.getMessage())) {
            string = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error405");
        } else if (SvnClientExceptionHandler.isOutOfDate(exception.getMessage()) || SvnClientExceptionHandler.isMissingOrLocked(exception.getMessage())) {
            string = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_OutOfDate") + "\n";
        } else if (SvnClientExceptionHandler.isWrongUUID(exception.getMessage())) {
            string = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_RelocateWrongUUID") + "\n";
        }
        return string;
    }

    public static String parseExceptionMessage(SVNClientException sVNClientException) {
        String string = sVNClientException.getMessage();
        string = string.replace("svn: warning: ", "");
        if (SvnClientExceptionHandler.isTooOldClientForWC(string = string.replace("svn: ", ""))) {
            string = string + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_OldClient");
        }
        return string;
    }

    public static void annotate(String string) {
        CommandReport commandReport = new CommandReport(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_SubversionCommandError"), string);
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_CommandReport_OK"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)commandReport, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), -1, 0, new Object[]{jButton}, (Object)jButton);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    private static void cancelledAction() {
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)ACTION_CANCELED_BY_USER, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_ActionCanceled_Title"), -1, 2, new Object[]{jButton}, (Object)jButton);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    static void handleInvalidKeyException(InvalidKeyException invalidKeyException) {
        Subversion.LOG.log(Level.INFO, invalidKeyException.getMessage(), invalidKeyException);
        String string = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_InvalidKeyException");
        SvnClientExceptionHandler.annotate(string);
    }

    private class CertificateFailure {
        int mask;
        String error;
        String message;

        CertificateFailure(int n, String string, String string2) {
            this.mask = n;
            this.error = string;
            this.message = string2;
        }
    }
}

