/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryDiffView;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryFileView;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ShowLocalHistoryAction
extends NodeAction {
    public ShowLocalHistoryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodeArray) {
        VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
        final Set set = vCSContext.getRootFiles();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File[] fileArray = set.toArray(new File[set.size()]);
                final LocalHistoryTopComponent localHistoryTopComponent = new LocalHistoryTopComponent();
                localHistoryTopComponent.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_LocalHistoryTopComponent", (Object)fileArray[0].getName()));
                localHistoryTopComponent.open();
                localHistoryTopComponent.requestActive();
                if (fileArray[0].isFile()) {
                    LocalHistoryFileView localHistoryFileView = new LocalHistoryFileView();
                    LocalHistoryDiffView localHistoryDiffView = new LocalHistoryDiffView(localHistoryTopComponent);
                    localHistoryFileView.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)localHistoryDiffView);
                    localHistoryFileView.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                                localHistoryTopComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
                            }
                        }
                    });
                    localHistoryTopComponent.init(localHistoryDiffView.getPanel(), localHistoryFileView);
                    localHistoryFileView.refresh(fileArray);
                }
            }
        });
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
        Set set = vCSContext.getRootFiles();
        if (set == null || set.size() == 0) {
            return false;
        }
        for (File file : set) {
            if (file == null || file.isFile()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowLocalHistory");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowLocalHistoryAction.class);
    }
}

