/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.gen.Datasources;
import org.netbeans.modules.j2ee.jboss4.config.gen.LocalTxDatasource;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBossDatasourceManager
implements DatasourceManager {
    private static final String DSdotXML = "-ds.xml";
    private static final String JBossDSdotXML = "jboss-ds.xml";
    private FileObject serverDir;

    public JBossDatasourceManager(String string) {
        String string2 = InstanceProperties.getInstanceProperties((String)string).getProperty("deploy-dir");
        this.serverDir = FileUtil.toFileObject((File)new File(string2));
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        HashSet<Datasource> hashSet = new HashSet<Datasource>();
        if (!(this.serverDir != null && this.serverDir.isValid() && this.serverDir.isFolder() && this.serverDir.canRead())) {
            Logger.getLogger("global").log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_DEPLOY_DIR"));
            return hashSet;
        }
        Enumeration enumeration = this.serverDir.getChildren(true);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (fileObject.isFolder() || !fileObject.getNameExt().endsWith(DSdotXML) || !fileObject.canRead()) continue;
            linkedList.add(fileObject);
        }
        if (linkedList.size() == 0) {
            return hashSet;
        }
        for (FileObject fileObject : linkedList) {
            LocalTxDatasource[] localTxDatasourceArray;
            File file = FileUtil.toFile((FileObject)fileObject);
            try {
                Datasources datasources = null;
                try {
                    datasources = Datasources.createGraph(file);
                }
                catch (RuntimeException runtimeException) {
                    String string = NbBundle.getMessage(JBossDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)file.getAbsolutePath());
                    Logger.getLogger("global").log(Level.INFO, string);
                    continue;
                }
                localTxDatasourceArray = datasources.getLocalTxDatasource();
                for (int i = 0; i < localTxDatasourceArray.length; ++i) {
                    if (localTxDatasourceArray[i].getJndiName().length() <= 0) continue;
                    hashSet.add(new JBossDatasource(localTxDatasourceArray[i].getJndiName(), localTxDatasourceArray[i].getConnectionUrl(), localTxDatasourceArray[i].getUserName(), localTxDatasourceArray[i].getPassword(), localTxDatasourceArray[i].getDriverClass()));
                }
            }
            catch (IOException iOException) {
                localTxDatasourceArray = NbBundle.getMessage(JBossDatasourceManager.class, (String)"MSG_CannotReadDatasources", (Object)file.getAbsolutePath());
                throw new ConfigurationException((String)localTxDatasourceArray, (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                localTxDatasourceArray = NbBundle.getMessage(JBossDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)file.getAbsolutePath());
                throw new ConfigurationException((String)localTxDatasourceArray, (Throwable)runtimeException);
            }
        }
        return hashSet;
    }

    public void deployDatasources(Set<Datasource> set) throws ConfigurationException, DatasourceAlreadyExistsException {
        LocalTxDatasource[] localTxDatasourceArray;
        Object object;
        Object object22;
        Set<Datasource> set2 = this.getDatasources();
        Map<String, Datasource> map = this.transform(set2);
        HashMap<LocalTxDatasource[], Object> hashMap = new HashMap<LocalTxDatasource[], Object>();
        LinkedList<Datasource> linkedList = new LinkedList<Datasource>();
        for (Object object22 : set) {
            if (!(object22 instanceof JBossDatasource)) continue;
            object = (JBossDatasource)object22;
            localTxDatasourceArray = JBossDatasource.getRawName(((JBossDatasource)object).getJndiName());
            if (map.keySet().contains(localTxDatasourceArray)) {
                if (map.get(localTxDatasourceArray).equals(object)) continue;
                linkedList.add(map.get(localTxDatasourceArray));
                continue;
            }
            if (localTxDatasourceArray == null) continue;
            hashMap.put(localTxDatasourceArray, object);
        }
        if (linkedList.size() > 0) {
            throw new DatasourceAlreadyExistsException(linkedList);
        }
        FileObject fileObject = this.serverDir.getFileObject(JBossDSdotXML);
        object22 = fileObject != null ? FileUtil.toFile((FileObject)fileObject) : null;
        object = null;
        try {
            object = object22 != null ? Datasources.createGraph((File)object22) : new Datasources();
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotReadDSdotXml"));
            Logger.getLogger("global").log(Level.INFO, null, iOException);
            return;
        }
        localTxDatasourceArray = ((Datasources)((Object)object)).getLocalTxDatasource();
        for (int i = 0; i < localTxDatasourceArray.length; ++i) {
            Object object3 = localTxDatasourceArray[i].getJndiName();
            if (!hashMap.keySet().contains(object3)) continue;
            ((Datasources)((Object)object)).removeLocalTxDatasource(localTxDatasourceArray[i]);
        }
        for (Object object3 : hashMap.values()) {
            LocalTxDatasource localTxDatasource = new LocalTxDatasource();
            localTxDatasource.setJndiName(JBossDatasource.getRawName(((JBossDatasource)object3).getJndiName()));
            localTxDatasource.setConnectionUrl(((JBossDatasource)object3).getUrl());
            localTxDatasource.setDriverClass(((JBossDatasource)object3).getDriverClassName());
            localTxDatasource.setUserName(((JBossDatasource)object3).getUsername());
            localTxDatasource.setPassword(((JBossDatasource)object3).getPassword());
            localTxDatasource.setMinPoolSize(((JBossDatasource)object3).getMinPoolSize());
            localTxDatasource.setMaxPoolSize(((JBossDatasource)object3).getMaxPoolSize());
            localTxDatasource.setIdleTimeoutMinutes(((JBossDatasource)object3).getIdleTimeoutMinutes());
            ((Datasources)((Object)object)).addLocalTxDatasource(localTxDatasource);
        }
        if (hashMap.size() > 0) {
            if (object22 == null) {
                try {
                    fileObject = this.serverDir.createData(JBossDSdotXML);
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDSdotXml"));
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                    return;
                }
                object22 = FileUtil.toFile((FileObject)fileObject);
            }
            this.writeFile((File)object22, (BaseBean)object);
        }
    }

    private Map<String, Datasource> transform(Set<Datasource> set) {
        HashMap<String, Datasource> hashMap = new HashMap<String, Datasource>();
        for (JBossDatasource jBossDatasource : set) {
            if (jBossDatasource.getJndiName() == null) continue;
            hashMap.put(jBossDatasource.getJndiName(), jBossDatasource);
        }
        return hashMap;
    }

    private void writeFile(final File file, final BaseBean baseBean) throws ConfigurationException {
        try {
            FileSystem fileSystem = this.serverDir.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        String string = file.getName();
                        FileObject fileObject = JBossDatasourceManager.this.serverDir.getFileObject(string);
                        if (fileObject == null) {
                            fileObject = JBossDatasourceManager.this.serverDir.createData(string);
                        }
                        fileLock = fileObject.lock();
                        outputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock), 4096);
                        if (baseBean != null) {
                            baseBean.write(outputStream);
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getLocalizedMessage());
        }
    }
}

