/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.netbeans.modules.java.editor.semantic.LexerBasedHighlightLayer;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.editor.semantic.TokenList;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends JavaParserResultTask {
    private FileObject file;
    private AtomicBoolean cancel = new AtomicBoolean();
    static ErrorDescriptionSetter ERROR_DESCRIPTION_SETTER = new ErrorDescriptionSetter(){

        @Override
        public void setErrors(Document document, List<ErrorDescription> list, List<TreePathHandle> list2) {
            HintsController.setErrors((Document)document, (String)"semantic-highlighter", list);
        }

        @Override
        public void setHighlights(final Document document, final OffsetsBag offsetsBag) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SemanticHighlighter.getImportHighlightsBag(document).setHighlights(offsetsBag);
                }
            });
        }

        @Override
        public void setColorings(final Document document, final Map<Token, ColoringAttributes.Coloring> map, final Set<Token> set, final Set<Token> set2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LexerBasedHighlightLayer.getLayer(SemanticHighlighter.class, document).setColorings(map, set, set2);
                }
            });
        }
    };

    public static List<TreePathHandle> computeUnusedImports(CompilationInfo compilationInfo) throws IOException {
        SemanticHighlighter semanticHighlighter = new SemanticHighlighter(compilationInfo.getFileObject());
        final ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return arrayList;
        }
        semanticHighlighter.process(compilationInfo, document, new ErrorDescriptionSetter(){

            @Override
            public void setErrors(Document document, List<ErrorDescription> list, List<TreePathHandle> list2) {
                arrayList.addAll(list2);
            }

            @Override
            public void setHighlights(Document document, OffsetsBag offsetsBag) {
            }

            @Override
            public void setColorings(Document document, Map<Token, ColoringAttributes.Coloring> map, Set<Token> set, Set<Token> set2) {
            }
        });
        return arrayList;
    }

    SemanticHighlighter(FileObject fileObject) {
        super(JavaSource.Phase.RESOLVED);
        this.file = fileObject;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        CompilationInfo compilationInfo = CompilationInfo.get((Parser.Result)result);
        if (compilationInfo == null) {
            return;
        }
        this.cancel.set(false);
        final Document document = result.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        final boolean[] blArray = new boolean[1];
        document.render(new Runnable(){

            public void run() {
                blArray[0] = TokenHierarchy.get((Document)document).tokenSequence() == null;
            }
        });
        if (blArray[0]) {
            return;
        }
        if (this.process(compilationInfo, document)) {
            // empty if block
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    boolean process(CompilationInfo compilationInfo, Document document) {
        return this.process(compilationInfo, document, ERROR_DESCRIPTION_SETTER);
    }

    static ColoringAttributes.Coloring collection2Coloring(Collection<ColoringAttributes> collection) {
        ColoringAttributes.Coloring coloring = ColoringAttributes.empty();
        for (ColoringAttributes coloringAttributes : collection) {
            coloring = ColoringAttributes.add(coloring, coloringAttributes);
        }
        return coloring;
    }

    boolean process(CompilationInfo compilationInfo, Document document, ErrorDescriptionSetter errorDescriptionSetter) {
        Iterable<Token> iterable2;
        Object object;
        OffsetsBag offsetsBag;
        DetectorVisitor detectorVisitor = new DetectorVisitor(compilationInfo, document, this.cancel);
        long l = System.currentTimeMillis();
        IdentityHashMap<Token, ColoringAttributes.Coloring> identityHashMap = new IdentityHashMap<Token, ColoringAttributes.Coloring>();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        detectorVisitor.scan(compilationUnitTree, null);
        if (this.cancel.get()) {
            return true;
        }
        boolean bl = "text/x-java".equals(FileUtil.getMIMEType((FileObject)compilationInfo.getFileObject()));
        ArrayList<TreePathHandle> arrayList2 = bl ? new ArrayList<TreePathHandle>() : null;
        RemoveUnusedImportFix removeUnusedImportFix = bl ? RemoveUnusedImportFix.create(this.file, arrayList2) : null;
        OffsetsBag offsetsBag2 = offsetsBag = bl ? new OffsetsBag(document) : null;
        if (bl) {
            object = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.UNUSED);
            for (Iterable<Token> iterable2 : detectorVisitor.import2Highlight.values()) {
                if (this.cancel.get()) {
                    return true;
                }
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationUnitTree, ((TreePath)iterable2).getLeaf());
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationUnitTree, ((TreePath)iterable2).getLeaf());
                offsetsBag.addHighlight(n, n2, ColoringManager.getColoringImpl((ColoringAttributes.Coloring)object));
                int n3 = (int)compilationInfo.getCompilationUnit().getLineMap().getLineNumber(n);
                TreePathHandle treePathHandle = TreePathHandle.create(iterable2, (CompilationInfo)compilationInfo);
                Object object2 = RemoveUnusedImportFix.create(this.file, treePathHandle);
                arrayList2.add(treePathHandle);
                if (!RemoveUnusedImportFix.isEnabled()) continue;
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)RemoveUnusedImportFix.getSeverity(), (String)NbBundle.getMessage(SemanticHighlighter.class, (String)"LBL_UnusedImport"), (LazyFixList)new FixAllImportsFixList((Fix)object2, removeUnusedImportFix, arrayList2), (Document)document, (int)n3));
            }
        }
        object = LexerBasedHighlightLayer.getLayer(SemanticHighlighter.class, document).getColorings();
        HashSet hashSet = new HashSet(object.keySet());
        iterable2 = new HashSet();
        for (Element element : detectorVisitor.type2Uses.keySet()) {
            if (this.cancel.get()) {
                return true;
            }
            List list = (List)detectorVisitor.type2Uses.get(element);
            for (Object object2 : list) {
                if (((Use)object2).spec == null) continue;
                if (((Use)object2).type.contains((Object)UseTypes.DECLARATION) && Utilities.isPrivateElement(element)) {
                    if ((element.getKind().isField() && !SemanticHighlighter.isSerialVersionUID(compilationInfo, element) || SemanticHighlighter.isLocalVariableClosure(element)) && !this.hasAllTypes(list, EnumSet.of(UseTypes.READ, UseTypes.WRITE))) {
                        ((Use)object2).spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((element.getKind() == ElementKind.CONSTRUCTOR && !element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getKind() == ElementKind.METHOD) && !this.hasAllTypes(list, EnumSet.of(UseTypes.EXECUTE))) {
                        ((Use)object2).spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((element.getKind().isClass() || element.getKind().isInterface()) && !this.hasAllTypes(list, EnumSet.of(UseTypes.CLASS_USE))) {
                        ((Use)object2).spec.add(ColoringAttributes.UNUSED);
                    }
                }
                ColoringAttributes.Coloring coloring = SemanticHighlighter.collection2Coloring(((Use)object2).spec);
                Token token = (Token)detectorVisitor.tree2Token.get(((Use)object2).tree.getLeaf());
                if (token == null) continue;
                identityHashMap.put(token, coloring);
                if (hashSet.remove(token)) continue;
                iterable2.add((Token)token);
            }
        }
        if (this.cancel.get()) {
            return true;
        }
        if (bl) {
            errorDescriptionSetter.setErrors(document, arrayList, arrayList2);
            errorDescriptionSetter.setHighlights(document, offsetsBag);
        }
        errorDescriptionSetter.setColorings(document, (Map<Token, ColoringAttributes.Coloring>)identityHashMap, (Set<Token>)iterable2, hashSet);
        Logger.getLogger("TIMER").log(Level.FINE, "Semantic", new Object[]{NbEditorUtilities.getFileObject((Document)document), System.currentTimeMillis() - l});
        return false;
    }

    private boolean hasAllTypes(List<Use> list, Collection<UseTypes> collection) {
        EnumSet<UseTypes> enumSet = EnumSet.copyOf(collection);
        for (Use use : list) {
            if (collection.isEmpty()) {
                return true;
            }
            collection.removeAll(use.type);
        }
        return collection.isEmpty();
    }

    private static boolean isLocalVariableClosure(Element element) {
        return element.getKind() == ElementKind.PARAMETER || element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    private static boolean isSerialVersionUID(CompilationInfo compilationInfo, Element element) {
        return element.getKind().isField() && element.getModifiers().contains((Object)Modifier.FINAL) && element.getModifiers().contains((Object)Modifier.STATIC) && compilationInfo.getTypes().getPrimitiveType(TypeKind.LONG).equals(element.asType()) && element.getSimpleName().toString().equals("serialVersionUID");
    }

    static OffsetsBag getImportHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(FixAllImportsFixList.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(FixAllImportsFixList.class, offsetsBag);
            Object object = document.getProperty("stream");
            if (object instanceof DataObject) {
                // empty if block
            }
        }
        return offsetsBag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorDescriptionSetter {
        public void setErrors(Document var1, List<ErrorDescription> var2, List<TreePathHandle> var3);

        public void setHighlights(Document var1, OffsetsBag var2);

        public void setColorings(Document var1, Map<Token, ColoringAttributes.Coloring> var2, Set<Token> var3, Set<Token> var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, EnumSet<UseTypes>> {
        private CompilationInfo info;
        private Document doc;
        private Map<Element, List<Use>> type2Uses;
        private final Map<Element, ImportTree> element2Import = new HashMap<Element, ImportTree>();
        private final Map<String, ImportTree> method2Import = new HashMap<String, ImportTree>();
        private final Map<String, Collection<ImportTree>> simpleName2UnresolvableImports = new HashMap<String, Collection<ImportTree>>();
        private final Set<ImportTree> unresolvablePackageImports = new HashSet<ImportTree>();
        private final Map<ImportTree, TreePath> import2Highlight = new HashMap<ImportTree, TreePath>();
        private Map<Tree, Token> tree2Token;
        private TokenList tl;
        private long memberSelectBypass = -1L;
        private SourcePositions sourcePositions;
        private ExecutableElement recursionDetector;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});

        private DetectorVisitor(CompilationInfo compilationInfo, Document document, AtomicBoolean atomicBoolean) {
            super(atomicBoolean);
            this.info = compilationInfo;
            this.doc = document;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.tree2Token = new IdentityHashMap<Tree, Token>();
            this.tl = new TokenList(compilationInfo, document, atomicBoolean);
            this.sourcePositions = compilationInfo.getTrees().getSourcePositions();
        }

        private void firstIdentifier(String string) {
            this.tl.firstIdentifier(this.getCurrentPath(), string, this.tree2Token);
        }

        public Void visitAssignment(AssignmentTree assignmentTree, EnumSet<UseTypes> enumSet) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), assignmentTree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expressionTree = assignmentTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                TreePath treePath = new TreePath(this.getCurrentPath(), expressionTree);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            this.scan(assignmentTree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(assignmentTree.getExpression(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, EnumSet<UseTypes> enumSet) {
            EnumSet<UseTypes> enumSet2 = EnumSet.of(UseTypes.WRITE);
            if (enumSet != null) {
                enumSet2.addAll(enumSet);
            }
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), compoundAssignmentTree.getVariable()), enumSet2);
            ExpressionTree expressionTree = compoundAssignmentTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                TreePath treePath = new TreePath(this.getCurrentPath(), expressionTree);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            this.scan(compoundAssignmentTree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(compoundAssignmentTree.getExpression(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitReturn(ReturnTree returnTree, EnumSet<UseTypes> enumSet) {
            if (returnTree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), returnTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitReturn(returnTree, EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree memberSelectTree, EnumSet<UseTypes> enumSet) {
            Object object;
            long l = this.memberSelectBypass;
            this.memberSelectBypass = -1L;
            ExpressionTree expressionTree = memberSelectTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                object = new TreePath(this.getCurrentPath(), expressionTree);
                this.handlePossibleIdentifier((TreePath)object, EnumSet.of(UseTypes.READ));
            }
            if ((object = this.info.getTrees().getElement(this.getCurrentPath())) != null && object.getKind().isField()) {
                this.handlePossibleIdentifier(this.getCurrentPath(), enumSet == null ? EnumSet.of(UseTypes.READ) : enumSet);
            }
            if (object != null && (object.getKind().isClass() || object.getKind().isInterface()) && this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitMemberSelect(memberSelectTree, null);
            this.tl.moveToEnd(memberSelectTree.getExpression());
            if (l != -1L) {
                this.tl.moveToOffset(l);
            }
            this.firstIdentifier(memberSelectTree.getIdentifier().toString());
            return null;
        }

        private void addModifiers(Element element, Collection<ColoringAttributes> collection) {
            if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                collection.add(ColoringAttributes.STATIC);
            }
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT) && !element.getKind().isInterface()) {
                collection.add(ColoringAttributes.ABSTRACT);
            }
            boolean bl = false;
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                collection.add(ColoringAttributes.PUBLIC);
                bl = true;
            }
            if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
                collection.add(ColoringAttributes.PROTECTED);
                bl = true;
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                collection.add(ColoringAttributes.PRIVATE);
                bl = true;
            }
            if (!bl && !SemanticHighlighter.isLocalVariableClosure(element)) {
                collection.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(element)) {
                collection.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement executableElement, boolean bl) {
            ArrayList<ColoringAttributes> arrayList = new ArrayList<ColoringAttributes>();
            this.addModifiers(executableElement, arrayList);
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
                arrayList.add(ColoringAttributes.CONSTRUCTOR);
                if (bl && executableElement.getEnclosingElement() != null && this.info.getElements().isDeprecated(executableElement.getEnclosingElement())) {
                    arrayList.add(ColoringAttributes.DEPRECATED);
                }
            } else {
                arrayList.add(ColoringAttributes.METHOD);
            }
            return arrayList;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element element) {
            ArrayList<ColoringAttributes> arrayList = new ArrayList<ColoringAttributes>();
            this.addModifiers(element, arrayList);
            if (element.getKind().isField()) {
                arrayList.add(ColoringAttributes.FIELD);
                return arrayList;
            }
            if (element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                arrayList.add(ColoringAttributes.LOCAL_VARIABLE);
                return arrayList;
            }
            if (element.getKind() == ElementKind.PARAMETER) {
                arrayList.add(ColoringAttributes.PARAMETER);
                return arrayList;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath treePath, Collection<UseTypes> collection) {
            this.handlePossibleIdentifier(treePath, collection, null, false, false);
        }

        private void handlePossibleIdentifier(TreePath treePath, Collection<UseTypes> collection, Element element, boolean bl, boolean bl2) {
            if (Utilities.isKeyword(treePath.getLeaf())) {
                return;
            }
            if (treePath.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)treePath.getLeaf().getKind())) {
                return;
            }
            element = !bl ? this.info.getTrees().getElement(treePath) : element;
            Collection<ColoringAttributes> collection2 = null;
            if (element != null && (element.getKind().isField() || SemanticHighlighter.isLocalVariableClosure(element))) {
                collection2 = this.getVariableColoring(element);
            }
            if (element != null && element instanceof ExecutableElement) {
                collection2 = this.getMethodColoring((ExecutableElement)element, bl2);
            }
            if (element != null && (element.getKind().isClass() || element.getKind().isInterface())) {
                if (collection.contains((Object)UseTypes.READ)) {
                    collection.remove((Object)UseTypes.READ);
                    collection.add(UseTypes.CLASS_USE);
                }
                collection2 = new ArrayList<ColoringAttributes>();
                this.addModifiers(element, collection2);
                switch (element.getKind()) {
                    case CLASS: {
                        collection2.add(ColoringAttributes.CLASS);
                        break;
                    }
                    case INTERFACE: {
                        collection2.add(ColoringAttributes.INTERFACE);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        collection2.add(ColoringAttributes.ANNOTATION_TYPE);
                        break;
                    }
                    case ENUM: {
                        collection2.add(ColoringAttributes.ENUM);
                    }
                }
            }
            if (element != null && collection.contains((Object)UseTypes.DECLARATION)) {
                if (collection2 == null) {
                    collection2 = new ArrayList<ColoringAttributes>();
                }
                collection2.add(ColoringAttributes.DECLARATION);
            }
            if (collection2 != null) {
                this.addUse(element, collection, treePath, collection2);
            }
            this.typeUsed(element, treePath, collection);
        }

        private void handleJavadoc(Element element) {
            if (element == null) {
                return;
            }
            for (TypeElement typeElement : JavadocImports.computeReferencedElements(this.info, element)) {
                this.typeUsed(typeElement, null, EnumSet.of(UseTypes.CLASS_USE));
            }
        }

        private void addUse(Element element, Collection<UseTypes> collection, TreePath treePath, Collection<ColoringAttributes> collection2) {
            List<Use> list;
            if (element == this.recursionDetector) {
                collection.remove((Object)UseTypes.EXECUTE);
            }
            if ((list = this.type2Uses.get(element)) == null) {
                list = new ArrayList<Use>();
                this.type2Uses.put(element, list);
            }
            Use use = new Use(collection, treePath, collection2);
            list.add(use);
        }

        public Void visitTypeCast(TypeCastTree typeCastTree, EnumSet<UseTypes> enumSet) {
            Tree tree;
            ExpressionTree expressionTree = typeCastTree.getExpression();
            if (expressionTree.getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            if ((tree = typeCastTree.getType()).getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree), EnumSet.of(UseTypes.READ));
            }
            super.visitTypeCast(typeCastTree, enumSet);
            return null;
        }

        public Void visitInstanceOf(InstanceOfTree instanceOfTree, EnumSet<UseTypes> enumSet) {
            ExpressionTree expressionTree = instanceOfTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            TreePath treePath = new TreePath(this.getCurrentPath(), instanceOfTree.getType());
            this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            super.visitInstanceOf(instanceOfTree, null);
            return null;
        }

        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, EnumSet<UseTypes> enumSet) {
            this.tl.moveBefore(compilationUnitTree.getImports());
            this.scan(compilationUnitTree.getImports(), enumSet);
            this.tl.moveBefore(compilationUnitTree.getPackageAnnotations());
            this.scan(compilationUnitTree.getPackageAnnotations(), enumSet);
            this.tl.moveToEnd(compilationUnitTree.getImports());
            this.scan(compilationUnitTree.getTypeDecls(), enumSet);
            return null;
        }

        private long startOf(List<? extends Tree> list) {
            if (list.isEmpty()) {
                return -1L;
            }
            return this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), list.get(0));
        }

        private void handleMethodTypeArguments(TreePath treePath, List<? extends Tree> list) {
            this.tl.moveBefore(list);
            for (Tree tree : list) {
                if (!(tree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(treePath, tree), EnumSet.of(UseTypes.CLASS_USE));
            }
        }

        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, EnumSet<UseTypes> enumSet) {
            Object object;
            ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
            boolean bl = false;
            if (expressionTree.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(object = ((IdentifierTree)expressionTree).getName().toString()) || "this".equals(object))) {
                Element element = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(element, EnumSet.of(UseTypes.EXECUTE), null, null);
                bl = true;
            }
            if (!bl) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.EXECUTE));
            }
            long l = (object = methodInvocationTree.getTypeArguments()).isEmpty() ? -1L : this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), (Tree)object.get(object.size() - 1));
            switch (methodInvocationTree.getMethodSelect().getKind()) {
                case IDENTIFIER: 
                case MEMBER_SELECT: {
                    this.memberSelectBypass = l;
                    this.scan(methodInvocationTree.getMethodSelect(), null);
                    this.memberSelectBypass = -1L;
                    break;
                }
                default: {
                    this.scan(methodInvocationTree.getMethodSelect(), null);
                }
            }
            this.handleMethodTypeArguments(this.getCurrentPath(), (List<? extends Tree>)object);
            this.scan(methodInvocationTree.getTypeArguments(), null);
            for (ExpressionTree expressionTree2 : methodInvocationTree.getArguments()) {
                if (!(expressionTree2 instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree2), EnumSet.of(UseTypes.READ));
            }
            this.scan(methodInvocationTree.getArguments(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitIdentifier(IdentifierTree identifierTree, EnumSet<UseTypes> enumSet) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), identifierTree));
            if (this.memberSelectBypass != -1L) {
                this.tl.moveToOffset(this.memberSelectBypass);
                this.memberSelectBypass = -1L;
            }
            this.tl.identifierHere(identifierTree, this.tree2Token);
            if (enumSet != null) {
                this.handlePossibleIdentifier(this.getCurrentPath(), enumSet);
            }
            super.visitIdentifier(identifierTree, null);
            return null;
        }

        public Void visitMethod(MethodTree methodTree, EnumSet<UseTypes> enumSet) {
            Object object;
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), methodTree));
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.DECLARATION));
            for (ExpressionTree object22 : methodTree.getThrows()) {
                object = new TreePath(this.getCurrentPath(), object22);
                this.handlePossibleIdentifier((TreePath)object, EnumSet.of(UseTypes.CLASS_USE));
            }
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            this.handleJavadoc(element);
            EnumSet<UseTypes> enumSet2 = element != null && (element.getModifiers().contains((Object)Modifier.ABSTRACT) || element.getModifiers().contains((Object)Modifier.NATIVE) || !element.getModifiers().contains((Object)Modifier.PRIVATE)) ? EnumSet.of(UseTypes.WRITE, UseTypes.READ) : EnumSet.of(UseTypes.WRITE);
            this.scan(methodTree.getModifiers(), null);
            this.tl.moveToEnd(methodTree.getModifiers());
            this.scan(methodTree.getTypeParameters(), null);
            this.tl.moveToEnd(methodTree.getTypeParameters());
            this.scan(methodTree.getReturnType(), EnumSet.of(UseTypes.CLASS_USE));
            this.tl.moveToEnd(methodTree.getReturnType());
            if (methodTree.getReturnType() != null) {
                object = methodTree.getName().toString();
            } else {
                TreePath treePath;
                for (treePath = this.getCurrentPath(); treePath != null && treePath.getLeaf().getKind() != Tree.Kind.CLASS; treePath = treePath.getParentPath()) {
                }
                object = treePath != null && treePath.getLeaf().getKind() == Tree.Kind.CLASS ? ((ClassTree)treePath.getLeaf()).getSimpleName().toString() : null;
            }
            if (object != null) {
                this.firstIdentifier((String)object);
            }
            this.scan(methodTree.getParameters(), enumSet2);
            this.scan(methodTree.getThrows(), null);
            this.scan(methodTree.getDefaultValue(), null);
            this.recursionDetector = element != null && element.getKind() == ElementKind.METHOD ? (ExecutableElement)element : null;
            this.scan(methodTree.getBody(), null);
            this.recursionDetector = null;
            return null;
        }

        public Void visitExpressionStatement(ExpressionStatementTree expressionStatementTree, EnumSet<UseTypes> enumSet) {
            super.visitExpressionStatement(expressionStatementTree, null);
            return null;
        }

        public Void visitParenthesized(ParenthesizedTree parenthesizedTree, EnumSet<UseTypes> enumSet) {
            ExpressionTree expressionTree = parenthesizedTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            super.visitParenthesized(parenthesizedTree, enumSet);
            return null;
        }

        public Void visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, EnumSet<UseTypes> enumSet) {
            this.scan(enhancedForLoopTree.getVariable(), EnumSet.of(UseTypes.WRITE));
            if (enhancedForLoopTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), enhancedForLoopTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            this.scan(enhancedForLoopTree.getExpression(), null);
            this.scan(enhancedForLoopTree.getStatement(), null);
            return null;
        }

        private boolean isStar(ImportTree importTree) {
            Tree tree = importTree.getQualifiedIdentifier();
            if (tree == null || tree.getKind() == Tree.Kind.IDENTIFIER) {
                return false;
            }
            return ((MemberSelectTree)tree).getIdentifier().contentEquals("*");
        }

        private boolean parseErrorInImport(ImportTree importTree) {
            if (this.isStar(importTree)) {
                return false;
            }
            final StringBuilder stringBuilder = new StringBuilder();
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void void_) {
                    super.visitMemberSelect(memberSelectTree, void_);
                    stringBuilder.append('.');
                    stringBuilder.append(memberSelectTree.getIdentifier());
                    return null;
                }

                @Override
                public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
                    stringBuilder.append(identifierTree.getName());
                    return null;
                }
            }.scan(importTree.getQualifiedIdentifier(), null);
            return !SourceVersion.isName(stringBuilder);
        }

        public Void visitImport(ImportTree importTree, EnumSet<UseTypes> enumSet) {
            if (this.parseErrorInImport(importTree)) {
                return (Void)super.visitImport(importTree, null);
            }
            if (!importTree.isStatic()) {
                if (this.isStar(importTree)) {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
                    Element element = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), memberSelectTree), memberSelectTree.getExpression()));
                    if (element != null && element.getKind() == ElementKind.PACKAGE) {
                        if (!ElementFilter.typesIn(element.getEnclosedElements()).isEmpty()) {
                            for (TypeElement typeElement : ElementFilter.typesIn(element.getEnclosedElements())) {
                                this.element2Import.put(typeElement, importTree);
                            }
                            this.import2Highlight.put(importTree, this.getCurrentPath());
                        } else {
                            this.unresolvablePackageImports.add(importTree);
                            this.import2Highlight.put(importTree, this.getCurrentPath());
                        }
                    }
                } else {
                    Element element = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), importTree.getQualifiedIdentifier()));
                    if (element != null) {
                        if (element.asType().getKind() != TypeKind.ERROR) {
                            this.element2Import.put(element, importTree);
                            this.import2Highlight.put(importTree, this.getCurrentPath());
                        } else if (importTree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
                            this.addUnresolvableImport(((MemberSelectTree)importTree.getQualifiedIdentifier()).getIdentifier(), importTree);
                            this.import2Highlight.put(importTree, this.getCurrentPath());
                        }
                    }
                }
            } else if (importTree.getQualifiedIdentifier() != null && importTree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
                Element element = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), memberSelectTree), memberSelectTree.getExpression()));
                if (element != null && (element.getKind().isClass() || element.getKind().isInterface())) {
                    if (element.asType().getKind() != TypeKind.ERROR) {
                        Name name = this.isStar(importTree) ? null : memberSelectTree.getIdentifier();
                        boolean bl = false;
                        for (Element element2 : this.info.getElements().getAllMembers((TypeElement)element)) {
                            if (name != null && !((Object)element2.getSimpleName()).equals(name)) continue;
                            if (element2.getKind() == ElementKind.METHOD) {
                                this.method2Import.put(element2.getSimpleName().toString() + ((Object)element2.asType()).toString(), importTree);
                                bl = true;
                                continue;
                            }
                            if (element2.getKind().isField()) {
                                this.element2Import.put(element2, importTree);
                                bl = true;
                                continue;
                            }
                            if (!element2.getKind().isClass() && !element2.getKind().isInterface()) continue;
                            this.element2Import.put(element2, importTree);
                            bl = true;
                        }
                        if (!bl) {
                            this.addUnresolvableImport(memberSelectTree.getIdentifier(), importTree);
                        }
                        this.import2Highlight.put(importTree, this.getCurrentPath());
                    } else {
                        if (!this.isStar(importTree)) {
                            this.addUnresolvableImport(memberSelectTree.getIdentifier(), importTree);
                        } else {
                            this.unresolvablePackageImports.add(importTree);
                        }
                        this.import2Highlight.put(importTree, this.getCurrentPath());
                    }
                }
            }
            super.visitImport(importTree, null);
            return null;
        }

        private void addUnresolvableImport(Name name, ImportTree importTree) {
            String string = name.toString();
            Collection<ImportTree> collection = this.simpleName2UnresolvableImports.get(string);
            if (collection == null) {
                collection = new LinkedList<ImportTree>();
                this.simpleName2UnresolvableImports.put(string, collection);
            }
            collection.add(importTree);
        }

        public Void visitVariable(VariableTree variableTree, EnumSet<UseTypes> enumSet) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), variableTree));
            TreePath treePath = new TreePath(this.getCurrentPath(), variableTree.getType());
            if (treePath.getLeaf() instanceof ArrayTypeTree) {
                treePath = new TreePath(treePath, ((ArrayTypeTree)treePath.getLeaf()).getType());
            }
            if (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            EnumSet<UseTypes> enumSet2 = null;
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (variableTree.getInitializer() != null) {
                enumSet2 = EnumSet.of(UseTypes.DECLARATION, UseTypes.WRITE);
                if (variableTree.getInitializer().getKind() == Tree.Kind.IDENTIFIER) {
                    this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), variableTree.getInitializer()), EnumSet.of(UseTypes.READ));
                }
            } else {
                enumSet2 = element != null && element.getKind() == ElementKind.FIELD ? EnumSet.of(UseTypes.DECLARATION, UseTypes.WRITE) : EnumSet.of(UseTypes.DECLARATION);
            }
            if (element != null && element.getKind().isField()) {
                this.handleJavadoc(element);
            }
            if (enumSet != null) {
                HashSet<UseTypes> hashSet = new HashSet<UseTypes>();
                hashSet.addAll(enumSet2);
                hashSet.addAll(enumSet);
                enumSet2 = EnumSet.copyOf(hashSet);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), enumSet2);
            this.scan(variableTree.getModifiers(), null);
            this.tl.moveToEnd(variableTree.getModifiers());
            this.scan(variableTree.getType(), null);
            this.tl.moveToEnd(variableTree.getType());
            this.firstIdentifier(variableTree.getName().toString());
            this.tl.moveNext();
            this.scan(variableTree.getInitializer(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitAnnotation(AnnotationTree annotationTree, EnumSet<UseTypes> enumSet) {
            TreePath treePath = new TreePath(this.getCurrentPath(), annotationTree.getAnnotationType());
            this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            super.visitAnnotation(annotationTree, EnumSet.noneOf(UseTypes.class));
            return null;
        }

        public Void visitNewClass(NewClassTree newClassTree, EnumSet<UseTypes> enumSet) {
            ExpressionTree expressionTree = newClassTree.getIdentifier();
            TreePath treePath = expressionTree.getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), expressionTree), ((ParameterizedTypeTree)((Object)expressionTree)).getType()) : new TreePath(this.getCurrentPath(), expressionTree);
            this.typeUsed(this.info.getTrees().getElement(treePath), treePath, EnumSet.of(UseTypes.CLASS_USE));
            this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.EXECUTE), this.info.getTrees().getElement(this.getCurrentPath()), true, true);
            Element element = this.info.getTrees().getElement(treePath);
            if (element != null) {
                this.addUse(element, EnumSet.of(UseTypes.CLASS_USE), null, null);
            }
            for (ExpressionTree expressionTree2 : newClassTree.getArguments()) {
                if (!(expressionTree2 instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree2), EnumSet.of(UseTypes.READ));
            }
            super.visitNewClass(newClassTree, null);
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, EnumSet<UseTypes> enumSet) {
            Object object;
            boolean bl = false;
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                object = (NewClassTree)this.getCurrentPath().getParentPath().getLeaf();
                boolean bl2 = bl = object.getTypeArguments().contains(parameterizedTypeTree) || object.getIdentifier() == parameterizedTypeTree;
            }
            if (this.getCurrentPath().getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                object = (NewClassTree)this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                Tree tree = this.getCurrentPath().getParentPath().getLeaf();
                boolean bl3 = bl = object.getTypeArguments().contains(tree) || object.getIdentifier() == tree;
            }
            if (!bl) {
                object = new TreePath(this.getCurrentPath(), parameterizedTypeTree.getType());
                this.handlePossibleIdentifier((TreePath)object, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree : parameterizedTypeTree.getTypeArguments()) {
                TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitParameterizedType(parameterizedTypeTree, null);
            return null;
        }

        public Void visitBinary(BinaryTree binaryTree, EnumSet<UseTypes> enumSet) {
            TreePath treePath;
            ExpressionTree expressionTree = binaryTree.getLeftOperand();
            ExpressionTree expressionTree2 = binaryTree.getRightOperand();
            if (expressionTree instanceof IdentifierTree) {
                treePath = new TreePath(this.getCurrentPath(), expressionTree);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            if (expressionTree2 instanceof IdentifierTree) {
                treePath = new TreePath(this.getCurrentPath(), expressionTree2);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            super.visitBinary(binaryTree, EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitClass(ClassTree classTree, EnumSet<UseTypes> enumSet) {
            Object object;
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), classTree));
            for (TypeParameterTree object22 : classTree.getTypeParameters()) {
                for (Tree tree : object22.getBounds()) {
                    TreePath treePath = new TreePath(new TreePath(this.getCurrentPath(), object22), tree);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                object = classTree.getExtendsClause();
                if (object != null) {
                    TreePath treePath = new TreePath(this.getCurrentPath(), (Tree)object);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
                for (Tree tree : classTree.getImplementsClause()) {
                    TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.DECLARATION));
            object = this.info.getTrees().getElement(this.getCurrentPath());
            this.handleJavadoc((Element)object);
            this.scan(classTree.getModifiers(), null);
            this.tl.moveToEnd(classTree.getModifiers());
            this.firstIdentifier(classTree.getSimpleName().toString());
            this.scan(classTree.getTypeParameters(), null);
            this.scan(classTree.getExtendsClause(), null);
            this.scan(classTree.getImplementsClause(), null);
            ExecutableElement executableElement = this.recursionDetector;
            this.recursionDetector = null;
            this.scan(classTree.getMembers(), null);
            this.recursionDetector = executableElement;
            return null;
        }

        public Void visitUnary(UnaryTree unaryTree, EnumSet<UseTypes> enumSet) {
            if (unaryTree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), unaryTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitUnary(unaryTree, enumSet);
            return null;
        }

        public Void visitArrayAccess(ArrayAccessTree arrayAccessTree, EnumSet<UseTypes> enumSet) {
            if (arrayAccessTree.getExpression() != null && arrayAccessTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), arrayAccessTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            if (arrayAccessTree.getIndex() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), arrayAccessTree.getIndex()), EnumSet.of(UseTypes.READ));
            }
            super.visitArrayAccess(arrayAccessTree, null);
            return null;
        }

        public Void visitArrayType(ArrayTypeTree arrayTypeTree, EnumSet<UseTypes> enumSet) {
            if (arrayTypeTree.getType() != null) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), arrayTypeTree.getType()), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitArrayType(arrayTypeTree, enumSet);
        }

        public Void visitNewArray(NewArrayTree newArrayTree, EnumSet<UseTypes> enumSet) {
            if (newArrayTree.getType() != null) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), newArrayTree.getType()), EnumSet.of(UseTypes.CLASS_USE));
            }
            this.scan(newArrayTree.getType(), null);
            this.scan(newArrayTree.getDimensions(), EnumSet.of(UseTypes.READ));
            this.scan(newArrayTree.getInitializers(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCatch(CatchTree catchTree, EnumSet<UseTypes> enumSet) {
            this.scan(catchTree.getParameter(), EnumSet.of(UseTypes.WRITE));
            this.scan(catchTree.getBlock(), null);
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, EnumSet<UseTypes> enumSet) {
            return (Void)super.visitConditionalExpression(conditionalExpressionTree, EnumSet.of(UseTypes.READ));
        }

        public Void visitAssert(AssertTree assertTree, EnumSet<UseTypes> enumSet) {
            if (assertTree.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), assertTree.getCondition()), EnumSet.of(UseTypes.READ));
            }
            if (assertTree.getDetail() != null && assertTree.getDetail().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), assertTree.getDetail()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitAssert(assertTree, EnumSet.of(UseTypes.READ));
        }

        public Void visitCase(CaseTree caseTree, EnumSet<UseTypes> enumSet) {
            if (caseTree.getExpression() != null && caseTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), caseTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitCase(caseTree, null);
        }

        public Void visitThrow(ThrowTree throwTree, EnumSet<UseTypes> enumSet) {
            if (throwTree.getExpression() != null && throwTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), throwTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitThrow(throwTree, enumSet);
        }

        public Void visitTypeParameter(TypeParameterTree typeParameterTree, EnumSet<UseTypes> enumSet) {
            for (Tree tree : typeParameterTree.getBounds()) {
                if (tree.getKind() != Tree.Kind.IDENTIFIER) continue;
                TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitTypeParameter(typeParameterTree, enumSet);
        }

        public Void visitForLoop(ForLoopTree forLoopTree, EnumSet<UseTypes> enumSet) {
            if (forLoopTree.getCondition() != null && forLoopTree.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), forLoopTree.getCondition()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitForLoop(forLoopTree, enumSet);
        }

        public Void visitWildcard(WildcardTree wildcardTree, EnumSet<UseTypes> enumSet) {
            if (wildcardTree.getBound() != null && wildcardTree.getBound().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), wildcardTree.getBound()), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitWildcard(wildcardTree, enumSet);
        }

        private void typeUsed(Element element, TreePath treePath, Collection<UseTypes> collection) {
            if (element != null && (treePath == null || treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER || treePath.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE)) {
                if (element.asType() != null && element.asType().getKind() != TypeKind.ERROR) {
                    ImportTree importTree;
                    ImportTree importTree2 = importTree = element.getKind() != ElementKind.METHOD ? this.element2Import.remove(element) : this.method2Import.remove(element.getSimpleName().toString() + ((Object)element.asType()).toString());
                    if (importTree != null) {
                        if (this.isStar(importTree)) {
                            this.handleUnresolvableImports(element, collection, false);
                        }
                        this.import2Highlight.remove(importTree);
                    }
                } else {
                    this.handleUnresolvableImports(element, collection, true);
                }
            }
        }

        private void handleUnresolvableImports(Element element, Collection<UseTypes> collection, boolean bl) {
            block2: {
                block3: {
                    Name name = element.getSimpleName();
                    if (name == null) break block2;
                    Collection<ImportTree> collection2 = this.simpleName2UnresolvableImports.get(name.toString());
                    if (collection2 == null) break block3;
                    for (ImportTree importTree : collection2) {
                        if (!collection.contains((Object)UseTypes.CLASS_USE) && !importTree.isStatic()) continue;
                        this.import2Highlight.remove(importTree);
                    }
                    break block2;
                }
                if (!bl) break block2;
                for (ImportTree importTree : this.unresolvablePackageImports) {
                    if (!collection.contains((Object)UseTypes.CLASS_USE) && !importTree.isStatic()) continue;
                    this.import2Highlight.remove(importTree);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Use {
        private Collection<UseTypes> type;
        private TreePath tree;
        private Collection<ColoringAttributes> spec;

        public Use(Collection<UseTypes> collection, TreePath treePath, Collection<ColoringAttributes> collection2) {
            this.type = collection;
            this.tree = treePath;
            this.spec = collection2;
        }

        public String toString() {
            return "Use: " + this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UseTypes {
        READ,
        WRITE,
        EXECUTE,
        DECLARATION,
        CLASS_USE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixAllImportsFixList
    implements LazyFixList {
        private Fix removeImport;
        private Fix removeAllUnusedImports;
        private List<TreePathHandle> allUnusedImports;
        private List<Fix> fixes;

        public FixAllImportsFixList(Fix fix, Fix fix2, List<TreePathHandle> list) {
            this.removeImport = fix;
            this.removeAllUnusedImports = fix2;
            this.allUnusedImports = list;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public synchronized List<Fix> getFixes() {
            if (this.fixes != null) {
                return this.fixes;
            }
            this.fixes = this.allUnusedImports.size() > 1 ? Arrays.asList(this.removeImport, this.removeAllUnusedImports) : Collections.singletonList(this.removeImport);
            return this.fixes;
        }

        public boolean isComputed() {
            return true;
        }
    }
}

