/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Address {
    private static final Pattern pattern = Pattern.compile("\\s*([0-9]+)\\s*:0x([0-9a-f]+)\\s*");
    final int segmentNumber;
    final long address;

    public Address(int n, long l) {
        this.segmentNumber = n;
        this.address = l;
    }

    public static Address parse(String string) {
        Address address = null;
        Matcher matcher = pattern.matcher(string.toLowerCase());
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            long l = Long.parseLong(matcher.group(2), 16);
            address = new Address(n, l);
        }
        return address;
    }

    public boolean equals(Object object) {
        if (object instanceof Address) {
            Address address = (Address)object;
            return this.address == address.address && this.segmentNumber == address.segmentNumber;
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 59 * n + this.segmentNumber;
        n = 59 * n + (int)(this.address ^ this.address >>> 32);
        return n;
    }

    public long getAddress() {
        return this.address;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public String toString() {
        return String.format("%d:0x%x", this.segmentNumber, this.address);
    }
}

