/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipArchive
implements JavacFileManager.Archive {
    protected JavacFileManager fileManager;
    protected final Map<RelativePath.RelativeDirectory, List<String>> map;
    protected final ZipFile zdir;

    public ZipArchive(JavacFileManager fm, ZipFile zdir) throws IOException {
        this(fm, zdir, true);
    }

    protected ZipArchive(JavacFileManager fm, ZipFile zdir, boolean initMap) throws IOException {
        this.fileManager = fm;
        this.zdir = zdir;
        this.map = new HashMap<RelativePath.RelativeDirectory, List<String>>();
        if (initMap) {
            this.initMap();
        }
    }

    protected void initMap() throws IOException {
        Enumeration<? extends ZipEntry> e = this.zdir.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry;
            try {
                entry = e.nextElement();
            }
            catch (InternalError ex) {
                IOException io = new IOException();
                io.initCause(ex);
                throw io;
            }
            this.addZipEntry(entry);
        }
    }

    void addZipEntry(ZipEntry entry) {
        String name = entry.getName();
        int i = name.lastIndexOf(47);
        RelativePath.RelativeDirectory dirname = new RelativePath.RelativeDirectory(name.substring(0, i + 1));
        String basename = name.substring(i + 1);
        if (basename.length() == 0) {
            return;
        }
        List<String> list = this.map.get(dirname);
        if (list == null) {
            list = List.nil();
        }
        list = list.prepend(basename);
        this.map.put(dirname, list);
    }

    @Override
    public boolean contains(RelativePath name) {
        RelativePath.RelativeDirectory dirname = name.dirname();
        String basename = name.basename();
        if (basename.length() == 0) {
            return false;
        }
        List<String> list = this.map.get(dirname);
        return list != null && list.contains(basename);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory subdirectory) {
        return this.map.get(subdirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
        ZipEntry ze = new RelativePath.RelativeFile(subdirectory, file).getZipEntry(this.zdir);
        return new ZipFileObject(this, file, ze);
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.map.keySet();
    }

    @Override
    public void close() throws IOException {
        this.zdir.close();
    }

    public String toString() {
        return "ZipArchive[" + this.zdir.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipFileObject
    extends BaseFileObject {
        private String name;
        ZipArchive zarch;
        ZipEntry entry;

        protected ZipFileObject(ZipArchive zarch, String name, ZipEntry entry) {
            super(zarch.fileManager);
            this.zarch = zarch;
            this.name = name;
            this.entry = entry;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.zarch.zdir.getInputStream(this.entry);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNameCompatible(String cn, JavaFileObject.Kind k) {
            cn.getClass();
            if (k == JavaFileObject.Kind.OTHER && this.getKind() != k) {
                return false;
            }
            return this.name.equals(cn + k.extension);
        }

        @Override
        @Deprecated
        public String getPath() {
            return this.zarch.zdir.getName() + "(" + this.entry + ")";
        }

        @Override
        public long getLastModified() {
            return this.entry.getTime();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb = this.fileManager.getCachedContent(this);
            if (cb == null) {
                InputStream in = this.zarch.zdir.getInputStream(this.entry);
                try {
                    ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                    JavaFileObject prev = this.fileManager.log.useSource(this);
                    try {
                        cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.fileManager.log.useSource(prev);
                        throw throwable;
                    }
                    this.fileManager.log.useSource(prev);
                    this.fileManager.recycleByteBuffer(bb);
                    if (!ignoreEncodingErrors) {
                        this.fileManager.cache(this, cb);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                {
                }
            }
            return cb;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ZipFileObject)) {
                return false;
            }
            ZipFileObject o = (ZipFileObject)other;
            return this.zarch.zdir.equals(o.zarch.zdir) || this.name.equals(o.name);
        }

        public int hashCode() {
            return this.zarch.zdir.hashCode() + this.name.hashCode();
        }

        public String getZipName() {
            return this.zarch.zdir.getName();
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        @Override
        public URI toUri() {
            String zipName = new File(this.getZipName()).toURI().normalize().getPath();
            String entryName = this.getZipEntryName();
            return URI.create("jar:" + zipName + "!" + entryName);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> path) {
            String entryName = this.getZipEntryName();
            return ZipFileObject.removeExtension(entryName).replace('/', '.');
        }
    }
}

