/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegularFileObject
extends BaseFileObject {
    private boolean hasParents = false;
    private String name;
    final File f;

    public RegularFileObject(JavacFileManager fileManager, File f) {
        this(fileManager, f.getName(), f);
    }

    public RegularFileObject(JavacFileManager fileManager, String name, File f) {
        super(fileManager);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.name = name;
        this.f = f;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.f);
    }

    @Override
    protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
        return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.ensureParentDirectoriesExist();
        return new FileOutputStream(this.f);
    }

    @Override
    public Writer openWriter() throws IOException {
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), this.fileManager.getEncodingName());
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path) {
        String fPath = this.f.getPath();
        for (File file : path) {
            String dPath = file.getPath();
            if (dPath.length() == 0) {
                dPath = System.getProperty("user.dir");
            }
            if (!dPath.endsWith(File.separator)) {
                dPath = dPath + File.separator;
            }
            if (!fPath.regionMatches(true, 0, dPath, 0, dPath.length()) || !new File(fPath.substring(0, dPath.length())).equals(new File(dPath))) continue;
            String relativeName = fPath.substring(dPath.length());
            return RegularFileObject.removeExtension(relativeName).replace(File.separatorChar, '.');
        }
        return null;
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            File parent = this.f.getParentFile();
            if (!(parent == null || parent.exists() || parent.mkdirs() || parent.exists() && parent.isDirectory())) {
                throw new IOException("could not create parent directories");
            }
            this.hasParents = true;
        }
    }

    @Override
    @Deprecated
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNameCompatible(String cn, JavaFileObject.Kind kind) {
        cn.getClass();
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String n = cn + kind.extension;
        if (this.name.equals(n)) {
            return true;
        }
        if (this.name.equalsIgnoreCase(n)) {
            try {
                return this.f.getCanonicalFile().getName().equals(n);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public String getPath() {
        return this.f.getPath();
    }

    @Override
    public long getLastModified() {
        return this.f.lastModified();
    }

    @Override
    public boolean delete() {
        return this.f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer cb = this.fileManager.getCachedContent(this);
        if (cb == null) {
            FileInputStream in = new FileInputStream(this.f);
            try {
                ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                JavaFileObject prev = this.fileManager.log.useSource(this);
                try {
                    cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.fileManager.log.useSource(prev);
                    throw throwable;
                }
                this.fileManager.log.useSource(prev);
                this.fileManager.recycleByteBuffer(bb);
                if (!ignoreEncodingErrors) {
                    this.fileManager.cache(this, cb);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
        return cb;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegularFileObject)) {
            return false;
        }
        RegularFileObject o = (RegularFileObject)other;
        try {
            return this.f.equals(o.f) || this.f.getCanonicalFile().equals(o.f.getCanonicalFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    @Override
    public URI toUri() {
        try {
            String path = this.f.getAbsolutePath().replace(File.separatorChar, '/');
            return new URI("file://" + path).normalize();
        }
        catch (URISyntaxException ex) {
            return this.f.toURI();
        }
    }
}

