/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.php.project.connections.ui.SortColumnHeaderRenderer;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableModel;
import org.netbeans.modules.php.project.connections.ui.TransferFileUnit;

final class TransferFilterTable
extends JTable {
    private static final long serialVersionUID = -1378410694823823371L;
    private static final int DARKER_COLOR_COMPONENT = 10;
    private final TransferFileTableModel model;
    private int rowHeightFontBase = -1;

    TransferFilterTable(TransferFileTableModel transferFileTableModel) {
        super(transferFileTableModel);
        this.model = transferFileTableModel;
        this.setShowGrid(false);
        this.setColumnsSize();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.revalidate();
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().setBackground(this.getBackground());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        int n2;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n3 = this.rowAtPoint(point);
        string = this.model.getToolTipText(n3, n2 = this.convertColumnIndexToModel(n = this.columnAtPoint(point)));
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    private void setColumnsSize() {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.model.getPreferredWidth(this.getTableHeader(), i));
        }
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        Color color = this.getBackground();
        Color color2 = TransferFilterTable.getDarkerColor(color);
        TransferFileUnit transferFileUnit = this.model.getUnitAtRow(n);
        if (transferFileUnit != null && !transferFileUnit.canBeMarked()) {
            component.setForeground(Color.gray);
        } else {
            component.setFont(this.getFont());
            if (this.isRowSelected(n)) {
                component.setForeground(this.getSelectionForeground());
            } else {
                component.setForeground(this.getForeground());
            }
        }
        if (!this.isCellSelected(n, n2)) {
            if (n % 2 == 0) {
                component.setBackground(color2);
            } else {
                component.setBackground(color);
            }
        }
        if (this.rowHeightFontBase < 0) {
            Font font = component.getFont();
            FontMetrics fontMetrics = component.getFontMetrics(font);
            int n3 = new JTable().getRowHeight();
            this.rowHeightFontBase = Math.max(n3, fontMetrics.getHeight());
            this.setRowHeight(this.rowHeightFontBase);
        }
        return component;
    }

    static Color getDarkerColor(Color color) {
        return new Color(Math.abs(color.getRed() - 10), Math.abs(color.getGreen() - 10), Math.abs(color.getBlue() - 10));
    }

    protected JTableHeader createDefaultTableHeader() {
        return new TransferFilterTableHeader();
    }

    private final class TransferFilterTableHeader
    extends JTableHeader {
        private static final long serialVersionUID = 19524897514214165L;
        private SortColumnHeaderRenderer sortingRenderer;
        int selectedRow;

        TransferFilterTableHeader() {
            super(TransferFilterTable.this.getColumnModel());
            this.selectedRow = -1;
            this.setTable(TransferFilterTable.this);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    TransferFilterTableHeader.this.setSelectedRow();
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    assert (TransferFilterTableHeader.this.sortingRenderer != null) : "Sorting renderer cannot be null.";
                    TransferFileUnit transferFileUnit = TransferFilterTableHeader.this.getSelectedUnit();
                    int n = TransferFilterTableHeader.this.getTable().columnAtPoint(mouseEvent.getPoint());
                    TransferFilterTableHeader.this.sortingRenderer.setSorting(n);
                    TransferFilterTableHeader.this.repaint();
                    TransferFilterTableHeader.this.scroolToUnit(transferFileUnit);
                }
            });
            this.getModel().addUpdateUnitListener(new TransferFileTableChangeListener(){

                public void updateUnitsChanged() {
                    assert (TransferFilterTableHeader.this.sortingRenderer != null) : "Sorting renderer cannot be null.";
                    TransferFilterTableHeader.this.setSelectedRow();
                    TransferFileUnit transferFileUnit = TransferFilterTableHeader.this.getSelectedUnit();
                    TransferFilterTableHeader.this.sortingRenderer.sort();
                    TransferFilterTableHeader.this.scroolToUnit(transferFileUnit);
                }

                public void filterChanged() {
                }
            });
            this.setReorderingAllowed(false);
        }

        public void setDraggedColumn(TableColumn tableColumn) {
            if (tableColumn != null && tableColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(tableColumn);
        }

        public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
            if (!(tableCellRenderer instanceof SortColumnHeaderRenderer)) {
                this.sortingRenderer = new SortColumnHeaderRenderer(this.getModel(), tableCellRenderer);
                tableCellRenderer = this.sortingRenderer;
            }
            super.setDefaultRenderer(tableCellRenderer);
        }

        void setSelectedRow() {
            this.selectedRow = this.getTable().getSelectedRow();
        }

        TransferFileUnit getSelectedUnit() {
            TransferFileUnit transferFileUnit = null;
            TransferFileTableModel transferFileTableModel = this.getModel();
            if (this.selectedRow != -1) {
                transferFileUnit = transferFileTableModel.getUnitAtRow(this.selectedRow);
            }
            return transferFileUnit;
        }

        void scroolToUnit(TransferFileUnit transferFileUnit) {
            if (transferFileUnit == null) {
                return;
            }
            TransferFileTableModel transferFileTableModel = this.getModel();
            int n = transferFileTableModel.getRowForUnit(transferFileUnit);
            assert (n != -1) : String.format("Previoulsy selecte unit %s has to be found.", transferFileUnit);
            this.getTable().getSelectionModel().setSelectionInterval(n, n);
            Rectangle rectangle = this.getTable().getCellRect(n, 0, true);
            this.getTable().scrollRectToVisible(rectangle);
        }

        private TransferFileTableModel getModel() {
            return (TransferFileTableModel)TransferFilterTable.this.getModel();
        }
    }
}

