/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.SoftReference;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.security.AddKeystorePanel;
import org.netbeans.modules.mobility.project.ui.security.CreateKeyAliasPanel;
import org.netbeans.modules.mobility.project.ui.security.EnterPasswordPanel;
import org.netbeans.modules.mobility.project.ui.security.ExportPanel;
import org.netbeans.modules.mobility.project.ui.security.KeyAliasCellRenderer;
import org.netbeans.modules.mobility.project.ui.security.KeystoreCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SecurityManagerPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private static SoftReference<SecurityManagerPanel> pRef;
    private static SoftReference<Dialog> dRef;
    private final DefaultListModel ksModel;
    private final CardLayout cLayout;
    private final KeyAliasCellRenderer kaRenderer;
    private DefaultListModel kaModel;
    private JButton bAddKeystore;
    private JButton bCreateKey;
    private JButton bDeleteKey;
    private JButton bExportKey;
    private JButton bRemoveKeystore;
    private JButton bUnlockKey;
    private JButton bUnlockKeystore;
    private JCheckBox cDetails;
    private JLabel jLabelKestores;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList lKeys;
    private JLabel lKeys2;
    private JLabel lKeystoreFile;
    private JLabel lKeystoreFile2;
    private JList lKeystores;
    private JPanel pEmpty;
    private JPanel pKeys;
    private JPanel pRight;
    private JPanel pUnlock;
    private JTextField tKeystoreFile;
    private JTextField tKeystoreFile2;

    public static void showSecurityManager(KeyStoreRepository.KeyStoreBean keyStoreBean, KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean) {
        Dialog dialog;
        SecurityManagerPanel securityManagerPanel;
        if (pRef == null || (securityManagerPanel = pRef.get()) == null) {
            securityManagerPanel = new SecurityManagerPanel();
            pRef = new SoftReference<SecurityManagerPanel>(securityManagerPanel);
            dialog = securityManagerPanel.createDialog();
            dRef = new SoftReference<Dialog>(dialog);
        } else if (dRef == null || (dialog = dRef.get()) == null || !dialog.isShowing()) {
            dialog = securityManagerPanel.createDialog();
            dRef = new SoftReference<Dialog>(dialog);
        }
        securityManagerPanel.setSelectedItems(keyStoreBean, keyAliasBean);
        dialog.setVisible(true);
    }

    private SecurityManagerPanel() {
        this.initComponents();
        this.initAccessibility();
        this.cLayout = (CardLayout)this.pRight.getLayout();
        this.lKeystores.setCellRenderer(new KeystoreCellRenderer());
        this.kaRenderer = new KeyAliasCellRenderer();
        this.lKeys.setCellRenderer(this.kaRenderer);
        this.ksModel = new DefaultListModel();
        this.kaModel = new DefaultListModel();
        this.lKeys.setModel(this.kaModel);
        this.lKeystores.setModel(this.ksModel);
        this.lKeystores.addListSelectionListener(this);
        this.lKeys.addListSelectionListener(this);
        this.cDetails.addActionListener(this);
        this.bAddKeystore.addActionListener(this);
        this.bRemoveKeystore.addActionListener(this);
        this.bUnlockKeystore.addActionListener(this);
        this.bCreateKey.addActionListener(this);
        this.bDeleteKey.addActionListener(this);
        this.bUnlockKey.addActionListener(this);
        this.bExportKey.addActionListener(this);
        this.updateKeystores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKeystores() {
        DefaultListModel defaultListModel = this.ksModel;
        synchronized (defaultListModel) {
            Object e = this.lKeystores.getSelectedValue();
            boolean bl = false;
            this.ksModel.clear();
            for (KeyStoreRepository.KeyStoreBean keyStoreBean : KeyStoreRepository.getDefault().getKeyStores()) {
                this.ksModel.addElement(keyStoreBean);
                if (keyStoreBean != e) continue;
                bl = true;
            }
            if (bl) {
                this.lKeystores.setSelectedValue(e, true);
            }
        }
        this.updateKeys();
    }

    private Dialog createDialog() {
        return DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)this, NbBundle.getMessage(SecurityManagerPanel.class, (String)"TITLE_SecurityManager"), true, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.CLOSED_OPTION, 0, new HelpCtx(SecurityManagerPanel.class), null));
    }

    private void setSelectedItems(KeyStoreRepository.KeyStoreBean keyStoreBean, KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean) {
        if (keyStoreBean != null) {
            this.lKeystores.setSelectedValue(keyStoreBean, true);
        }
        if (keyAliasBean != null) {
            this.lKeys.setSelectedValue(keyAliasBean, true);
        }
    }

    private void reloadKeys(KeyStoreRepository.KeyStoreBean keyStoreBean) {
        Object e = this.lKeys.getSelectedValue();
        boolean bl = false;
        this.kaModel = new DefaultListModel();
        this.lKeys.setModel(this.kaModel);
        if (keyStoreBean == null || !keyStoreBean.isValid() || !keyStoreBean.isOpened()) {
            return;
        }
        for (KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean : keyStoreBean.aliasses()) {
            this.kaModel.addElement(keyAliasBean);
            if (keyAliasBean != e) continue;
            bl = true;
        }
        if (bl) {
            this.lKeys.setSelectedValue(e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKeys() {
        KeyStoreRepository.KeyStoreBean keyStoreBean = (KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue();
        DefaultListModel defaultListModel = this.kaModel;
        synchronized (defaultListModel) {
            if (keyStoreBean == null || !keyStoreBean.isValid()) {
                this.cLayout.show(this.pRight, "empty");
            } else if (keyStoreBean.isOpened()) {
                this.tKeystoreFile.setText(keyStoreBean.getKeyStorePath());
                this.reloadKeys(keyStoreBean);
                this.cLayout.show(this.pRight, "keys");
            } else {
                this.tKeystoreFile2.setText(keyStoreBean.getKeyStorePath());
                this.cLayout.show(this.pRight, "unlock");
            }
        }
        this.bRemoveKeystore.setEnabled(keyStoreBean != null && !KeyStoreRepository.isDefaultKeystore(keyStoreBean));
        this.updateButtons();
    }

    private void updateButtons() {
        KeyStoreRepository.KeyStoreBean keyStoreBean = (KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue();
        KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.lKeys.getSelectedValue();
        boolean bl = keyAliasBean != null;
        boolean bl2 = !KeyStoreRepository.isDefaultKeystore(keyStoreBean);
        this.bUnlockKey.setEnabled(bl && keyAliasBean.isValid() && !keyAliasBean.isOpened());
        this.bExportKey.setEnabled(bl && keyAliasBean.isValid() && keyAliasBean.isOpened());
        this.bCreateKey.setEnabled(bl2);
        this.bDeleteKey.setEnabled(bl && bl2);
    }

    private void initComponents() {
        this.jLabelKestores = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lKeystores = new JList();
        this.bAddKeystore = new JButton();
        this.bRemoveKeystore = new JButton();
        this.pRight = new JPanel();
        this.pEmpty = new JPanel();
        this.pUnlock = new JPanel();
        this.lKeystoreFile2 = new JLabel();
        this.tKeystoreFile2 = new JTextField();
        this.bUnlockKeystore = new JButton();
        this.pKeys = new JPanel();
        this.jPanel2 = new JPanel();
        this.lKeystoreFile = new JLabel();
        this.tKeystoreFile = new JTextField();
        this.lKeys2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lKeys = new JList();
        this.bCreateKey = new JButton();
        this.bExportKey = new JButton();
        this.bDeleteKey = new JButton();
        this.bUnlockKey = new JButton();
        this.cDetails = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setMinimumSize(new Dimension(700, 400));
        this.setLayout(new GridBagLayout());
        this.jLabelKestores.setLabelFor(this.lKeystores);
        Mnemonics.setLocalizedText((JLabel)this.jLabelKestores, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_Keystores"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelKestores, gridBagConstraints);
        this.lKeystores.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lKeystores);
        this.lKeystores.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_Keystores"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAddKeystore, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.bAddKeystore, gridBagConstraints);
        this.bAddKeystore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_AddKeystore"));
        Mnemonics.setLocalizedText((AbstractButton)this.bRemoveKeystore, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.bRemoveKeystore, gridBagConstraints);
        this.bRemoveKeystore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_RemoveKeystore"));
        this.pRight.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.pRight.setLayout(new CardLayout());
        this.pRight.add((Component)this.pEmpty, "empty");
        this.pUnlock.setLayout(new GridBagLayout());
        this.lKeystoreFile2.setLabelFor(this.tKeystoreFile);
        Mnemonics.setLocalizedText((JLabel)this.lKeystoreFile2, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_KeystoreFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.pUnlock.add((Component)this.lKeystoreFile2, gridBagConstraints);
        this.tKeystoreFile2.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.pUnlock.add((Component)this.tKeystoreFile2, gridBagConstraints);
        this.tKeystoreFile2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_KeystoreFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.bUnlockKeystore, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_UnlockKeystore"));
        this.bUnlockKeystore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityManagerPanel.this.bUnlockKeystoreActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pUnlock.add((Component)this.bUnlockKeystore, gridBagConstraints);
        this.bUnlockKeystore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_UnlockKeystore"));
        this.pRight.add((Component)this.pUnlock, "unlock");
        this.pKeys.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.lKeystoreFile.setLabelFor(this.tKeystoreFile);
        Mnemonics.setLocalizedText((JLabel)this.lKeystoreFile, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_KeystoreFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.jPanel2.add((Component)this.lKeystoreFile, gridBagConstraints);
        this.tKeystoreFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.jPanel2.add((Component)this.tKeystoreFile, gridBagConstraints);
        this.tKeystoreFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_KeystoreFile2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.pKeys.add((Component)this.jPanel2, gridBagConstraints);
        this.lKeys2.setLabelFor(this.lKeys);
        Mnemonics.setLocalizedText((JLabel)this.lKeys2, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.pKeys.add((Component)this.lKeys2, gridBagConstraints);
        this.lKeys.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lKeys);
        this.lKeys.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.pKeys.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bCreateKey, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_NewKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 18, 0);
        this.pKeys.add((Component)this.bCreateKey, gridBagConstraints);
        this.bCreateKey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_New"));
        Mnemonics.setLocalizedText((AbstractButton)this.bExportKey, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_ExportKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.pKeys.add((Component)this.bExportKey, gridBagConstraints);
        this.bExportKey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_Export"));
        Mnemonics.setLocalizedText((AbstractButton)this.bDeleteKey, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_DeleteKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.pKeys.add((Component)this.bDeleteKey, gridBagConstraints);
        this.bDeleteKey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_Delete"));
        Mnemonics.setLocalizedText((AbstractButton)this.bUnlockKey, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_UnlockKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.pKeys.add((Component)this.bUnlockKey, gridBagConstraints);
        this.bUnlockKey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_UnlockKeystore2"));
        Mnemonics.setLocalizedText((AbstractButton)this.cDetails, (String)NbBundle.getMessage(SecurityManagerPanel.class, (String)"LBL_Manager_ShowDetails"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.pKeys.add((Component)this.cDetails, gridBagConstraints);
        this.cDetails.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager_Details"));
        this.pRight.add((Component)this.pKeys, "keys");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pRight, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSN_Manager"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SecurityManagerPanel.class, (String)"ACSD_Manager"));
    }

    private void bUnlockKeystoreActionPerformed(ActionEvent actionEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.lKeystores == listSelectionEvent.getSource()) {
            this.updateKeys();
        } else if (this.lKeys == listSelectionEvent.getSource()) {
            this.updateButtons();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.cDetails == object) {
            this.kaRenderer.setShowDetails(this.cDetails.isSelected());
            this.reloadKeys((KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue());
        } else if (this.bAddKeystore == object) {
            if (AddKeystorePanel.showAddKeystorePanel() != null) {
                this.updateKeystores();
            }
        } else if (this.bUnlockKeystore == object) {
            EnterPasswordPanel.getKeystorePassword((KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue());
            this.updateKeystores();
        } else if (this.bRemoveKeystore.equals(object)) {
            KeyStoreRepository.getDefault().removeKeyStore((KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue());
            this.updateKeystores();
        } else if (this.bCreateKey == object) {
            KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean = CreateKeyAliasPanel.showCreateKeyAliasPanel((KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue());
            this.updateKeys();
            if (keyAliasBean != null) {
                this.lKeys.setSelectedValue(keyAliasBean, true);
            }
        } else if (this.bExportKey == object) {
            KeyStoreRepository.KeyStoreBean keyStoreBean = (KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue();
            KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.lKeys.getSelectedValue();
            ExportPanel.showExportKeyIntoPlatform(keyStoreBean, keyAliasBean, null, null);
        } else if (this.bDeleteKey == object) {
            KeyStoreRepository.KeyStoreBean keyStoreBean = (KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue();
            KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.lKeys.getSelectedValue();
            this.deleteAlias(keyStoreBean, keyAliasBean);
        } else if (this.bUnlockKey == object) {
            EnterPasswordPanel.getAliasPassword((KeyStoreRepository.KeyStoreBean)this.lKeystores.getSelectedValue(), (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.lKeys.getSelectedValue());
            this.updateKeys();
        }
    }

    private void deleteAlias(KeyStoreRepository.KeyStoreBean keyStoreBean, KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean) {
        if (keyStoreBean == null || keyAliasBean == null) {
            return;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateKeyAliasPanel.class, (String)"MSG_PromptDeleteKey", (Object)keyAliasBean), NbBundle.getBundle(CreateKeyAliasPanel.class).getString("MSG_PromptDeleteKeyTitle"), 0, 3);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (confirmation.getValue() == NotifyDescriptor.YES_OPTION) {
            try {
                keyStoreBean.removeAliasFromStore(keyAliasBean);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.updateKeys();
        }
    }
}

