/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.GlobalAbilitiesCache;
import org.netbeans.modules.mobility.project.ui.customizer.AddAbilityPanel;
import org.netbeans.modules.mobility.project.ui.customizer.AddAttributePanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizerAbilities
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener {
    static final String[] PROPERTY_GROUP = new String[]{"abilities"};
    protected final JTable table;
    protected final StorableTableModel tableModel;
    private VisualPropertySupport vps;
    private ProjectProperties props;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bRemove;
    private JCheckBox cDefault;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerAbilities() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    CustomizerAbilities.this.bEditActionPerformed(null);
                }
            }
        });
        GlobalAbilitiesCache.getDefault();
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_Abilities"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 4);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_AddAbility"));
        this.bAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerAbilities.this.bAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 11, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_EditAbility"));
        this.bEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerAbilities.this.bEditActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_RemoveAbility"));
        this.bRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerAbilities.this.bRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerAbilities.class, (String)"ACSN_CustAbilities"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerAbilities.class, (String)"ACSD_CustAbilities"));
    }

    @Override
    public void initValues(ProjectProperties projectProperties, String string) {
        this.props = projectProperties;
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.vps.register(this.cDefault, string, this);
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    @Override
    public void initGroupValues(boolean bl) {
        this.vps.register(this.tableModel, new String[]{"abilities"}, bl);
        boolean bl2 = bl ^ true;
        this.bAdd.setEnabled(bl2);
        this.bEdit.setEnabled(bl2);
        this.bRemove.setEnabled(bl2);
        this.table.setEnabled(bl2);
        this.lTable.setEnabled(bl2);
        this.table.setBackground(UIManager.getDefaults().getColor(bl ? "Panel.background" : "Table.background"));
        this.valueChanged(null);
    }

    private Set<String> getUsedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>(this.tableModel.getKeys());
        ProjectConfiguration[] projectConfigurationArray = this.props.getConfigurations();
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            hashSet.add(projectConfigurationArray[i].getDisplayName());
        }
        return hashSet;
    }

    private void bAddActionPerformed(ActionEvent actionEvent) {
        final AddAbilityPanel addAbilityPanel = new AddAbilityPanel();
        Set<String> set = this.getUsedIdentifiers();
        Vector<String> vector = new Vector<String>(GlobalAbilitiesCache.getDefault().getAllAbilities());
        vector.removeAll(set);
        addAbilityPanel.init(false, vector, set, null, null);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addAbilityPanel, NbBundle.getMessage(CustomizerAbilities.class, (String)"TITLE_AddAbility"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    String string = addAbilityPanel.getKey();
                    GlobalAbilitiesCache.getDefault().addAbility(string);
                    int n = CustomizerAbilities.this.tableModel.addRow(string, addAbilityPanel.getValue());
                    CustomizerAbilities.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        addAbilityPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bEditActionPerformed(ActionEvent actionEvent) {
        final int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        final String string = this.tableModel.getValueAt(n, 0);
        String string2 = this.tableModel.getValueAt(n, 1);
        final AddAbilityPanel addAbilityPanel = new AddAbilityPanel();
        Set<String> set = this.getUsedIdentifiers();
        Vector<String> vector = new Vector<String>(GlobalAbilitiesCache.getDefault().getAllAbilities());
        vector.removeAll(set);
        if (string != null) {
            vector.add(string);
        }
        addAbilityPanel.init(true, vector, set, string, string2);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addAbilityPanel, NbBundle.getMessage(CustomizerAbilities.class, (String)"TITLE_EditAbility"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    String string2 = addAbilityPanel.getKey();
                    GlobalAbilitiesCache.getDefault().addAbility(string2);
                    if (string == null || !string.equals(string2)) {
                        if (string != null) {
                            CustomizerAbilities.this.tableModel.removeRow(n);
                        }
                        int n2 = CustomizerAbilities.this.tableModel.addRow(string2, addAbilityPanel.getValue());
                        CustomizerAbilities.this.table.getSelectionModel().setSelectionInterval(n2, n2);
                    } else {
                        CustomizerAbilities.this.tableModel.editRow(string2, addAbilityPanel.getValue());
                        CustomizerAbilities.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        });
        addAbilityPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.tableModel.removeRow(n);
        int n2 = this.tableModel.getRowCount();
        if (n2 <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (n < n2) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        } else {
            this.table.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        boolean bl = this.table.isEnabled() && n >= 0;
        this.bEdit.setEnabled(bl);
        this.bRemove.setEnabled(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        private ArrayList<Map.Entry<String, String>> entries = new ArrayList();
        private HashMap<String, String> map = new HashMap();
        private static final long serialVersionUID = -2195421895353167171L;

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Set<String> getKeys() {
            return this.map.keySet();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_Column_Ability");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_Column_Value");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            return new Object[]{this.map};
        }

        @Override
        public String getValueAt(int n, int n2) {
            assert (n < this.entries.size());
            Map.Entry<String, String> entry = this.entries.get(n);
            return n2 == 0 ? entry.getKey() : (entry.getValue() == null ? "" : entry.getValue());
        }

        @Override
        public synchronized void setDataDelegates(Object[] objectArray) {
            assert (objectArray != null);
            this.map = objectArray[0] == null ? new HashMap() : (HashMap)objectArray[0];
            this.entries = new ArrayList<Map.Entry<String, String>>(this.map.entrySet());
            Collections.sort(this.entries, new AbilitiesComparator());
            this.fireTableDataChanged();
        }

        public int addRow(String string, String string2) {
            Map.Entry<String, String> entry;
            if (this.map.containsKey(string)) {
                return -1;
            }
            this.map.put(string, string2);
            Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
            while (!string.equals((entry = iterator.next()).getKey())) {
            }
            int n = this.entries.size();
            this.entries.add(entry);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void editRow(String string, String string2) {
            this.map.put(string, string2);
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get(i).getKey().equals(string)) continue;
                this.fireTableRowsUpdated(i, i);
                return;
            }
        }

        public void removeRow(int n) {
            assert (n < this.entries.size());
            Map.Entry<String, String> entry = this.entries.remove(n);
            this.map.entrySet().remove(entry);
            this.fireTableRowsDeleted(n, this.entries.size() + 1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AbilitiesComparator
        implements Comparator<Map.Entry<String, String>> {
            private AbilitiesComparator() {
            }

            @Override
            public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
                return entry.getKey().compareToIgnoreCase(entry2.getKey());
            }

            @Override
            public boolean equals(Object object) {
                return this.equals(object);
            }
        }
    }
}

