/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.editor.indent.TaskHandler;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;

public final class IndentImpl {
    private static final Logger LOG = Logger.getLogger(IndentImpl.class.getName());
    private final Document doc;
    private Indent indent;
    private Reformat reformat;
    private TaskHandler indentHandler;
    private TaskHandler reformatHandler;
    private Formatter defaultFormatter;

    public static IndentImpl get(Document document) {
        IndentImpl indentImpl = (IndentImpl)document.getProperty(IndentImpl.class);
        if (indentImpl == null) {
            indentImpl = new IndentImpl(document);
            document.putProperty(IndentImpl.class, indentImpl);
        }
        indentImpl.refresh();
        return indentImpl;
    }

    public IndentImpl(Document document) {
        this.doc = document;
    }

    public Document document() {
        return this.doc;
    }

    public Indent getIndent() {
        return this.indent;
    }

    public void setIndent(Indent indent) {
        this.indent = indent;
    }

    public Reformat getReformat() {
        return this.reformat;
    }

    public void setReformat(Reformat reformat) {
        this.reformat = reformat;
    }

    void setDefaultFormatter(Formatter formatter) {
        this.defaultFormatter = formatter;
    }

    void refresh() {
        if (this.defaultFormatter == null && this.doc instanceof BaseDocument) {
            this.defaultFormatter = ((BaseDocument)this.doc).getLegacyFormatter();
        }
    }

    public synchronized void indentLock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("indentLock() on " + this);
        }
        if (this.indentHandler != null) {
            throw new IllegalStateException("Already locked");
        }
        TaskHandler taskHandler = new TaskHandler(true, this.doc);
        if (taskHandler.collectTasks()) {
            taskHandler.lock();
        }
        this.indentHandler = taskHandler;
    }

    public synchronized void indentUnlock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("indentUnlock() on " + this);
        }
        if (this.indentHandler == null) {
            throw new IllegalStateException("Already unlocked");
        }
        this.indentHandler.unlock();
        this.indentHandler = null;
    }

    public TaskHandler indentHandler() {
        return this.indentHandler;
    }

    public synchronized void reformatLock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("reformatLock() on " + this);
        }
        if (this.reformatHandler != null) {
            throw new IllegalStateException("Already locked");
        }
        TaskHandler taskHandler = new TaskHandler(false, this.doc);
        if (taskHandler.collectTasks()) {
            taskHandler.lock();
        }
        this.reformatHandler = taskHandler;
    }

    public synchronized void reformatUnlock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("reformatUnlock() on " + this);
        }
        if (this.reformatHandler == null) {
            throw new IllegalStateException("Already unlocked");
        }
        this.reformatHandler.unlock();
        this.reformatHandler = null;
    }

    public TaskHandler reformatHandler() {
        return this.reformatHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reindent(int n, int n2, int n3, boolean bl) throws BadLocationException {
        if (n > n2) {
            throw new IllegalArgumentException("startOffset=" + n + " > endOffset=" + n2);
        }
        boolean bl2 = false;
        if (this.indentHandler == null) {
            LOG.log(Level.SEVERE, null, new Exception("Not locked. Use Indent.lock()."));
            bl2 = true;
            this.indentHandler = new TaskHandler(true, this.doc);
        }
        try {
            int n4;
            if (bl2) {
                this.indentHandler.collectTasks();
            }
            this.indentHandler.setCaretOffset(n3);
            Element element = IndentImpl.lineRootElement(this.doc);
            boolean bl3 = false;
            if (this.indentHandler.hasItems()) {
                if (bl) {
                    this.doc.insertString(n, "\n", null);
                    ++n;
                    ++n2;
                    if (this.indentHandler.caretOffset() == 0) {
                        this.indentHandler.setCaretOffset(1);
                    }
                }
                n4 = element.getElementIndex(n);
                Element element2 = element.getElement(n4);
                int n5 = element2.getStartOffset();
                if (n2 > element2.getEndOffset()) {
                    int n6 = element.getElementIndex(n2);
                    element2 = element.getElement(n6);
                    if (n6 > 0 && element2.getStartOffset() == n2) {
                        element2 = element.getElement(--n6);
                    }
                }
                this.indentHandler.setGlobalBounds(this.doc.createPosition(n5), this.doc.createPosition(element2.getEndOffset() - 1));
                this.indentHandler.runTasks();
                bl3 = true;
            }
            if (!bl3 && this.doc instanceof BaseDocument && this.defaultFormatter != null) {
                if (bl) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Defaulting reindent() to indentNewLine() in legacy formatter " + this.defaultFormatter + '\n');
                    }
                    n4 = this.defaultFormatter.indentNewLine(this.doc, n3);
                    this.indentHandler.setCaretOffset(n4);
                } else {
                    Element element3;
                    int n7;
                    Position position = this.doc.createPosition(n2);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Defaulting reindent() to indentLine() in legacy formatter " + this.defaultFormatter + '\n');
                    }
                    while ((n7 = element.getElementIndex(n = this.defaultFormatter.indentLine(this.doc, n)) + 1) < element.getElementCount() && (n = (element3 = element.getElement(n7)).getStartOffset()) < position.getOffset()) {
                    }
                }
            }
            int n8 = this.indentHandler.caretOffset();
            return n8;
        }
        finally {
            if (bl2) {
                this.indentHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reformat(int n, int n2) throws BadLocationException {
        if (n > n2) {
            throw new IllegalArgumentException("startOffset=" + n + " > endOffset=" + n2);
        }
        boolean bl = false;
        if (this.reformatHandler == null) {
            LOG.log(Level.SEVERE, "Not locked. Use Reformat.lock().", new Exception());
            bl = true;
            this.reformatHandler = new TaskHandler(false, this.doc);
        }
        try {
            if (bl) {
                this.reformatHandler.collectTasks();
            }
            boolean bl2 = false;
            if (this.reformatHandler.hasItems()) {
                this.reformatHandler.setGlobalBounds(this.doc.createPosition(n), this.doc.createPosition(n2));
                this.reformatHandler.runTasks();
                bl2 = true;
            }
            if (!bl2 && this.doc instanceof BaseDocument && this.defaultFormatter != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Defaulting reformat() to reformat() in legacy formatter " + this.defaultFormatter + '\n');
                }
                BaseDocument baseDocument = (BaseDocument)this.doc;
                this.defaultFormatter.reformat(baseDocument, n, n2);
            }
        }
        finally {
            if (bl) {
                this.reformatHandler = null;
            }
        }
    }

    public static Element lineRootElement(Document document) {
        return document instanceof StyledDocument ? ((StyledDocument)document).getParagraphElement(0).getParentElement() : document.getDefaultRootElement();
    }

    public static void checkOffsetInDocument(Document document, int n) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("offset=" + n + " < 0", n);
        }
        if (n > document.getLength()) {
            throw new BadLocationException("offset=" + n + " > doc.getLength()=" + document.getLength(), n);
        }
    }
}

