/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;

public class FileMagic {
    private MyRandomAccessFile reader;
    private Magic magic;

    public FileMagic(String string) throws WrongFileFormatException, IOException {
        this.reader = new MyRandomAccessFile(string);
        try {
            this.readMagic();
        }
        catch (WrongFileFormatException wrongFileFormatException) {
            throw new WrongFileFormatException(wrongFileFormatException.getMessage() + ":" + string);
        }
    }

    public RandomAccessFile getReader() {
        return this.reader;
    }

    public Magic getMagic() {
        return this.magic;
    }

    private void readMagic() throws WrongFileFormatException {
        byte[] byArray = new byte[8];
        try {
            this.reader.readFully(byArray);
        }
        catch (IOException iOException) {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
        if (FileMagic.isElfMagic(byArray)) {
            this.magic = Magic.Elf;
        } else if (FileMagic.isCoffMagic(byArray)) {
            this.magic = Magic.Coff;
        } else if (FileMagic.isExeMagic(byArray)) {
            this.magic = Magic.Exe;
        } else if (FileMagic.isPeMagic(byArray)) {
            this.magic = Magic.Pe;
        } else if (FileMagic.isMachoMagic(byArray)) {
            this.magic = Magic.Macho;
        } else if (FileMagic.isArchiveMagic(byArray)) {
            this.magic = Magic.Arch;
        } else {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
    }

    public void dispose() {
        if (this.reader != null) {
            this.reader.dispose();
            this.reader = null;
        }
    }

    public static boolean isExeMagic(byte[] byArray) {
        return byArray[0] == 77 && byArray[1] == 90;
    }

    public static boolean isPeMagic(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 69 && byArray[2] == 0 && byArray[3] == 0;
    }

    public static boolean isCoffMagic(byte[] byArray) {
        return byArray[0] == 76 && byArray[1] == 1;
    }

    public static boolean isElfMagic(byte[] byArray) {
        return byArray[0] == 127 && byArray[1] == 69 && byArray[2] == 76 && byArray[3] == 70;
    }

    public static boolean isMachoMagic(byte[] byArray) {
        return (byArray[0] == -50 || byArray[0] == -49) && byArray[1] == -6 && byArray[2] == -19 && byArray[3] == -2;
    }

    public static boolean isArchiveMagic(byte[] byArray) {
        return byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62 && byArray[7] == 10;
    }

    private static final class MyRandomAccessFile
    extends RandomAccessFile {
        private static final int BUF_SIZE = Integer.getInteger("cnd.dwarfdump.random_access_file_buffer_size", 8192);
        private String fileName;
        private byte[] buffer = new byte[BUF_SIZE];
        private int buf_end = 0;
        private int buf_pos = 0;
        private long real_pos = 0L;
        private static final boolean TRACE_STATISTIC = false;
        private long countOfReads = 0L;
        private long countOfBufferReads = 0L;

        private MyRandomAccessFile(String string) throws IOException {
            super(string, "r");
            this.fileName = string;
            this.invalidate();
        }

        private void invalidate() throws IOException {
            this.buf_end = 0;
            this.buf_pos = 0;
            this.real_pos = super.getFilePointer();
        }

        private int fillBuffer() throws IOException {
            int n = super.read(this.buffer, 0, BUF_SIZE);
            if (n >= 0) {
                this.real_pos += (long)n;
                this.buf_end = n;
                this.buf_pos = 0;
            }
            return n;
        }

        public int read() throws IOException {
            if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
                return -1;
            }
            if (this.buf_end == 0) {
                return -1;
            }
            return 0xFF & this.buffer[this.buf_pos++];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.buf_end - this.buf_pos;
            if (n2 <= n3) {
                System.arraycopy(this.buffer, this.buf_pos, byArray, n, n2);
                this.buf_pos += n2;
                return n2;
            }
            for (int i = 0; i < n2; ++i) {
                int n4 = this.read();
                if (n4 == -1) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                byArray[n + i] = (byte)n4;
            }
            return n2;
        }

        public long getFilePointer() throws IOException {
            long l = this.real_pos;
            return l - (long)this.buf_end + (long)this.buf_pos;
        }

        public void seek(long l) throws IOException {
            int n = (int)(this.real_pos - l);
            if (n >= 0 && n <= this.buf_end) {
                this.buf_pos = this.buf_end - n;
            } else {
                super.seek(l);
                this.invalidate();
            }
        }

        public void dispose() {
            try {
                this.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.buffer = null;
        }
    }
}

