/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemFinder;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExposeBusinessMethod
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> targetClassHandle;
    private ElementHandle<ExecutableElement> methodHandle;
    private boolean local;

    public ExposeBusinessMethod(FileObject fileObject, ElementHandle<TypeElement> elementHandle, ElementHandle<ExecutableElement> elementHandle2, boolean bl) {
        this.fileObject = fileObject;
        this.targetClassHandle = elementHandle;
        this.methodHandle = elementHandle2;
        this.local = bl;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)ExposeBusinessMethod.this.targetClassHandle.resolve((CompilationInfo)workingCopy);
                ExecutableElement executableElement = (ExecutableElement)ExposeBusinessMethod.this.methodHandle.resolve((CompilationInfo)workingCopy);
                if (typeElement == null || executableElement == null) {
                    return;
                }
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                MethodTree methodTree = treeMaker.Method(executableElement, null);
                GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
                ClassTree classTree2 = generatorUtilities.insertClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        };
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)this.fileObject);
        FileObject fileObject = SourceUtils.getFile(this.targetClassHandle, (ClasspathInfo)classpathInfo);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.fileObject, fileObject});
        try {
            return this.commitAndComputeChangeInfo(fileObject, javaSource.runModificationTask((Task)cancellableTask));
        }
        catch (IOException iOException) {
            EJBProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
            return null;
        }
    }

    private ChangeInfo commitAndComputeChangeInfo(FileObject fileObject, ModificationResult modificationResult) throws IOException {
        CloneableEditorSupport cloneableEditorSupport;
        ChangeInfo changeInfo;
        block6: {
            List list = modificationResult.getDifferences(fileObject);
            changeInfo = null;
            cloneableEditorSupport = null;
            try {
                if (list == null) break block6;
                for (ModificationResult.Difference difference : list) {
                    if (difference.getNewText() == null) continue;
                    final PositionRef positionRef = difference.getStartPosition();
                    StyledDocument styledDocument = positionRef.getCloneableEditorSupport().getDocument();
                    if (styledDocument == null) {
                        styledDocument = positionRef.getCloneableEditorSupport().openDocument();
                    }
                    cloneableEditorSupport = positionRef.getCloneableEditorSupport();
                    final Position[] positionArray = new Position[1];
                    final StyledDocument styledDocument2 = styledDocument;
                    styledDocument.render(new Runnable(){

                        public void run() {
                            try {
                                positionArray[0] = NbDocument.createPosition((Document)styledDocument2, (int)positionRef.getOffset(), (Position.Bias)Position.Bias.Backward);
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                    if (positionArray[0] != null) {
                        changeInfo = new ChangeInfo(fileObject, positionArray[0], positionArray[0]);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        modificationResult.commit();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.saveDocument();
        }
        return changeInfo;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getText() {
        String string = JavaUtils.getShortClassName(this.targetClassHandle.getQualifiedName());
        return NbBundle.getMessage(ExposeBusinessMethod.class, (String)(this.local ? "LBL_ExposeBusinessMethodLocal" : "LBL_ExposeBusinessMethodRemote"), (Object)string);
    }
}

