/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.adapter.GlobalRepositoryTreeAdapter;
import org.netbeans.modules.vmd.game.view.GameDesignTreeNodeRenderer;

public class GameDesignNavigator
extends JPanel {
    private GlobalRepository gameDesign;
    private JTree tree;
    private GlobalRepositoryTreeAdapter model;

    public GameDesignNavigator(GlobalRepository globalRepository) {
        this.gameDesign = globalRepository;
        this.init();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }

    private void init() {
        this.model = new GlobalRepositoryTreeAdapter(this.gameDesign);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new GameDesignTreeNodeRenderer());
        this.tree.addMouseListener(new TreeMousListener());
    }

    private class TreeMousListener
    extends MouseAdapter {
        private TreeMousListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Object object = this.getSelectedNodeObj(mouseEvent);
                if (object instanceof Editable) {
                    Editable editable = (Editable)object;
                    GameDesignNavigator.this.gameDesign.getMainView().requestEditing(editable);
                } else {
                    super.mouseClicked(mouseEvent);
                }
            } else {
                super.mouseClicked(mouseEvent);
            }
        }

        private Object getSelectedNodeObj(MouseEvent mouseEvent) {
            TreePath treePath = GameDesignNavigator.this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            GameDesignNavigator.this.tree.setSelectionPath(treePath);
            return treePath.getLastPathComponent();
        }

        private void handlePopup(MouseEvent mouseEvent) {
            Object object = this.getSelectedNodeObj(mouseEvent);
            if (object instanceof Editable) {
                Editable editable = (Editable)object;
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (Action action : editable.getActions()) {
                    jPopupMenu.add(action);
                }
                jPopupMenu.show(GameDesignNavigator.this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

