/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.LayerDataFlavor;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.Scene;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Layer
implements Previewable,
Editable,
Transferable,
Identifiable {
    private long id = -1L;
    public static final String ACTION_PROP_SCENE = "layer.action.prop.scene";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private GlobalRepository gameDesign;
    private String name;
    private ImageResource imageResource;
    private int cellWidth;
    private int cellHeight;

    protected Layer(GlobalRepository globalRepository, String string, ImageResource imageResource, int n, int n2) {
        assert (globalRepository != null);
        this.gameDesign = globalRepository;
        this.name = string;
        this.imageResource = imageResource;
        this.cellWidth = n;
        this.cellHeight = n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GlobalRepository getGameDesign() {
        return this.gameDesign;
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        if (this.getName().equals(string)) {
            return;
        }
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Layer cannot be renamed because component name '" + string + "' already exists.");
        }
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("editable.prop.name", string2, string);
    }

    public ImageResource getImageResource() {
        return this.imageResource;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public abstract void paint(Graphics2D var1);

    @Override
    public abstract int getHeight();

    @Override
    public abstract int getWidth();

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[1];
        try {
            dataFlavorArray[0] = new LayerDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor instanceof LayerDataFlavor;
    }

    public int getTileHeight() {
        return this.cellHeight;
    }

    public int getTileWidth() {
        return this.cellWidth;
    }

    public abstract String getDisplayableTypeName();

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new EditLayerAction());
        arrayList.add(new RemoveAction());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public JComponent getNavigator() {
        return null;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    public class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(Layer.class, (String)"Layer.removeAction", (Object)Layer.this.getDisplayableTypeName()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Scene scene = (Scene)this.getValue(Layer.ACTION_PROP_SCENE);
            if (scene != null) {
                scene.remove(Layer.this);
            } else {
                Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(Layer.class, (String)"Layer.removeDialog.text", (Object[])new Object[]{Layer.this.getDisplayableTypeName(), Layer.this.getName()}), NbBundle.getMessage(Layer.class, (String)"Layer.removeDialog.title"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION));
                if (object == NotifyDescriptor.YES_OPTION) {
                    Layer.this.gameDesign.removeLayer(Layer.this);
                }
            }
        }
    }

    public class EditLayerAction
    extends AbstractAction {
        public EditLayerAction() {
            this.putValue("Name", NbBundle.getMessage(Layer.class, (String)"Layer.editAction", (Object)Layer.this.getDisplayableTypeName()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer.this.gameDesign.getMainView().requestEditing(Layer.this);
        }
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (!(object instanceof Layer) || !(object2 instanceof Layer)) {
                throw new ClassCastException("Compared object not instance of Layer");
            }
            Layer layer = (Layer)object;
            Layer layer2 = (Layer)object2;
            return layer.getName().compareTo(layer2.getName());
        }
    }
}

