/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.vmd.game.dialog.AbstractImagePreviewComponent;
import org.netbeans.modules.vmd.game.model.ImageUtils;
import org.netbeans.modules.vmd.game.model.Position;

public class FullImageGridPreview
extends AbstractImagePreviewComponent {
    private static final boolean DEBUG = false;
    private URL imageURL;
    private BufferedImage originalImage;
    private int cellHeight;
    private int cellWidth;
    private int gridWidth = 3;

    public void setTileWidth(int n) {
        this.cellWidth = n;
        this.repaint();
    }

    public void setTileHeight(int n) {
        this.cellHeight = n;
        this.repaint();
    }

    public void setImageURL(URL uRL) throws MalformedURLException, IllegalArgumentException {
        this.imageURL = uRL;
        if (uRL == null) {
            return;
        }
        BufferedImage bufferedImage = ImageUtils.loadImage(uRL);
        if (bufferedImage == null) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufferedImage2 = new BufferedImage(((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        this.originalImage = bufferedImage2;
        this.cellWidth = this.originalImage.getWidth(this);
        this.cellHeight = this.originalImage.getHeight(this);
        this.repaint();
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public Image getImage() {
        return this.originalImage;
    }

    public Dimension getPreferredSize() {
        if (this.imageURL == null) {
            return super.getPreferredSize();
        }
        int n = this.originalImage.getWidth() / this.cellWidth;
        int n2 = this.originalImage.getHeight() / this.cellHeight;
        int n3 = this.gridWidth + (this.cellWidth + this.gridWidth) * n;
        int n4 = this.gridWidth + (this.cellHeight + this.gridWidth) * n2;
        return new Dimension(n3, n4);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.originalImage == null) {
            return;
        }
        graphics2D.clearRect(0, 0, this.getWidth(), this.getWidth());
        this.paintGridLines(graphics2D);
        this.paintCells(graphics2D);
    }

    void paintCells(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        Position position = this.getCellAtPoint(rectangle.getLocation());
        Position position2 = this.getCellAtCoordinates(rectangle.getLocation().x + rectangle.width, rectangle.getLocation().y + rectangle.height);
        for (int i = position.getRow(); i <= position2.getRow(); ++i) {
            for (int j = position.getCol(); j <= position2.getCol(); ++j) {
                Position position3 = new Position(i, j);
                this.paintCellContents(graphics2D, position3);
            }
        }
    }

    private void paintCellContents(Graphics2D graphics2D, Position position) {
        Rectangle rectangle = this.getCellArea(position);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = position.getCol() * this.cellWidth;
        int n4 = position.getRow() * this.cellHeight;
        graphics2D.drawImage(this.originalImage, n, n2, n + this.cellWidth, n2 + this.cellHeight, n3, n4, n3 + this.cellWidth, n4 + this.cellHeight, null);
    }

    private Position getCellAtPoint(Point point) {
        return this.getCellAtCoordinates(point.x, point.y);
    }

    private Position getCellAtCoordinates(int n, int n2) {
        int n3 = (n2 - this.gridWidth) / (this.cellHeight + this.gridWidth);
        int n4 = (n - this.gridWidth) / (this.cellWidth + this.gridWidth);
        if (n < 0) {
            --n4;
        }
        if (n2 < 0) {
            --n3;
        }
        return new Position(n3, n4);
    }

    private Rectangle getCellArea(Position position) {
        return this.getCellArea(position.getRow(), position.getCol());
    }

    private Rectangle getCellArea(int n, int n2) {
        Rectangle rectangle = new Rectangle((this.cellWidth + this.gridWidth) * n2 + this.gridWidth, (this.cellHeight + this.gridWidth) * n + this.gridWidth, this.cellWidth, this.cellHeight);
        return rectangle;
    }

    private void paintGridLines(Graphics2D graphics2D) {
        int n;
        for (n = 0; n < this.getPreferredSize().height; n += this.cellHeight + this.gridWidth) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, n, this.getPreferredSize().width, this.gridWidth);
        }
        for (n = 0; n < this.getPreferredSize().width; n += this.cellWidth + this.gridWidth) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(n, 0, this.gridWidth, this.getPreferredSize().height);
        }
        for (n = 0; n < this.getPreferredSize().height; n += this.cellHeight + this.gridWidth) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(1, n + 1, this.getPreferredSize().width - 2, n + 1);
        }
        for (n = 0; n < this.getPreferredSize().width; n += this.cellWidth + this.gridWidth) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n + 1, 1, n + 1, this.getPreferredSize().height - 2);
        }
    }

    public int getTileWidth() {
        return this.cellWidth;
    }

    public int getTileHeight() {
        return this.cellHeight;
    }
}

