/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutComponent
implements LayoutConstants {
    private String componentId;
    private LayoutComponent parentComponent;
    private LayoutInterval[] layoutIntervals;
    private boolean[] resizability;
    private List<LayoutInterval[]> layoutRoots;
    private List<LayoutComponent> subComponents;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int horizontalLinkId = -1;
    private int verticalLinkId = -1;

    public LayoutComponent(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.componentId = string;
        this.layoutIntervals = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            this.layoutIntervals[i] = new LayoutInterval(101);
            this.layoutIntervals[i].setComponent(this);
            this.layoutIntervals[i].setSizes(-2, -1, -2);
        }
        if (bl) {
            this.createRoots();
        }
    }

    public LayoutComponent(String string, boolean bl, int n, int n2) {
        this(string, bl);
        if (bl) {
            LayoutInterval[] layoutIntervalArray = this.layoutRoots.get(0);
            for (int i = 0; i < 2; ++i) {
                LayoutInterval layoutInterval = new LayoutInterval(101);
                layoutInterval.setSizes(0, i == 0 ? n : n2, Short.MAX_VALUE);
                layoutIntervalArray[i].add(layoutInterval, 0);
            }
        } else {
            this.layoutIntervals[0].setPreferredSize(n);
            this.layoutIntervals[1].setPreferredSize(n2);
        }
    }

    private void createRoots() {
        this.layoutRoots = new LinkedList<LayoutInterval[]>();
        this.addNewLayoutRoots();
    }

    void setId(String string) {
        this.componentId = string;
    }

    public String getId() {
        return this.componentId;
    }

    public LayoutComponent getParent() {
        return this.parentComponent;
    }

    public boolean isParentOf(LayoutComponent layoutComponent) {
        do {
            if ((layoutComponent = layoutComponent.getParent()) != this) continue;
            return true;
        } while (layoutComponent != null);
        return false;
    }

    static LayoutComponent getCommonParent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2) {
        Iterator<LayoutComponent> iterator = LayoutComponent.parentsOfComponent(layoutComponent).iterator();
        Iterator<LayoutComponent> iterator2 = LayoutComponent.parentsOfComponent(layoutComponent2).iterator();
        LayoutComponent layoutComponent3 = iterator.next();
        LayoutComponent layoutComponent4 = iterator2.next();
        LayoutComponent layoutComponent5 = null;
        while (layoutComponent3 == layoutComponent4) {
            layoutComponent5 = layoutComponent3;
            if (!iterator.hasNext()) break;
            layoutComponent3 = iterator.next();
            if (!iterator2.hasNext()) break;
            layoutComponent4 = iterator2.next();
        }
        return layoutComponent5;
    }

    private static List<LayoutComponent> parentsOfComponent(LayoutComponent layoutComponent) {
        LinkedList<LayoutComponent> linkedList = new LinkedList<LayoutComponent>();
        while (layoutComponent != null) {
            linkedList.add(0, layoutComponent);
            layoutComponent = layoutComponent.getParent();
        }
        return linkedList;
    }

    public LayoutInterval getLayoutInterval(int n) {
        return this.layoutIntervals[n];
    }

    void setLayoutInterval(LayoutInterval layoutInterval, int n) {
        this.layoutIntervals[n] = layoutInterval;
    }

    public boolean isLayoutContainer() {
        return this.layoutRoots != null;
    }

    void setResizability(boolean[] blArray) {
        this.resizability = blArray;
    }

    boolean[] getResizability() {
        return this.resizability;
    }

    LayoutInterval[] getParentRoots() {
        return this.parentComponent != null ? this.parentComponent.getLayoutRoots(this.layoutIntervals[0]) : null;
    }

    public List<LayoutComponent> getSubcomponents() {
        return this.subComponents != null && this.subComponents.size() > 0 ? Collections.unmodifiableList(this.subComponents) : Collections.EMPTY_LIST;
    }

    int getSubComponentCount() {
        return this.subComponents == null ? 0 : this.subComponents.size();
    }

    LayoutComponent getSubComponent(int n) {
        return this.subComponents.get(n);
    }

    int indexOf(LayoutComponent layoutComponent) {
        return this.subComponents != null ? this.subComponents.indexOf(layoutComponent) : -1;
    }

    int addComponent(LayoutComponent layoutComponent, int n) {
        assert (this.isLayoutContainer());
        if (this.subComponents == null) {
            this.subComponents = new LinkedList<LayoutComponent>();
        }
        if (n < 0) {
            n = this.subComponents.size();
        }
        this.subComponents.add(n, layoutComponent);
        layoutComponent.parentComponent = this;
        return n;
    }

    int removeComponent(LayoutComponent layoutComponent) {
        if (this.subComponents != null) {
            Iterator<LayoutComponent> iterator = this.subComponents.iterator();
            int n = -1;
            while (iterator.hasNext()) {
                ++n;
                if (layoutComponent != iterator.next()) continue;
                iterator.remove();
                layoutComponent.parentComponent = null;
                return n;
            }
        }
        return -1;
    }

    public int getLayoutRootCount() {
        return this.layoutRoots != null ? this.layoutRoots.size() : 0;
    }

    public LayoutInterval getLayoutRoot(int n, int n2) {
        return this.layoutRoots.get(n)[n2];
    }

    LayoutInterval getDefaultLayoutRoot(int n) {
        return this.layoutRoots.get(0)[n];
    }

    List<LayoutInterval[]> getLayoutRoots() {
        return this.layoutRoots;
    }

    void setLayoutRoots(List<LayoutInterval[]> list) {
        if (list == null && this.layoutRoots != null) {
            this.createRoots();
        } else {
            this.layoutRoots = list;
        }
    }

    LayoutInterval[] getLayoutRoots(LayoutInterval layoutInterval) {
        layoutInterval = LayoutInterval.getRoot(layoutInterval);
        for (LayoutInterval[] layoutIntervalArray : this.layoutRoots) {
            for (int i = 0; i < 2; ++i) {
                if (layoutInterval != layoutIntervalArray[i]) continue;
                return layoutIntervalArray;
            }
        }
        return null;
    }

    int getLayoutRootsIndex(LayoutInterval layoutInterval) {
        layoutInterval = LayoutInterval.getRoot(layoutInterval);
        int n = -1;
        for (LayoutInterval[] layoutIntervalArray : this.layoutRoots) {
            ++n;
            for (int i = 0; i < 2; ++i) {
                if (layoutInterval != layoutIntervalArray[i]) continue;
                return n;
            }
        }
        return -1;
    }

    void addLayoutRoots(LayoutInterval[] layoutIntervalArray, int n) {
        if (n < 0) {
            n = this.layoutRoots.size();
        }
        this.layoutRoots.add(n, layoutIntervalArray);
    }

    int removeLayoutRoots(LayoutInterval[] layoutIntervalArray) {
        Iterator<LayoutInterval[]> iterator = this.layoutRoots.iterator();
        int n = -1;
        while (iterator.hasNext()) {
            ++n;
            if (layoutIntervalArray != iterator.next()) continue;
            iterator.remove();
            return n;
        }
        return -1;
    }

    LayoutInterval[] addNewLayoutRoots() {
        LayoutInterval[] layoutIntervalArray = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            layoutIntervalArray[i] = new LayoutInterval(103);
        }
        this.layoutRoots.add(layoutIntervalArray);
        return layoutIntervalArray;
    }

    void setLayoutContainer(boolean bl, List<LayoutInterval[]> list) {
        if (bl != this.isLayoutContainer()) {
            if (bl) {
                if (list == null) {
                    this.createRoots();
                } else {
                    this.layoutRoots = list;
                }
            } else {
                this.layoutRoots = null;
                this.subComponents = null;
            }
        }
    }

    void setCurrentBounds(Rectangle rectangle, int n) {
        LayoutRegion layoutRegion = this.layoutIntervals[0].getCurrentSpace();
        layoutRegion.set(rectangle, n > 0 ? rectangle.y + n : Integer.MIN_VALUE);
        for (int i = 1; i < this.layoutIntervals.length; ++i) {
            this.layoutIntervals[i].setCurrentSpace(layoutRegion);
        }
    }

    void setCurrentInterior(Rectangle rectangle) {
        LayoutRegion layoutRegion = null;
        for (LayoutInterval[] layoutIntervalArray : this.layoutRoots) {
            for (int i = 0; i < layoutIntervalArray.length; ++i) {
                if (layoutRegion == null) {
                    layoutRegion = layoutIntervalArray[i].getCurrentSpace();
                    layoutRegion.set(rectangle, Integer.MIN_VALUE);
                    continue;
                }
                layoutIntervalArray[i].setCurrentSpace(layoutRegion);
            }
        }
    }

    public boolean isLinkSized(int n) {
        if (n == 0) {
            return -1 != this.horizontalLinkId;
        }
        return -1 != this.verticalLinkId;
    }

    public int getLinkSizeId(int n) {
        if (n == 0) {
            return this.horizontalLinkId;
        }
        return this.verticalLinkId;
    }

    public void setLinkSizeId(int n, int n2) {
        if (n2 == 0) {
            this.horizontalLinkId = n;
        } else {
            this.verticalLinkId = n;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }
}

