/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.user;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.Catalog;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UserXMLCatalog
implements CatalogReader,
CatalogWriter,
CatalogDescriptor,
EntityResolver {
    private Map publicIds;
    private List catalogListeners = new ArrayList();
    private static final String catalogResource = "xml/catalogs/UserXMLCatalog.xml";
    private static final String URI_PREFIX = "URI:";
    private static final String PUBLIC_PREFIX = "PUBLIC:";
    private static final String SYSTEM_PREFIX = "SYSTEM:";
    private static final int TYPE_PUBLIC = 0;
    private static final int TYPE_SYSTEM = 1;
    private static final int TYPE_URI = 2;

    public String resolveURI(String string) {
        return (String)this.getPublicIdMap().get(URI_PREFIX + string);
    }

    public String resolvePublic(String string) {
        return (String)this.getPublicIdMap().get(PUBLIC_PREFIX + string);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        this.getPublicIdMap();
        String string3 = null;
        if (string != null) {
            string3 = (String)this.getPublicIdMap().get(PUBLIC_PREFIX + string);
            if (string3 == null) {
                string3 = (String)this.getPublicIdMap().get(URI_PREFIX + string);
            }
        } else if (string2 != null) {
            string3 = (String)this.getPublicIdMap().get(SYSTEM_PREFIX + string2);
        }
        if (string3 != null) {
            return new InputSource(string3);
        }
        return null;
    }

    public String getSystemID(String string) {
        return (String)this.getPublicIdMap().get(string);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removeCatalogListener(CatalogListener catalogListener) {
        this.catalogListeners.remove(catalogListener);
    }

    public void addCatalogListener(CatalogListener catalogListener) {
        this.catalogListeners.add(catalogListener);
    }

    protected void fireEntryAdded(String string) {
        for (CatalogListener catalogListener : this.catalogListeners) {
            catalogListener.notifyNew(string);
        }
    }

    protected void fireEntryRemoved(String string) {
        for (CatalogListener catalogListener : this.catalogListeners) {
            catalogListener.notifyRemoved(string);
        }
    }

    protected void fireEntryUpdated(String string) {
        for (CatalogListener catalogListener : this.catalogListeners) {
            catalogListener.notifyUpdate(string);
        }
    }

    public Image getIcon(int n) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/catalog/impl/xmlCatalog.gif", (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object2;
        for (Object object2 : this.catalogListeners) {
            object2.notifyInvalidate();
        }
        object2 = FileUtil.getConfigFile((String)catalogResource);
        object2.refresh();
        UserXMLCatalog userXMLCatalog = this;
        synchronized (userXMLCatalog) {
            this.publicIds = null;
        }
    }

    public String getShortDescription() {
        return NbBundle.getMessage(UserXMLCatalog.class, (String)"HINT_userCatalog");
    }

    public Iterator getPublicIDs() {
        return this.getPublicIdMap().keySet().iterator();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UserXMLCatalog.class, (String)"LBL_userCatalog");
    }

    private synchronized Map getPublicIdMap() {
        if (this.publicIds == null) {
            try {
                FileObject fileObject = FileUtil.getConfigFile((String)catalogResource);
                this.publicIds = this.parse(fileObject);
            }
            catch (IOException iOException) {
                this.publicIds = new HashMap();
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (SAXException sAXException) {
                this.publicIds = new HashMap();
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
        }
        return this.publicIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(int n, String string, String string2) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)catalogResource);
        String string3 = this.createCatalogBuffer(fileObject);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        FileLock fileLock = fileObject.lock();
        try {
            PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            try {
                String string4;
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.indexOf("</catalog>") >= 0) {
                        switch (n) {
                            case 0: {
                                printWriter.println("  <public publicId=\"" + string + "\" uri=\"" + string2 + "\"/>");
                                this.getPublicIdMap().put(PUBLIC_PREFIX + string, string2);
                                this.fireEntryAdded(PUBLIC_PREFIX + string);
                                break;
                            }
                            case 1: {
                                printWriter.println("  <system systemId=\"" + string + "\" uri=\"" + string2 + "\"/>");
                                this.getPublicIdMap().put(SYSTEM_PREFIX + string, string2);
                                this.fireEntryAdded(SYSTEM_PREFIX + string);
                                break;
                            }
                            case 2: {
                                printWriter.println("  <uri name=\"" + string + "\" uri=\"" + string2 + "\"/>");
                                this.getPublicIdMap().put(URI_PREFIX + string, string2);
                                this.fireEntryAdded(URI_PREFIX + string);
                            }
                        }
                    }
                    printWriter.println(string4);
                }
            }
            finally {
                printWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(int n, String string) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)catalogResource);
        String string2 = this.createCatalogBuffer(fileObject);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        FileLock fileLock = fileObject.lock();
        try {
            PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            try {
                String string3;
                block11: while ((string3 = bufferedReader.readLine()) != null) {
                    switch (n) {
                        case 0: {
                            if (string3.indexOf("<public publicId=\"" + string + "\"") > 0) {
                                this.getPublicIdMap().remove(PUBLIC_PREFIX + string);
                                this.fireEntryRemoved(PUBLIC_PREFIX + string);
                                continue block11;
                            }
                            printWriter.println(string3);
                            continue block11;
                        }
                        case 1: {
                            if (string3.indexOf("<system systemId=\"" + string + "\"") > 0) {
                                this.getPublicIdMap().remove(SYSTEM_PREFIX + string);
                                this.fireEntryRemoved(SYSTEM_PREFIX + string);
                                continue block11;
                            }
                            printWriter.println(string3);
                            continue block11;
                        }
                        case 2: {
                            if (string3.indexOf("<uri name=\"" + string + "\"") > 0) {
                                this.getPublicIdMap().remove(URI_PREFIX + string);
                                this.fireEntryRemoved(URI_PREFIX + string);
                                continue block11;
                            }
                            printWriter.println(string3);
                            continue block11;
                        }
                    }
                    printWriter.println(string3);
                }
            }
            finally {
                printWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntry(int n, String string, String string2) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)catalogResource);
        String string3 = this.createCatalogBuffer(fileObject);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        FileLock fileLock = fileObject.lock();
        try {
            PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            try {
                String string4;
                block11: while ((string4 = bufferedReader.readLine()) != null) {
                    switch (n) {
                        case 0: {
                            if (string4.indexOf("<public publicId=\"" + string + "\"") > 0) {
                                printWriter.println("  <public publicId=\"" + string + "\" uri=\"" + string2 + "\"/>");
                                this.getPublicIdMap().put(PUBLIC_PREFIX + string, string2);
                                this.fireEntryUpdated(PUBLIC_PREFIX + string);
                                continue block11;
                            }
                            printWriter.println(string4);
                            continue block11;
                        }
                        case 1: {
                            if (string4.indexOf("<system systemId=\"" + string + "\"") > 0) {
                                printWriter.println("  <system systemId=\"" + string + "\" uri=\"" + string2 + "\"/>");
                                this.getPublicIdMap().put(SYSTEM_PREFIX + string, string2);
                                this.fireEntryUpdated(SYSTEM_PREFIX + string);
                                continue block11;
                            }
                            printWriter.println(string4);
                            continue block11;
                        }
                        case 2: {
                            if (string4.indexOf("<uri name=\"" + string + "\"") > 0) {
                                printWriter.println("  <uri name=\"" + string + "\" uri=\"" + string2 + "\"/>");
                                this.getPublicIdMap().put(URI_PREFIX + string, string2);
                                this.fireEntryUpdated(URI_PREFIX + string);
                                continue block11;
                            }
                            printWriter.println(string4);
                            continue block11;
                        }
                    }
                    printWriter.println(string4);
                }
            }
            finally {
                printWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private String createCatalogBuffer(FileObject fileObject) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n = bufferedInputStream.read(byArray, 0, 512)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toString("UTF-8");
    }

    private Map parse(FileObject fileObject) throws SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new OasisCatalogResolver());
            CatalogHandler catalogHandler = new CatalogHandler();
            xMLReader.setContentHandler(catalogHandler);
            xMLReader.parse(new InputSource(fileObject.getInputStream()));
            return catalogHandler.getValues();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            return new HashMap();
        }
    }

    public void registerCatalogEntry(String string, String string2) {
        this.getPublicIdMap();
        try {
            if (string.startsWith(PUBLIC_PREFIX)) {
                if (string2 != null) {
                    if (this.getPublicIdMap().get(string) != null) {
                        if (this.requestUpdate(string.substring(PUBLIC_PREFIX.length()))) {
                            this.updateEntry(0, string.substring(PUBLIC_PREFIX.length()), string2);
                        }
                    } else {
                        this.addEntry(0, string.substring(PUBLIC_PREFIX.length()), string2);
                    }
                } else {
                    this.removeEntry(0, string.substring(PUBLIC_PREFIX.length()));
                }
            } else if (string.startsWith(SYSTEM_PREFIX)) {
                if (string2 != null) {
                    if (this.getPublicIdMap().get(string) != null) {
                        if (this.requestUpdate(string.substring(SYSTEM_PREFIX.length()))) {
                            this.updateEntry(1, string.substring(SYSTEM_PREFIX.length()), string2);
                        }
                    } else {
                        this.addEntry(1, string.substring(SYSTEM_PREFIX.length()), string2);
                    }
                } else {
                    this.removeEntry(1, string.substring(SYSTEM_PREFIX.length()));
                }
            } else if (string.startsWith(URI_PREFIX)) {
                if (string2 != null) {
                    if (this.getPublicIdMap().get(string) != null) {
                        if (this.requestUpdate(string.substring(URI_PREFIX.length()))) {
                            this.updateEntry(2, string.substring(URI_PREFIX.length()), string2);
                        }
                    } else {
                        this.addEntry(2, string.substring(URI_PREFIX.length()), string2);
                    }
                } else {
                    this.removeEntry(2, string.substring(URI_PREFIX.length()));
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private boolean requestUpdate(String string) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UserXMLCatalog.class, (String)"TXT_updateEntry", (Object)string), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return NotifyDescriptor.YES_OPTION == confirmation.getValue();
    }

    private class OasisCatalogResolver
    implements EntityResolver {
        private OasisCatalogResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            if ("-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN".equals(string)) {
                URL uRL = Catalog.class.getResource("etc/catalog.dtd");
                return new InputSource(uRL.toExternalForm());
            }
            return null;
        }
    }

    private static class CatalogHandler
    extends DefaultHandler {
        private Map values = new HashMap();

        CatalogHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            if ("public".equals(string3)) {
                String string5 = attributes.getValue("publicId");
                if (string5 != null) {
                    this.values.put(UserXMLCatalog.PUBLIC_PREFIX + string5, attributes.getValue("uri"));
                }
            } else if ("system".equals(string3)) {
                String string6 = attributes.getValue("systemId");
                if (string6 != null) {
                    this.values.put(UserXMLCatalog.SYSTEM_PREFIX + string6, attributes.getValue("uri"));
                }
            } else if ("uri".equals(string3) && (string4 = attributes.getValue("name")) != null) {
                this.values.put(UserXMLCatalog.URI_PREFIX + string4, attributes.getValue("uri"));
            }
        }

        public Map getValues() {
            return this.values;
        }
    }
}

