/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ui.charts.AbstractPieChartModel;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DrillDownPieChartModel
extends AbstractPieChartModel
implements DrillDownListener {
    protected static final Logger LOGGER = Logger.getLogger(DrillDownPieChartModel.class.getName());
    private static Color[] COLORS = new Color[]{new Color(0x99FF99), new Color(0x99CC99), new Color(0x666633), new Color(0x336666), new Color(0x6699CC), new Color(0x9999CC), new Color(0xFFCCFF), new Color(0xCC9999), new Color(0x660099), new Color(26112)};
    protected DrillDown drillDown;
    private Object itemMapLock = new Object();
    private int[] itemMap = null;
    private int itemCount = 0;
    private List<Category> subCategories;

    public DrillDownPieChartModel(DrillDown drillDown) {
        this.setDrillDown(drillDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDrillDown(DrillDown drillDown) {
        if (this.drillDown != null) {
            this.drillDown.removeListener(this);
        }
        this.drillDown = drillDown;
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.drillDown.addListener(this);
    }

    public Color getItemColor(int n) {
        if (n == -1) {
            return Color.BLACK;
        }
        return COLORS[n % COLORS.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.itemCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItemDescription(int n) {
        if (n == -1 || this.getMappedIndex(n) == -1) {
            return "";
        }
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories != null) {
                return this.subCategories.get(this.getMappedIndex(n)).getLabel();
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataChanged() {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drillDownPathChanged(List list) {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drilldown(int n) {
        if (n == -1 || this.getMappedIndex(n) == -1) {
            return;
        }
        Category category = null;
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return;
            }
            category = this.subCategories.get(this.getMappedIndex(n));
        }
        if (category != null) {
            this.drillDown.drilldown(category.getId());
        }
    }

    public void drillup() {
        this.drillDown.drillup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drillup(int n) {
        if (n == -1 || this.getMappedIndex(n) == -1) {
            return;
        }
        Category category = null;
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return;
            }
            category = this.subCategories.get(this.getMappedIndex(n));
        }
        this.drillDown.drillup(category.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.drillDown != null && this.itemCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Category> getSubCategories() {
        ArrayList<Category> arrayList = new ArrayList<Category>();
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories != null) {
                arrayList.addAll(this.subCategories);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Category getCategoryAt(int n) {
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return Category.DEFAULT;
            }
            return this.subCategories.get(this.getMappedIndex(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMappedIndex(int n) {
        Object object = this.itemMapLock;
        synchronized (object) {
            if (n < 0 || n >= this.itemMap.length) {
                return -1;
            }
            return this.itemMap[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemMap() {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.subCategories = this.drillDown.getSubCategories();
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int[] nArray = new int[this.subCategories.size()];
            for (Category category : this.subCategories) {
                if (this.drillDown.getCategoryTime(category, false) > 0L) {
                    nArray[n2++] = n;
                }
                ++n;
            }
            this.itemCount = n2 > 0 ? n2 : 0;
            this.itemMap = nArray;
        }
    }
}

