/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc10;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import jmunit.framework.cldc10.AssertionFailedException;
import jmunit.framework.cldc10.ExceptionList;
import jmunit.framework.cldc10.Screen;
import jmunit.framework.cldc10.Test;
import jmunit.framework.cldc10.TestListener;

public class GuiListener
implements TestListener,
CommandListener {
    private Test testMidlet;
    private int numErrors;
    private int numFailures;
    private int numCompleted;
    private Screen screen;
    private ExceptionList list;
    private long startTime;
    private long endTime;
    private Command cmdScreenExit = new Command("Exit", 7, 0);
    private Command cmdScreenTest = new Command("Test", 4, 1);
    private Command cmdListOk = new Command("OK", 4, 0);
    private boolean running;

    public GuiListener(Test test) {
        this.testMidlet = test;
        this.screen = new Screen(test.getName(), this);
        this.screen.setCommandListener(this);
        this.screen.addCommand(this.cmdScreenExit);
        this.screen.addCommand(this.cmdScreenTest);
        Display.getDisplay((MIDlet)test).setCurrent((Displayable)this.screen);
        this.list = new ExceptionList(this);
        this.list.addCommand(this.cmdListOk);
        this.list.setCommandListener(this);
    }

    public void addError(Class clazz, String string, Throwable throwable) {
        ++this.numErrors;
        this.list.addError(string, throwable);
    }

    public void addFailure(Class clazz, String string, AssertionFailedException assertionFailedException) {
        ++this.numFailures;
        this.list.addFailure(string, assertionFailedException);
    }

    public void endTest(Class clazz, String string) {
        this.endTime = System.currentTimeMillis();
        ++this.numCompleted;
        this.screen.repaint();
        if (this.numCompleted == this.testMidlet.countTestCases()) {
            this.running = false;
            if (this.numErrors + this.numFailures > 0) {
                this.list.displayResults(this.testMidlet);
            }
        }
    }

    public void startTest(Class clazz, String string) {
    }

    public int getNumberTests() {
        return this.testMidlet.countTestCases();
    }

    public int getNumberErrors() {
        return this.numErrors;
    }

    public int getNumberCompletedTests() {
        return this.numCompleted;
    }

    public int getNumberFailures() {
        return this.numFailures;
    }

    public int getNumberSuccessful() {
        return this.numCompleted - this.numErrors - this.numFailures;
    }

    public long getRunningTime() {
        return this.endTime - this.startTime;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.equals(this.cmdListOk)) {
            Display.getDisplay((MIDlet)this.testMidlet).setCurrent((Displayable)this.screen);
            return;
        }
        if (command.equals(this.cmdScreenExit)) {
            this.testMidlet.notifyDestroyed();
            return;
        }
        if (!this.running) {
            new Thread(new Runnable(){

                public void run() {
                    GuiListener.this.testMidlet.test();
                }
            }).start();
        }
    }

    public void clear() {
        this.numErrors = 0;
        this.numFailures = 0;
        this.numCompleted = 0;
        this.endTime = this.startTime = System.currentTimeMillis();
        this.running = true;
        this.list.clearAll();
        this.screen.repaint();
    }
}

