/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.model.RubyFrame;

public class CallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private final ContextProviderWrapper contextProvider;
    private final RubySession rubySession;
    private final List<ModelListener> listeners;

    public CallStackModel(ContextProvider contextProvider) {
        this.contextProvider = new ContextProviderWrapper(contextProvider);
        this.rubySession = this.contextProvider.getRubySession();
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            return this.rubySession.getFrames();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof RubyFrame) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return this.rubySession.getFrames().length;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(CallStackModel.class, (String)"CTL_CallstackModel.Column.Name.Name");
        }
        if (object instanceof RubyFrame) {
            RubyFrame rubyFrame = (RubyFrame)object;
            String string = new File(rubyFrame.getFile()).getName();
            String string2 = string + ':' + rubyFrame.getLine();
            return this.rubySession.isSelectedFrame(rubyFrame) ? "<html><b>" + string2 + "</b></html>" : string2;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof RubyFrame) {
            if (this.rubySession.isSelectedFrame((RubyFrame)object)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (object == "Root") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(CallStackModel.class, (String)"CTL_CallstackModel.Column.Name.Desc");
        }
        if (object instanceof RubyFrame) {
            return ((RubyFrame)object).getName();
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (!(object instanceof RubyFrame)) {
            throw new UnknownTypeException(object);
        }
        RubyFrame rubyFrame = (RubyFrame)object;
        EditorUtil.showLine(EditorUtil.getLineAnnotable(this.rubySession.resolveAbsolutePath(rubyFrame.getFile()), rubyFrame.getLine() - 1));
        this.rubySession.selectFrame(rubyFrame);
        this.fireChanges();
        this.contextProvider.getVariablesModel().fireChanges();
        this.contextProvider.getWatchesModel().fireChanges();
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (string == "CallStackFrameLocation" && object instanceof RubyFrame) {
            RubyFrame rubyFrame = (RubyFrame)object;
            return rubyFrame.getFile();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (string == "CallStackFrameLocation" && object instanceof RubyFrame) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }
}

