/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.ImageEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorImage
extends PropertyEditorUserCode
implements PropertyEditorElement,
PropertyEditorResourceElementListener {
    private JRadioButton radioButton;
    private ImageEditorElement element;
    private String resourcePath = "";
    private WeakReference<DesignComponent> component;

    private PropertyEditorImage() {
        super(NbBundle.getMessage(PropertyEditorImage.class, (String)"LBL_IMAGE_UCLABEL"));
    }

    public static PropertyEditorImage createInstance() {
        return new PropertyEditorImage();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.element != null) {
            this.element.clean(designComponent);
            this.element = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorImage.class, (String)"LBL_IMAGE_STR"));
        this.element = new ImageEditorElement();
        this.element.addPropertyEditorResourceElementListener(this);
    }

    public Component getCustomEditor() {
        DesignComponent designComponent = null;
        if (this.component != null && this.component.get() != null) {
            designComponent = (DesignComponent)this.component.get();
        }
        if (this.element == null) {
            this.initComponents();
            if (designComponent != null) {
                this.element.init(designComponent.getDocument());
            }
            this.initElements(Collections.singleton(this));
        }
        this.element.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper(designComponent));
        return super.getCustomEditor();
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.resourcePath);
        }
    }

    public void updateState(PropertyValue propertyValue) {
        if (propertyValue == null) {
            this.element.setDesignComponentWrapper(null);
        } else if (this.component != null && this.component.get() != null) {
            this.element.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper((DesignComponent)this.component.get()));
        }
        this.element.setAllEnabled(true);
    }

    public void setAsText(String string) {
        this.saveValue(string);
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return MidpTypes.getString(propertyValue);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public JComponent getCustomEditorComponent() {
        return this.element;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public void elementChanged(PropertyEditorResourceElementEvent propertyEditorResourceElementEvent) {
        PropertyValue propertyValue = propertyEditorResourceElementEvent.getPropertyValue();
        this.resourcePath = MidpTypes.getString(propertyValue);
        if (this.resourcePath == null) {
            this.resourcePath = "";
        }
        this.radioButton.setSelected(true);
    }

    public void setValue(Object object) {
        super.setValue(object);
    }

    private void saveValue(String string) {
        super.setValue((Object)MidpTypes.createStringValue(string));
    }

    public void init(DesignComponent designComponent) {
        this.component = new WeakReference<DesignComponent>(designComponent);
        super.init(designComponent);
    }
}

