/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.WebServiceDataProvider;
import org.netbeans.modules.websvc.project.spi.WebServiceFactory;
import org.netbeans.modules.websvc.project.spi.WebServiceImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenJaxWsServicesProvider
implements WebServiceDataProvider,
PropertyChangeListener {
    private JAXWSLightSupport jaxWsSupport;
    private Project prj;
    private List<WebService> providers = new LinkedList<WebService>();
    private List<WebService> consumers = new LinkedList<WebService>();

    public MavenJaxWsServicesProvider(Project project, JAXWSLightSupport jAXWSLightSupport) {
        this.jaxWsSupport = jAXWSLightSupport;
        this.prj = project;
        jAXWSLightSupport.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public List<WebService> getServiceProviders() {
        return this.providers;
    }

    public List<WebService> getServiceConsumers() {
        return this.consumers;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.jaxWsSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.jaxWsSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block6: {
            block7: {
                if (!"service-added".equals(propertyChangeEvent.getPropertyName())) break block7;
                MavenWebService mavenWebService = new MavenWebService((JaxWsService)propertyChangeEvent.getNewValue(), this.prj);
                WebService webService = WebServiceFactory.createWebService((WebServiceImplementation)mavenWebService);
                if (webService.isServiceProvider()) {
                    this.providers.add(webService);
                } else {
                    this.consumers.add(webService);
                }
                break block6;
            }
            if (!"service-removed".equals(propertyChangeEvent.getPropertyName())) break block6;
            JaxWsService jaxWsService = (JaxWsService)propertyChangeEvent.getOldValue();
            if (jaxWsService.isServiceProvider()) {
                String string = jaxWsService.getImplementationClass();
                for (WebService webService : this.providers) {
                    if (!string.equals(webService.getIdentifier())) continue;
                    this.providers.remove(webService);
                    break;
                }
            } else {
                String string = jaxWsService.getId();
                for (WebService webService : this.consumers) {
                    if (string == null || !string.equals(webService.getIdentifier())) continue;
                    this.consumers.remove(webService);
                    break;
                }
            }
        }
    }
}

