/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.httpserver.HostPropertyCustomEditor;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class HostPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private PropertyEnv env;

    private static String localhost() {
        return NbBundle.getMessage(HostPropertyEditor.class, (String)"CTL_Local_host");
    }

    private static String anyhost() {
        return NbBundle.getMessage(HostPropertyEditor.class, (String)"CTL_Any_host");
    }

    public String getAsText() {
        HttpServerSettings.HostProperty hostProperty = (HttpServerSettings.HostProperty)this.getValue();
        if (hostProperty == null) {
            return "";
        }
        String string = hostProperty.getHost();
        if (string.equals("local")) {
            return HostPropertyEditor.localhost() + hostProperty.getGrantedAddresses();
        }
        return HostPropertyEditor.anyhost();
    }

    public void setAsText(String string) {
        if (HostPropertyEditor.anyhost().equals(string)) {
            this.setValue(new HttpServerSettings.HostProperty("", "any"));
            return;
        }
        if (string != null && string.startsWith(HostPropertyEditor.localhost())) {
            this.setValue(new HttpServerSettings.HostProperty(string.substring(HostPropertyEditor.localhost().length()), "local"));
            return;
        }
        if (string != null) {
            this.setValue(new HttpServerSettings.HostProperty(string, "local"));
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new HostPropertyCustomEditor(this, this.env);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }
}

