/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.properties;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JTableOperator;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;

public class Property {
    public static final String STRING_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$StringRenderer";
    public static final String CHECKBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$CheckboxRenderer";
    public static final String COMBOBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$ComboboxRenderer";
    public static final String RADIOBUTTON_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$RadioButtonRenderer";
    public static final String SET_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$SetRenderer";
    protected Node.Property property;
    protected PropertySheetOperator propertySheetOper;

    public Property(PropertySheetOperator propertySheetOperator, String string) {
        this.propertySheetOper = propertySheetOperator;
        this.property = this.waitProperty(propertySheetOperator, string);
    }

    public Property(PropertySheetOperator propertySheetOperator, int n) {
        this.propertySheetOper = propertySheetOperator;
        this.property = this.waitProperty(propertySheetOperator, n);
    }

    private Node.Property waitProperty(final PropertySheetOperator propertySheetOperator, final String string) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    Node.Property property = null;
                    JTableOperator jTableOperator = propertySheetOperator.tblSheet();
                    for (int i = 0; i < jTableOperator.getRowCount(); ++i) {
                        if (!(jTableOperator.getValueAt(i, 1) instanceof Node.Property)) continue;
                        property = (Node.Property)jTableOperator.getValueAt(i, 1);
                        if (!propertySheetOperator.getComparator().equals(property.getDisplayName(), string)) continue;
                        return property;
                    }
                    return null;
                }

                public String getDescription() {
                    return "Wait property " + string;
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    private Node.Property waitProperty(final PropertySheetOperator propertySheetOperator, final int n) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    JTableOperator jTableOperator = propertySheetOperator.tblSheet();
                    if (jTableOperator.getRowCount() <= n) {
                        return null;
                    }
                    Object object2 = jTableOperator.getValueAt(n, 1);
                    if (object2 instanceof Node.Property) {
                        return (Node.Property)object2;
                    }
                    throw new JemmyException("On row " + n + " in table there is no property");
                }

                public String getDescription() {
                    return "Wait property on row " + n + " in property sheet.";
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public String getValue() {
        return this.getPropertyEditor().getAsText();
    }

    public void setValue(final String string) {
        this.propertySheetOper.getOutput().printTrace("Setting value \"" + string + "\" of property \"" + this.getName() + "\".");
        if (!this.isEnabled()) {
            throw new JemmyException("Property \"" + this.getName() + "\" is read only.");
        }
        final PropertyEditor propertyEditor = this.getPropertyEditor();
        new QueueTool().invokeSmoothly(new Runnable(){

            public void run() {
                try {
                    propertyEditor.setAsText(string);
                    Property.this.property.setValue(propertyEditor.getValue());
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().notify(256, (Throwable)illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(256, (Throwable)illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(256, (Throwable)invocationTargetException);
                }
                catch (Exception exception) {
                    throw new JemmyException("Exception while setting value of property.", (Throwable)exception);
                }
            }
        });
    }

    public void setValue(int n) {
        String[] stringArray = this.getPropertyEditor().getTags();
        if (stringArray == null) {
            throw new JemmyException("Property doesn't support changing value by index.");
        }
        this.setValue(stringArray[n]);
    }

    public void openEditor() {
        if (this.supportsCustomEditor()) {
            final JTableOperator jTableOperator = this.propertySheetOper.tblSheet();
            jTableOperator.makeComponentVisible();
            jTableOperator.requestFocus();
            jTableOperator.waitHasFocus();
            new Thread(new Runnable(){

                public void run() {
                    new QueueTool().invokeSmoothly(new Runnable(){

                        public void run() {
                            ((JTable)jTableOperator.getSource()).changeSelection(Property.this.getRow(), 0, false, false);
                            Action action = ((JComponent)jTableOperator.getSource()).getActionMap().get("invokeCustomEditor");
                            action.actionPerformed(new ActionEvent(jTableOperator.getSource(), 0, null));
                        }
                    });
                }
            }, "Thread to open custom editor no block").start();
            return;
        }
    }

    public boolean supportsCustomEditor() {
        return this.getPropertyEditor().supportsCustomEditor();
    }

    public void setDefaultValue() {
        try {
            this.property.restoreDefaultValue();
        }
        catch (Exception exception) {
            throw new JemmyException("Exception while restoring default value.", (Throwable)exception);
        }
    }

    public boolean isEnabled() {
        return this.property.canWrite();
    }

    public boolean canEditAsText() {
        if (this.property.canRead() && this.property.canWrite()) {
            Boolean bl = (Boolean)this.property.getValue("canEditAsText");
            if (bl != null) {
                return bl;
            }
            PropertyEditor propertyEditor = this.getPropertyEditor();
            if (propertyEditor instanceof EnhancedPropertyEditor && propertyEditor.getTags() != null) {
                return ((EnhancedPropertyEditor)propertyEditor).supportsEditingTaggedValues();
            }
            return propertyEditor.getTags() == null;
        }
        return false;
    }

    public String getRendererName() {
        return this.getRenderer().getClass().getName();
    }

    private Component getRenderer() {
        JTableOperator jTableOperator = this.propertySheetOper.tblSheet();
        int n = this.getRow();
        TableCellRenderer tableCellRenderer = jTableOperator.getCellRenderer(n, 1);
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)jTableOperator.getSource(), jTableOperator.getValueAt(n, 1), false, false, n, 1);
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.RendererPropertyDisplayer");
            Method method = clazz.getDeclaredMethod("findInnermostRenderer", JComponent.class);
            method.setAccessible(true);
            component = (Component)method.invoke(null, component);
        }
        catch (Exception exception) {
            throw new JemmyException("RendererPropertyDisplayer.findInnermostRenderer() by reflection failed.", (Throwable)exception);
        }
        return component;
    }

    public String getShortDescription() {
        return this.property.getShortDescription();
    }

    public int getRow() {
        JTableOperator jTableOperator = this.propertySheetOper.tblSheet();
        for (int i = 0; i < jTableOperator.getRowCount(); ++i) {
            if (!(jTableOperator.getValueAt(i, 1) instanceof Node.Property) || this.property != (Node.Property)jTableOperator.getValueAt(i, 1)) continue;
            return i;
        }
        throw new JemmyException("Cannot determine row number of property \"" + this.getName() + "\"");
    }

    private PropertyEditor getPropertyEditor() {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropUtils");
            Method method = clazz.getDeclaredMethod("getPropertyEditor", Node.Property.class);
            method.setAccessible(true);
            return (PropertyEditor)method.invoke(null, this.property);
        }
        catch (Exception exception) {
            throw new JemmyException("PropUtils.getPropertyEditor() by reflection failed.", (Throwable)exception);
        }
    }

    static {
        JellyVersion.checkJemmyVersion();
    }
}

