/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheIndex {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.turbo.CacheIndex");
    private Map<File, Set<File>> index = new ConcurrentHashMap<File, Set<File>>();

    protected abstract boolean isManaged(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] get(File file) {
        LOG.log(Level.FINE, "get({0})", new Object[]{file});
        if (file == null) {
            return new File[0];
        }
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<File> set = this.index.get(file);
            if (set == null) {
                LOG.log(Level.FINE, " get({0}) returns no files", new Object[]{file});
                return new File[0];
            }
            LOG.log(Level.FINE, " get({0}) returns {1}", new Object[]{file, set.size()});
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("   " + set);
            }
            return set.toArray(new File[set.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getAllValues() {
        ArrayList<Set<File>> arrayList;
        LOG.fine("getAllValues()");
        Object object = this;
        synchronized (object) {
            Collection<Set<File>> collection = this.index.values();
            arrayList = new ArrayList<Set<File>>(collection.size());
            arrayList.addAll(collection);
        }
        object = new HashSet();
        for (Set set : arrayList) {
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                object.addAll(set);
            }
        }
        LOG.log(Level.FINE, " getAllValues() returns {0}", new Object[]{object.size()});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + object);
        }
        return object.toArray(new File[object.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file) {
        LOG.log(Level.FINE, "add({0})", new Object[]{file});
        assert (file != null);
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<File> set = this.index.get(file2);
            if (set == null) {
                LOG.log(Level.FINER, "  add({0}) - creating new file entry", new Object[]{file});
                set = Collections.synchronizedSet(new HashSet());
                set.add(file);
                this.index.put(file2, set);
            } else {
                set.add(file);
            }
            this.ensureParents(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, Set<File> set) {
        LOG.log(Level.FINE, "add({0}, Set<File>)", new Object[]{file});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + set);
        }
        if (set == null) {
            set = new HashSet<File>(0);
        }
        HashSet<File> hashSet = new HashSet<File>(set.size());
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<File> set2 = this.index.get(file);
            if (set2 != null) {
                for (File file2 : set2) {
                    if (set.contains(file2) || this.index.get(file2) == null) continue;
                    hashSet.add(file2);
                }
            }
            hashSet.addAll(set);
            LOG.log(Level.FINE, "  add({0}, Set<File>) - add entries", new Object[]{file});
            this.index.put(file, Collections.synchronizedSet(hashSet));
            if (hashSet.size() > 0) {
                this.ensureParents(file);
            } else {
                this.cleanUpParents(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParents(File file) {
        File file2 = file;
        LOG.log(Level.FINE, "  ensureParents({0})", new Object[]{file2});
        while (true) {
            File file3 = file.getParentFile();
            LOG.log(Level.FINE, "  ensureParents({0}) - parent {1}", new Object[]{file2, file3});
            if (file3 == null) {
                LOG.log(Level.FINE, "  ensureParents({0}) - done", new Object[]{file2, file3});
                break;
            }
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                Set<File> set = this.index.get(file3);
                if (set == null) {
                    LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - no entry", new Object[]{file2, file3});
                    if (!this.isManaged(file3)) {
                        LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - not managed - done!", new Object[]{file2, file3});
                        break;
                    }
                    set = new HashSet<File>();
                    LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - creating parent node", new Object[]{file2, file3});
                    this.index.put(file3, set);
                }
                LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - adding file {2}", new Object[]{file2, file3, file});
                set.add(file);
            }
            file = file3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpParents(File file) {
        File file2 = file;
        LOG.log(Level.FINE, "  cleanUpParents({0})", new Object[]{file2});
        Set<File> set = this.index.get(file);
        if (set != null && set.size() > 0) {
            LOG.log(Level.FINE, "  cleanUpParents({0}) - children underneath. stop.", new Object[]{file2});
            return;
        }
        LOG.log(Level.FINE, "  cleanUpParents({0}) - removing node", new Object[]{file2});
        this.index.remove(file);
        while (true) {
            File file3 = file.getParentFile();
            LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1}", new Object[]{file2, file3});
            if (file3 == null) {
                LOG.log(Level.FINE, "  cleanUpParents({0}) - done", new Object[]{file2, file3});
                break;
            }
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                set = this.index.get(file3);
                if (set == null) {
                    LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} empty - stop", new Object[]{file2, file3});
                    break;
                }
                if (set.size() == 1) {
                    Iterator<File> iterator = set.iterator();
                    if (this.index.get(iterator.next()) != null) {
                        break;
                    }
                } else {
                    LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} - remove file {2}", new Object[]{file2, file3, file});
                    if (this.index.get(file) != null) {
                        break;
                    }
                    set.remove(file);
                    break;
                }
                LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} size 1 - remove", new Object[]{file2, file3});
                this.index.remove(file3);
            }
            file = file3;
        }
    }
}

