/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.classdata;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodData {
    private final String name;
    private final String parentClassName;
    private final ClassData returnType;
    private final List<MethodParameter> parameters;
    private int requestID;
    private boolean isValidReturnType;
    private List<MethodParameter> myInvalidParameters;
    private String myFQNReturnType;

    public MethodData(String string, String string2, ClassData classData, List<MethodParameter> list) {
        this.name = string2;
        this.parentClassName = string;
        this.returnType = classData;
        this.parameters = list;
        this.isValidReturnType = true;
    }

    public MethodData(String string, String string2, String string3, List<MethodParameter> list, boolean bl, List<MethodParameter> list2) {
        this(string, string2, null, list);
        this.isValidReturnType = bl;
        this.myInvalidParameters = list2;
        this.myFQNReturnType = string3;
    }

    public String getName() {
        return this.name;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public ClassData getReturnType() {
        return this.returnType;
    }

    public boolean isValidReturnType() {
        return this.isValidReturnType;
    }

    public List<MethodParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<MethodParameter> getInvalidParameters() {
        if (this.myInvalidParameters == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.myInvalidParameters);
    }

    public void setRequestID(int n) {
        this.requestID = n;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public String getReturnTypeAsText() {
        if (this.myFQNReturnType == null) {
            return this.getReturnType() == null ? null : this.getReturnType().getFullyQualifiedName();
        }
        return this.myFQNReturnType;
    }

    public boolean equalsFQN(MethodData methodData) {
        if (!methodData.getParentClassName().equals(this.parentClassName)) {
            return false;
        }
        if (!methodData.getName().equals(this.name)) {
            return false;
        }
        if (this.returnType == null || methodData.getReturnType() == null) {
            return this.getReturnTypeAsText().equals(methodData.getReturnTypeAsText());
        }
        if (!methodData.getReturnType().equals(this.returnType)) {
            return false;
        }
        if (methodData.getParameters().size() != this.parameters.size()) {
            return false;
        }
        int n = 0;
        for (MethodParameter methodParameter : this.parameters) {
            if (!methodData.getParameters().get(n).equalsFQN(methodParameter)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MethodData)) {
            return false;
        }
        MethodData methodData = (MethodData)object;
        if (!methodData.getParentClassName().equals(this.parentClassName)) {
            return false;
        }
        if (!methodData.getName().equals(this.name)) {
            return false;
        }
        if (!methodData.getReturnType().equals(this.returnType)) {
            return false;
        }
        if (methodData.getParameters().size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (methodData.getParameters().get(i).equals(this.parameters.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.returnType != null) {
            if (this.myFQNReturnType == null) {
                return this.parentClassName.hashCode() + 7 * this.name.hashCode() + 13 * this.returnType.hashCode() + 17 * this.paramsHashCode();
            }
            return this.parentClassName.hashCode() + 7 * this.name.hashCode() + 13 * this.returnType.hashCode() + 17 * this.paramsHashCode() + 31 * this.myFQNReturnType.hashCode();
        }
        return this.parentClassName.hashCode() + 7 * this.name.hashCode() + 13 * this.paramsHashCode();
    }

    private int paramsHashCode() {
        if (this.parameters == null) {
            return 0;
        }
        int n = 0;
        for (MethodParameter methodParameter : this.parameters) {
            n = 31 * n + methodParameter.hashCode();
        }
        return n;
    }
}

